/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.DocumentedStreamStarTableWriter;
import uk.ac.starlink.util.ConfigMethod;

public class LatexTableWriter
extends DocumentedStreamStarTableWriter {
    private boolean standalone;

    public LatexTableWriter() {
        this(false);
    }

    public LatexTableWriter(boolean standalone) {
        super(new String[]{"tex"});
        this.setStandalone(standalone);
    }

    @ConfigMethod(property="standalone", doc="<p>If true, the output is a freestanding LaTeX document consisting of a <code>tabular</code> environment within a <code>table</code> within a <code>document</code>. If false, the output is just a <code>tabular</code> environment.</p>")
    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    @Override
    public String getFormatName() {
        return this.standalone ? "LaTeX-document" : "LaTeX";
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public boolean docIncludesExample() {
        return true;
    }

    @Override
    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>Writes a table as a LaTeX <code>tabular</code> environment,", "suitable for insertion into a document intended for publication.", "This is only likely to be useful for fairly small tables.", "</p>", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTable(StarTable startab, OutputStream ostrm) throws IOException {
        StringBuffer tfmt = new StringBuffer("|");
        ColumnInfo[] colinfos = Tables.getColumnInfos(startab);
        int ncol = colinfos.length;
        int[] maxWidths = new int[ncol];
        for (int i = 0; i < ncol; ++i) {
            ColumnInfo colinfo = colinfos[i];
            Class<?> clazz = colinfo.getContentClass();
            if (Number.class.isAssignableFrom(clazz)) {
                tfmt.append('r');
                maxWidths[i] = 32;
            } else {
                tfmt.append('l');
                maxWidths[i] = 256;
            }
            tfmt.append('|');
        }
        try (RowSequence rseq = startab.getRowSequence();){
            if (this.standalone) {
                this.printHeader(ostrm, startab);
            }
            this.printLine(ostrm, "\\begin{tabular}{" + tfmt + "}");
            this.printLine(ostrm, "\\hline");
            for (int i = 0; i < ncol; ++i) {
                boolean first = i == 0;
                boolean last = i == ncol - 1;
                ColumnInfo colinfo = colinfos[i];
                String line = new StringBuffer().append("  \\multicolumn{1}{").append(first ? "|" : "").append('c').append("|").append("}{").append(this.escape(colinfo.getName())).append("} ").append(last ? "\\\\" : "&").toString();
                this.printLine(ostrm, line);
            }
            this.printLine(ostrm, "\\hline");
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                this.print(ostrm, "  ");
                for (int i = 0; i < ncol; ++i) {
                    String datum = colinfos[i].formatValue(row[i], maxWidths[i]);
                    if (i > 0) {
                        this.print(ostrm, " & ");
                    }
                    this.print(ostrm, this.escape(datum));
                }
                this.printLine(ostrm, "\\\\");
            }
            this.print(ostrm, "\\hline");
            this.printLine(ostrm, "\\end{tabular}");
            if (this.standalone) {
                this.printFooter(ostrm, startab);
            }
        }
    }

    protected void printHeader(OutputStream ostrm, StarTable startab) throws IOException {
        this.printLine(ostrm, "\\documentclass{article}");
        this.printLine(ostrm, "\\begin{document}");
        this.printLine(ostrm, "\\begin{table}");
    }

    protected void printFooter(OutputStream ostrm, StarTable startab) throws IOException {
        String tname = startab.getName();
        if (tname != null && tname.trim().length() > 0) {
            this.printLine(ostrm, "\\caption{" + this.escape(tname) + "}");
        }
        this.printLine(ostrm, "\\end{table}");
        this.printLine(ostrm, "\\end{document}");
    }

    private void printLine(OutputStream ostrm, String line) throws IOException {
        this.print(ostrm, line);
        ostrm.write(10);
    }

    private void print(OutputStream ostrm, String str) throws IOException {
        ostrm.write(str.getBytes());
    }

    private String escape(String line) {
        StringBuffer sbuf = new StringBuffer();
        block4: for (int i = 0; i < line.length(); ++i) {
            char chr = line.charAt(i);
            switch (chr) {
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '_': 
                case '{': 
                case '}': {
                    sbuf.append('\\').append(chr);
                    continue block4;
                }
                case '\\': 
                case '^': 
                case '~': {
                    sbuf.append("\\verb+").append(chr).append('+');
                    continue block4;
                }
                default: {
                    sbuf.append(chr > '\u0000' && chr < '\u007f' ? chr : (char)'?');
                }
            }
        }
        return sbuf.toString();
    }
}

