/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.ErrorMode;
import uk.ac.starlink.table.formats.LineSequence;

class MrtReader
implements RowSequence {
    private final InputStream in_;
    private final ErrorMode errorMode_;
    private final LineSequence lseq_;
    private final ColumnReader<?>[] colReaders_;
    private final Pattern lineRegex_;
    private final DescribedValue[] params_;
    private boolean dataStarted_;
    private String dataLine_;
    private long irow_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.formats");
    private static final int MAX_METALINE = 1000;
    private static final Predicate<String> IS_DASHLINE = txt -> txt.matches("-----+-----\\s*");
    private static final Pattern ANY_REGEX = Pattern.compile(".*");
    private static final Pattern BLANK_REGEX = Pattern.compile("[?]=([^ ]+) +(.*)");
    private static final Pattern PARAM_REGEX = Pattern.compile("(^[A-Za-z]+): +([^ ].*)");
    private static final Pattern BB_REGEX = Pattern.compile("[Bb]yte-by-byte [Dd]escription.*");
    private static final Pattern BBF_REGEX = Pattern.compile("[Bb]yte-by-byte [Dd]escription of file: +([^ ]+).*");

    public MrtReader(InputStream in, ErrorMode errorMode, boolean useFloat) throws IOException {
        this.in_ = in;
        this.errorMode_ = errorMode;
        this.lseq_ = new LineSequence(in);
        this.irow_ = -1L;
        String[] preLines = MrtReader.linesUntil(this.lseq_, line -> BB_REGEX.matcher((CharSequence)line).matches());
        Matcher fnameMatcher = BBF_REGEX.matcher(preLines[preLines.length - 1]);
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        if (fnameMatcher.matches()) {
            paramMap.put("filename", fnameMatcher.group(1));
        }
        paramMap.putAll(MrtReader.readParams(preLines));
        this.params_ = paramMap.entrySet().stream().map(ent -> new DescribedValue(new DefaultValueInfo((String)ent.getKey(), String.class, null), ent.getValue())).collect(Collectors.toList()).toArray(new DescribedValue[0]);
        MrtReader.linesUntil(this.lseq_, IS_DASHLINE);
        MrtReader.linesUntil(this.lseq_, IS_DASHLINE);
        String[] fmtLines = MrtReader.linesUntil(this.lseq_, IS_DASHLINE);
        ArrayList rdrList = new ArrayList();
        int nl = fmtLines.length - 1;
        for (int il = 0; il < nl; ++il) {
            ParsedFormatLine pfl = new ParsedFormatLine(fmtLines[il]);
            StringBuffer extraTxt = new StringBuffer();
            while (il + 1 < nl && !ParsedFormatLine.isFormatLine(fmtLines[il + 1]) && fmtLines[il + 1].startsWith("       ") && fmtLines[il + 1].trim().length() > 0) {
                extraTxt.append(' ').append(fmtLines[il + 1].trim());
                ++il;
            }
            rdrList.add(MrtReader.createColumnReader(pfl, extraTxt.toString(), useFloat));
        }
        this.colReaders_ = rdrList.toArray(new ColumnReader[0]);
        this.lineRegex_ = MrtReader.createLinePattern(this.colReaders_, this.errorMode_);
    }

    public DescribedValue[] getParameters() {
        return this.params_;
    }

    public int getColumnCount() {
        return this.colReaders_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colReaders_[icol].info_;
    }

    @Override
    public boolean next() throws IOException {
        this.dataLine_ = this.lseq_.nextLine();
        while (!this.dataStarted_ && this.dataLine_ != null && this.dataLine_.startsWith("Note (")) {
            MrtReader.linesUntil(this.lseq_, IS_DASHLINE);
            this.dataLine_ = this.lseq_.nextLine();
        }
        this.dataStarted_ = true;
        ++this.irow_;
        if (this.dataLine_ != null && this.errorMode_.isReport() && !this.lineRegex_.matcher(this.dataLine_).matches()) {
            this.errorMode_.report("Input line does not match format: \"" + this.dataLine_ + "\"");
        }
        return this.dataLine_ != null;
    }

    @Override
    public Object getCell(int icol) throws IOException {
        ColumnReader<?> crdr = this.colReaders_[icol];
        try {
            return crdr.readCell(this.dataLine_);
        }
        catch (RuntimeException e) {
            if (this.errorMode_.isReport()) {
                this.errorMode_.report(new StringBuffer().append("Cell read failure at row ").append(this.irow_).append(" for column ").append(crdr.info_.getName()).append(": ").append('\"').append(crdr.cellText(this.dataLine_)).append('\"').toString());
            }
            return null;
        }
    }

    @Override
    public Object[] getRow() throws IOException {
        int ncol = this.colReaders_.length;
        Object[] row = new Object[ncol];
        for (int ic = 0; ic < ncol; ++ic) {
            row[ic] = this.getCell(ic);
        }
        return row;
    }

    @Override
    public void close() throws IOException {
        this.in_.close();
    }

    private static String[] linesUntil(LineSequence lseq, Predicate<String> lineTest) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        int il = 0;
        do {
            line = lseq.nextLine();
            lines.add(line);
            if (line == null) {
                throw new TableFormatException("End of file while scanning MRT headers");
            }
            if (++il <= 1000) continue;
            throw new TableFormatException("Too many lines in MRT headers");
        } while (!lineTest.test(line));
        return lines.toArray(new String[0]);
    }

    private static ColumnReader<?> createColumnReader(ParsedFormatLine fmt, String extraExplanation, boolean useFloat) throws TableFormatException {
        char fmtChar = fmt.fmtWord_.charAt(0);
        int iStart0 = fmt.iStart_ - 1;
        int iEnd0 = fmt.iEnd_;
        int nchr = iEnd0 - iStart0;
        String explanTxt = fmt.explanation_ + extraExplanation;
        ParsedExplanation parsedExplan = MrtReader.parseExplanation(explanTxt);
        String blankTxt = parsedExplan.blankTxt_;
        ColumnInfo info = new ColumnInfo(fmt.label_, Object.class, parsedExplan.description_);
        if (fmt.unit_ != null && fmt.unit_.trim().length() > 0 && !MrtReader.allDash(fmt.unit_)) {
            info.setUnitString(fmt.unit_);
        }
        if ('A' == fmtChar) {
            return new ColumnReader<String>(String.class, info, iStart0, iEnd0, blankTxt, txt -> txt);
        }
        if ('I' == fmtChar) {
            if (nchr <= 4) {
                return new ColumnReader<Short>(Short.class, info, iStart0, iEnd0, blankTxt, Short::valueOf);
            }
            if (nchr <= 9) {
                return new ColumnReader<Integer>(Integer.class, info, iStart0, iEnd0, blankTxt, Integer::valueOf);
            }
            return new ColumnReader<Long>(Long.class, info, iStart0, iEnd0, blankTxt, Long::valueOf);
        }
        if ('E' == fmtChar || 'F' == fmtChar) {
            int nsf;
            int n = nsf = 'E' == fmtChar ? nchr - 2 : nchr;
            if (useFloat && nsf <= 6) {
                return new ColumnReader<Float>(Float.class, info, iStart0, iEnd0, blankTxt, MrtReader::readFloat);
            }
            return new ColumnReader<Double>(Double.class, info, iStart0, iEnd0, blankTxt, Double::valueOf);
        }
        throw new AssertionError((Object)("Bad format char '" + fmtChar + "'??"));
    }

    private static boolean allDash(CharSequence txt) {
        int leng = txt.length();
        for (int i = 0; i < leng; ++i) {
            if (txt.charAt(i) == '-') continue;
            return false;
        }
        return leng > 0;
    }

    private static Map<String, String> readParams(String[] lines) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int nl = lines.length;
        for (int il = 0; il < nl; ++il) {
            Matcher matcher = PARAM_REGEX.matcher(lines[il]);
            if (!matcher.matches()) continue;
            String key = matcher.group(1);
            StringBuffer vbuf = new StringBuffer(matcher.group(2).trim());
            while (il + 1 < nl && lines[il + 1].startsWith(" ") && lines[il + 1].trim().length() > 0) {
                vbuf.append(' ').append(lines[il + 1].trim());
                ++il;
            }
            map.put(key, vbuf.toString());
        }
        return map;
    }

    private static Pattern createLinePattern(ColumnReader<?>[] crdrs, ErrorMode errorMode) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        for (ColumnReader<?> crdr : crdrs) {
            if (sbuf.length() > crdr.iStart0_) {
                errorMode.report("Byte positions out of sequence");
                return ANY_REGEX;
            }
            while (sbuf.length() < crdr.iStart0_) {
                sbuf.append(' ');
            }
            if (sbuf.length() > crdr.iEnd0_) {
                errorMode.report("Byte positions out of sequence");
                return ANY_REGEX;
            }
            while (sbuf.length() < crdr.iEnd0_) {
                sbuf.append('.');
            }
        }
        sbuf.append("\\s*");
        return Pattern.compile(sbuf.toString());
    }

    private static float readFloat(String txt) {
        double d;
        float f = Float.valueOf(txt).floatValue();
        if (Float.isInfinite(f) && !Double.isInfinite(d = Double.valueOf(txt).doubleValue())) {
            throw new RuntimeException("Large value " + d + "can't be represented in float column");
        }
        return f;
    }

    private static ParsedExplanation parseExplanation(String expTxt) {
        Matcher matcher = BLANK_REGEX.matcher(expTxt);
        if (matcher.matches()) {
            String blankTxt = matcher.group(1);
            String descrip = matcher.group(2);
            return new ParsedExplanation(descrip, "\"\"".equals(blankTxt) ? null : blankTxt);
        }
        return new ParsedExplanation(expTxt, null);
    }

    private static class ColumnReader<T> {
        final ColumnInfo info_;
        final int iStart0_;
        final int iEnd0_;
        final Function<String, T> readCell_;
        final Predicate<String> isBlank_;

        ColumnReader(Class<T> clazz, ColumnInfo info, int iStart0, int iEnd0, String blankTxt, Function<String, T> readCell) {
            info.setContentClass(clazz);
            this.info_ = info;
            this.iStart0_ = iStart0;
            this.iEnd0_ = iEnd0;
            this.readCell_ = readCell;
            this.isBlank_ = blankTxt != null ? txt -> txt.startsWith(blankTxt) : (iEnd0 - iStart0 > 1 ? txt -> MrtReader.allDash(txt) : txt -> false);
        }

        T readCell(String line) {
            if (line.length() >= this.iEnd0_) {
                int ie;
                int is;
                for (is = this.iStart0_; is < this.iEnd0_ && line.charAt(is) == ' '; ++is) {
                }
                for (ie = this.iEnd0_; ie > is && line.charAt(ie - 1) == ' '; --ie) {
                }
                if (ie > is) {
                    String cellTxt = line.subSequence(is, ie).toString();
                    if (this.isBlank_.test(cellTxt)) {
                        return null;
                    }
                    return this.readCell_.apply(cellTxt);
                }
                assert (is == ie);
                return null;
            }
            return null;
        }

        String cellText(String line) {
            return line.subSequence(this.iStart0_, this.iEnd0_).toString();
        }
    }

    private static class ParsedFormatLine {
        final int iStart_;
        final int iEnd_;
        final String fmtWord_;
        final String unit_;
        final String label_;
        final String explanation_;
        private static final Pattern FMT_REGEX = Pattern.compile(" *(?:([0-9]+)-)? *([0-9]+) +([AIFE][0-9.]+) +([^ ]+) +([^ ]+) +(.*)");

        ParsedFormatLine(String line) throws TableFormatException {
            Matcher matcher = FMT_REGEX.matcher(line);
            if (!matcher.matches()) {
                throw new TableFormatException("Unparsable MRT format line \"" + line + "\"");
            }
            this.iEnd_ = Integer.parseInt(matcher.group(2));
            this.iStart_ = matcher.group(1) == null ? this.iEnd_ : Integer.parseInt(matcher.group(1));
            this.fmtWord_ = matcher.group(3);
            this.unit_ = matcher.group(4);
            this.label_ = matcher.group(5);
            this.explanation_ = matcher.group(6);
        }

        static boolean isFormatLine(String line) {
            return FMT_REGEX.matcher(line).matches();
        }
    }

    private static class ParsedExplanation {
        final String description_;
        final String blankTxt_;

        ParsedExplanation(String description, String blankTxt) {
            this.description_ = description;
            this.blankTxt_ = blankTxt;
        }
    }
}

