/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import uk.ac.starlink.connect.FilestoreChooser;
import uk.ac.starlink.connect.Leaf;
import uk.ac.starlink.connect.Node;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.gui.AbstractTableLoadDialog;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class FilestoreTableLoadDialog
extends AbstractTableLoadDialog {
    private FilestoreChooser chooser_;
    private JTextField posField_;

    public FilestoreTableLoadDialog() {
        super("Filestore Browser", "Loader for files from local or remote filespace");
        this.setIconUrl(StarTable.class.getResource("gui/filestore.png"));
    }

    @Override
    protected Component createQueryComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this.getChooser();
        Action[] navActs = this.chooser_.getNavigationActions();
        this.setToolbarActions(navActs);
        JMenu navMenu = new JMenu("Navigation");
        navMenu.setMnemonic(78);
        for (int i = 0; i < navActs.length; ++i) {
            navMenu.add(navActs[i]);
        }
        this.setMenus(new JMenu[]{navMenu});
        panel.add((Component)this.chooser_, "Center");
        JLabel posLabel = new JLabel("Position in file: #");
        this.posField_ = new JTextField(6);
        this.posField_.addActionListener(this.getSubmitAction());
        String posHelp = "HDU index for FITS files or TABLE index for VOTables (optional)";
        this.posField_.setToolTipText(posHelp);
        posLabel.setToolTipText(posHelp);
        Box formatBox = Box.createHorizontalBox();
        formatBox.add(new JLabel("Table Format: "));
        formatBox.add(new ShrinkWrapper(this.createFormatSelector()));
        formatBox.add(Box.createHorizontalStrut(10));
        formatBox.add(Box.createHorizontalGlue());
        formatBox.add(new JLabel("Position in file: #"));
        formatBox.add(new ShrinkWrapper(this.posField_));
        formatBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)formatBox, "South");
        panel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                FilestoreTableLoadDialog.this.chooser_.refreshList();
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }
        });
        return panel;
    }

    @Override
    public TableLoader createTableLoader() {
        String pos;
        Node node = this.chooser_.getSelectedNode();
        if (!(node instanceof Leaf)) {
            throw new IllegalStateException("No table selected");
        }
        final Leaf leaf = (Leaf)node;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(leaf.toString());
        String posText = this.posField_.getText();
        String string = pos = posText != null && posText.trim().length() > 0 ? posText.trim() : null;
        if (pos != null) {
            sbuf.append('#').append(pos);
        }
        final String format = this.getSelectedFormat();
        final String label = sbuf.toString();
        return new TableLoader(){

            @Override
            public String getLabel() {
                return label;
            }

            @Override
            public TableSequence loadTables(StarTableFactory tfact) throws IOException {
                DataSource datsrc = leaf.getDataSource();
                if (pos != null) {
                    datsrc.setPosition(pos);
                    return Tables.singleTableSequence(tfact.makeStarTable(datsrc, format));
                }
                return tfact.makeStarTables(datsrc, format);
            }
        };
    }

    public FilestoreChooser getChooser() {
        if (this.chooser_ == null) {
            this.chooser_ = new FilestoreChooser(false){

                public void leafSelected(Leaf leaf) {
                    FilestoreTableLoadDialog.this.submit();
                }
            };
            this.chooser_.addDefaultBranches();
        }
        return this.chooser_;
    }
}

