/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.gui.AbstractTableLoadDialog;
import uk.ac.starlink.table.gui.TableLoader;

public class LocationTableLoadDialog
extends AbstractTableLoadDialog {
    private JTextField locField_;

    public LocationTableLoadDialog() {
        super("Location", "Loads from a filename or URL entered as text");
        this.setIconUrl(StarTable.class.getResource("gui/loctext.png"));
    }

    @Override
    protected Component createQueryComponent() {
        Box qc = Box.createHorizontalBox();
        qc.add(new JLabel("Location: "));
        this.locField_ = new JTextField(25);
        this.locField_.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                LocationTableLoadDialog.this.updateReady();
            }
        });
        this.updateReady();
        qc.add(this.locField_);
        this.locField_.addActionListener(this.getSubmitAction());
        qc.add(this.createFormatSelector());
        return qc;
    }

    @Override
    public boolean isReady() {
        String text = this.locField_.getText();
        return text != null && text.trim().length() > 0;
    }

    @Override
    public TableLoader createTableLoader() {
        final String loc = this.locField_.getText();
        final String format = this.getSelectedFormat();
        if (loc == null || loc.trim().length() == 0) {
            throw new IllegalStateException("No location supplied");
        }
        return new TableLoader(){

            @Override
            public String getLabel() {
                return loc;
            }

            @Override
            public TableSequence loadTables(StarTableFactory tfact) throws IOException {
                return tfact.makeStarTables(loc, format);
            }
        };
    }

    public JTextField getLocationField() {
        this.getQueryComponent();
        return this.locField_;
    }
}

