/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.table.jdbc.Connector;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.SwingAuthenticator;
import uk.ac.starlink.table.jdbc.TextModelsAuthenticator;

public class SQLPanel
extends JPanel {
    private LabelledComponentStack stack = new LabelledComponentStack();
    private JComboBox<String> protoField;
    private JComboBox<String> hostField;
    private JTextField dbField;
    private JTextComponent refField;
    private JTextField tableField;
    private JTextField userField;
    private JPasswordField passField;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.gui");

    public SQLPanel(String refString, boolean refArea) {
        super(new BorderLayout());
        this.add((Component)this.stack, "North");
        Font inputFont = this.stack.getInputFont();
        this.protoField = new JComboBox();
        this.protoField.addItem("");
        this.protoField.addItem("mysql");
        this.protoField.addItem("postgresql");
        this.protoField.setEditable(true);
        this.protoField.setFont(inputFont);
        this.stack.addLine("Protocol", "jdbc:", this.protoField);
        this.hostField = new JComboBox();
        this.hostField.addItem("");
        this.hostField.addItem("localhost");
        this.hostField.setEditable(true);
        this.hostField.setFont(inputFont);
        this.stack.addLine("Host", "://", this.hostField);
        this.dbField = new JTextField(12);
        this.stack.addLine("Database name", "/", this.dbField);
        if (!refArea) {
            this.refField = new JTextField(32);
            this.stack.addLine(refString, "#", this.refField);
        }
        this.userField = new JTextField(12);
        this.userField.setText(System.getProperty("user.name"));
        this.stack.addLine("User name", null, this.userField);
        this.passField = new JPasswordField(12);
        this.stack.addLine("Password", null, this.passField);
        if (refArea) {
            JPanel refHolder = new JPanel(new BorderLayout());
            Box labelBox = Box.createVerticalBox();
            labelBox.add(new JLabel(refString + ": # "));
            labelBox.add(Box.createVerticalGlue());
            refHolder.add((Component)labelBox, "West");
            this.refField = new JTextArea();
            this.refField.setFont(Font.decode("Monospaced"));
            refHolder.add(Box.createVerticalStrut(5), "North");
            refHolder.add((Component)new JScrollPane(this.refField), "Center");
            refHolder.setPreferredSize(new Dimension(400, 100));
            this.add((Component)refHolder, "Center");
        }
    }

    public void useAuthenticator(JDBCAuthenticator auth) {
        if (auth instanceof TextModelsAuthenticator) {
            TextModelsAuthenticator tAuth = (TextModelsAuthenticator)auth;
            this.userField.setDocument(tAuth.getUserDocument());
            this.passField.setDocument(tAuth.getPasswordDocument());
        } else {
            if (auth instanceof SwingAuthenticator) {
                ((SwingAuthenticator)auth).setParentComponent(this);
            }
            try {
                String[] up = auth.authenticate();
                this.userField.setText(up[0]);
                this.passField.setText(up[1]);
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Authentication attempt failed", e);
            }
        }
    }

    public Connector getConnector() {
        return new Connector(){
            private String baseURL;
            private String user;
            private String pass;
            {
                this.baseURL = SQLPanel.this.getBaseURL();
                this.user = SQLPanel.this.userField.getText();
                this.pass = new String(SQLPanel.this.passField.getPassword());
            }

            @Override
            public Connection getConnection() throws SQLException {
                return DriverManager.getConnection(this.baseURL, this.user, this.pass);
            }
        };
    }

    public String getBaseURL() {
        return new StringBuffer().append("jdbc:").append(this.protoField.getSelectedItem()).append("://").append(this.hostField.getSelectedItem()).append("/").append(this.dbField.getText()).toString();
    }

    public String getRef() {
        return this.refField == null ? null : this.refField.getText();
    }

    public String getFullURL() {
        String ref = this.getRef();
        return this.getBaseURL() + (ref != null ? "#" + ref : "");
    }

    public boolean isAvailable() {
        return SQLPanel.isSqlAvailable();
    }

    protected LabelledComponentStack getStack() {
        return this.stack;
    }

    public static boolean isSqlAvailable() {
        return DriverManager.getDrivers().hasMoreElements();
    }
}

