/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Action;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.gui.AbstractTableLoadDialog;
import uk.ac.starlink.table.gui.SQLPanel;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;

public class SQLTableLoadDialog
extends AbstractTableLoadDialog {
    private SQLPanel sqlPanel_;
    private JDBCAuthenticator authenticator_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.gui");

    public SQLTableLoadDialog() {
        super("SQL Query", "Get table as result of an SQL query on a relational database");
        this.setIconUrl(StarTable.class.getResource("gui/sqlread.png"));
    }

    @Override
    public boolean isAvailable() {
        return SQLPanel.isSqlAvailable();
    }

    @Override
    public void configure(StarTableFactory tfact, Action submitAct) {
        super.configure(tfact, submitAct);
        this.authenticator_ = tfact.getJDBCHandler().getAuthenticator();
    }

    @Override
    protected Component createQueryComponent() {
        this.sqlPanel_ = new SQLPanel("SQL Query", true);
        this.sqlPanel_.useAuthenticator(this.authenticator_);
        return this.sqlPanel_;
    }

    @Override
    public TableLoader createTableLoader() {
        final String url = this.sqlPanel_.getFullURL();
        final String qtext = this.sqlPanel_.getRef();
        return new TableLoader(){

            @Override
            public String getLabel() {
                return qtext;
            }

            @Override
            public TableSequence loadTables(StarTableFactory tfact) throws IOException {
                logger_.info(url);
                return Tables.singleTableSequence(tfact.makeStarTable(url));
            }
        };
    }
}

