/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.gui.ErrorDialog;

public class SystemBrowser {
    private String filename_;
    private String dirname_;
    private static Icon icon_;

    public TableLoader showLoadDialog(Component parent, final String format) {
        Dialog dial = parent instanceof Dialog ? (Dialog)parent : (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        FileDialog fd = dial != null ? new FileDialog(dial, "Load Table", 0) : new FileDialog(frame, "Load Table", 0);
        FileDataSource datsrc = null;
        while (datsrc == null) {
            fd.setDirectory(this.dirname_);
            if (this.filename_ != null) {
                fd.setFile(this.filename_);
            }
            fd.setVisible(true);
            String filename = fd.getFile();
            String dirname = fd.getDirectory();
            this.filename_ = filename;
            if (dirname != null) {
                this.dirname_ = dirname;
            }
            if (dirname == null) {
                dirname = "";
            }
            if (filename == null || filename.trim().length() == 0) {
                return null;
            }
            try {
                datsrc = new FileDataSource(new File(dirname, filename));
            }
            catch (IOException e) {
                ErrorDialog.showError(parent, "Load Error", (Throwable)e, "Nonexistent or unreadable file " + filename);
                datsrc = null;
            }
        }
        assert (datsrc != null);
        final FileDataSource datsrc1 = datsrc;
        return new TableLoader(){

            @Override
            public String getLabel() {
                return datsrc1.getFile().toString();
            }

            @Override
            public TableSequence loadTables(StarTableFactory tfact) throws IOException {
                return tfact.makeStarTables(datsrc1, format);
            }
        };
    }

    public static Icon getSystemBrowserIcon() {
        if (icon_ == null) {
            icon_ = new ImageIcon(StarTable.class.getResource("gui/sysbrowser.png"));
        }
        return icon_;
    }
}

