/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.gui.FilestoreTableSaveDialog;
import uk.ac.starlink.table.gui.SaveWorker;
import uk.ac.starlink.table.gui.SystemBrowser;
import uk.ac.starlink.table.gui.TableSaveDialog;

public class SystemTableSaveDialog
implements TableSaveDialog {
    private String filename_;
    private String dirname_;

    @Override
    public String getName() {
        return "System Browser";
    }

    @Override
    public String getDescription() {
        return "Save table(s) to location chosen using system default file browser";
    }

    @Override
    public Icon getIcon() {
        return SystemBrowser.getSystemBrowserIcon();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean showSaveDialog(Component parent, final StarTableOutput sto, ComboBoxModel<String> formatModel, StarTable[] tables) {
        Dialog dial = parent instanceof Dialog ? (Dialog)parent : (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        FileDialog fd = dial != null ? new FileDialog(dial, "Save Table", 1) : new FileDialog(frame, "Save Table", 1);
        File ofile = null;
        while (ofile == null) {
            fd.setDirectory(this.dirname_);
            if (this.filename_ != null) {
                fd.setFile(this.filename_);
            }
            fd.setVisible(true);
            String filename = fd.getFile();
            String dirname = fd.getDirectory();
            this.filename_ = filename;
            if (dirname != null) {
                this.dirname_ = dirname;
            }
            if (dirname == null) {
                dirname = "";
            }
            if (filename == null || filename.trim().length() == 0) {
                return false;
            }
            File file = new File(dirname, filename);
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(parent, "Selected file is a directory", "Save Error", 0);
                continue;
            }
            if (file.exists() && !FilestoreTableSaveDialog.confirmOverwrite(parent, file.toString())) continue;
            ofile = new File(dirname, filename);
        }
        final String location = ofile.toString();
        final String format = (String)formatModel.getSelectedItem();
        new SaveWorker(parent, tables, ofile.toString()){

            @Override
            protected void attemptSave(StarTable[] tables) throws IOException {
                sto.writeStarTables(tables, location, format);
            }

            @Override
            protected void done(boolean success) {
            }
        }.invoke();
        return true;
    }
}

