/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ViewHugeTableModel
implements TableModel {
    private final AdjustmentListener barListener_;
    private final TableModelListener hugeListener_;
    private final List<TableModelListener> tmListenerList_ = new ArrayList<TableModelListener>();
    private final List<PropertyChangeListener> propListenerList_ = new ArrayList<PropertyChangeListener>();
    private TableModel hugeModel_;
    private JScrollBar vbar_;
    private int viewBase_;
    public static final String VIEWBASE_PROPERTY = "viewBase";
    public static final int VIEWSIZE = 0x1FFFFFF;

    public ViewHugeTableModel() {
        this.barListener_ = new ScrollListener();
        this.hugeListener_ = new HugeModelListener();
    }

    public ViewHugeTableModel(TableModel hugeModel, JScrollBar vbar) {
        this();
        this.configureModel(hugeModel, vbar);
    }

    public void configureModel(TableModel hugeModel, JScrollBar vbar) {
        if (this.vbar_ != null) {
            this.vbar_.removeAdjustmentListener(this.barListener_);
        }
        if (this.hugeModel_ != null) {
            this.hugeModel_.removeTableModelListener(this.hugeListener_);
        }
        this.hugeModel_ = hugeModel;
        this.vbar_ = vbar;
        if (this.vbar_ != null) {
            this.vbar_.addAdjustmentListener(this.barListener_);
        }
        if (this.hugeModel_ != null) {
            this.hugeModel_.addTableModelListener(this.hugeListener_);
        }
        this.viewBase_ = this.calculateViewBase();
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public int getRowCount() {
        return Math.min(this.hugeModel_.getRowCount(), 0x1FFFFFF);
    }

    @Override
    public Object getValueAt(int irow, int icol) {
        return this.hugeModel_.getValueAt(this.getHugeRow(irow), icol);
    }

    @Override
    public void setValueAt(Object value, int irow, int icol) {
        this.hugeModel_.setValueAt(value, this.getHugeRow(irow), icol);
    }

    @Override
    public boolean isCellEditable(int irow, int icol) {
        return this.hugeModel_.isCellEditable(this.getHugeRow(irow), icol);
    }

    @Override
    public int getColumnCount() {
        return this.hugeModel_.getColumnCount();
    }

    @Override
    public String getColumnName(int icol) {
        return this.hugeModel_.getColumnName(icol);
    }

    @Override
    public Class<?> getColumnClass(int icol) {
        return this.hugeModel_.getColumnClass(icol);
    }

    @Override
    public void addTableModelListener(TableModelListener lnr) {
        this.tmListenerList_.add(lnr);
    }

    @Override
    public void removeTableModelListener(TableModelListener lnr) {
        this.tmListenerList_.remove(lnr);
    }

    public int getViewBase() {
        return this.viewBase_;
    }

    public void addPropertyChangeListener(PropertyChangeListener lnr) {
        this.propListenerList_.add(lnr);
    }

    public void removePropertyChangeListener(PropertyChangeListener lnr) {
        this.propListenerList_.remove(lnr);
    }

    protected void fireTableChanged(TableModelEvent evt) {
        for (TableModelListener lnr : this.tmListenerList_) {
            lnr.tableChanged(evt);
        }
    }

    protected void firePropertyChanged(PropertyChangeEvent evt) {
        for (PropertyChangeListener lnr : this.propListenerList_) {
            lnr.propertyChange(evt);
        }
    }

    public int getHugeRow(int iViewRow) {
        return iViewRow + this.viewBase_;
    }

    private int calculateViewBase() {
        int vrange = this.hugeModel_.getRowCount() - 0x1FFFFFF;
        if (vrange <= 0) {
            return 0;
        }
        int vmin = this.vbar_.getMinimum();
        int vmax = this.vbar_.getMaximum();
        int vval = this.vbar_.getValue();
        int vext = this.vbar_.getVisibleAmount();
        double vscale = (double)vval / (double)(vmax - vmin - vext);
        return (int)(vscale * (double)vrange);
    }

    private void maybeReconfigure() {
        int vbase = this.calculateViewBase();
        int npix = Math.max(this.vbar_.getHeight(), 400);
        int rowsPerPixel = this.hugeModel_.getRowCount() / npix;
        int diff = Math.abs(vbase - this.viewBase_);
        if (diff > rowsPerPixel / 2) {
            this.resetViewBase(vbase);
        }
    }

    private void resetViewBase(int viewBase) {
        int oldViewBase = this.viewBase_;
        this.viewBase_ = viewBase;
        TableModelEvent tmEvt = new TableModelEvent(this, 0, Math.min(0x1FFFFFF, this.getRowCount()));
        this.fireTableChanged(tmEvt);
        PropertyChangeEvent propEvt = new PropertyChangeEvent(this, VIEWBASE_PROPERTY, oldViewBase, viewBase);
        this.firePropertyChanged(propEvt);
    }

    private class HugeModelListener
    implements TableModelListener {
        private HugeModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent evt) {
            Object src = evt.getSource();
            TableModel tmodelSrc = src instanceof TableModel ? (TableModel)src : null;
            int hugeRow0 = evt.getFirstRow();
            int hugeRow1 = evt.getLastRow();
            int type = evt.getType();
            int icol = evt.getColumn();
            TableModelEvent viewEvt = type == 0 && hugeRow1 < ViewHugeTableModel.this.hugeModel_.getRowCount() ? new TableModelEvent(tmodelSrc, this.hugeToView(hugeRow0), this.hugeToView(hugeRow1), icol, type) : new TableModelEvent(tmodelSrc);
            ViewHugeTableModel.this.fireTableChanged(viewEvt);
            ViewHugeTableModel.this.maybeReconfigure();
        }

        private int hugeToView(int hugeRow) {
            return hugeRow == -1 ? -1 : hugeRow - ViewHugeTableModel.this.viewBase_;
        }
    }

    private class ScrollListener
    implements AdjustmentListener {
        private ScrollListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            boolean isRelative;
            int atype = evt.getAdjustmentType();
            boolean bl = isRelative = atype == 1 || atype == 2 || atype == 4 || atype == 3;
            if (!isRelative) {
                ViewHugeTableModel.this.maybeReconfigure();
            }
        }
    }
}

