/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.storage.FileByteStore;

public class AdaptiveByteStore
implements ByteStore {
    private final int memLimit_;
    private AdaptiveOutputStream out_;
    private OutputStream baseOut_;
    private int count_;
    private long length_;
    private File file_;
    private static final float MAX_FRACT = 0.125f;
    private static final int MAX_HEAP = 65536;
    private static int defaultLimit_;
    private static final Logger logger_;

    public AdaptiveByteStore(int memLimit) throws IOException {
        try {
            this.baseOut_ = new BytesOutputStream();
        }
        catch (OutOfMemoryError e) {
            logger_.info("Insufficient heap for " + memLimit + " bytes - go direct to file storage");
            this.file_ = AdaptiveByteStore.createFile();
            this.baseOut_ = new FileOutputStream(this.file_);
        }
        this.memLimit_ = memLimit;
        this.out_ = new AdaptiveOutputStream();
    }

    public AdaptiveByteStore() throws IOException {
        this(AdaptiveByteStore.getDefaultLimit());
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out_;
    }

    @Override
    public long getLength() {
        return this.length_;
    }

    @Override
    public void copy(OutputStream out) throws IOException {
        this.out_.flush();
        if (this.file_ == null) {
            ((BytesOutputStream)this.baseOut_).writeTo(out);
        } else {
            FileByteStore.copy(this.file_, out);
        }
    }

    @Override
    public ByteBuffer[] toByteBuffers() throws IOException {
        this.out_.flush();
        if (this.file_ == null) {
            ByteBuffer bbuf;
            BytesOutputStream byteOut = (BytesOutputStream)this.baseOut_;
            byte[] buf = byteOut.toByteArray();
            if (this.count_ < 65536) {
                bbuf = ByteBuffer.wrap(byteOut.toByteArray());
            } else {
                bbuf = ByteBuffer.allocateDirect(this.count_);
                if (bbuf.isDirect()) {
                    logger_.info("malloc " + this.count_ + " bytes");
                }
                bbuf.put(byteOut.getBuf(), 0, byteOut.getCount());
            }
            return new ByteBuffer[]{bbuf};
        }
        return FileByteStore.toByteBuffers(this.file_);
    }

    @Override
    public void close() {
        try {
            this.out_.close();
        }
        catch (IOException e) {
            logger_.warning("close error: " + e);
        }
        if (this.file_ != null) {
            if (this.file_.delete()) {
                logger_.info("Deleting temporary file: " + this.file_);
            } else if (this.file_.exists()) {
                logger_.warning("Failed to delete temporary file " + this.file_);
            } else {
                logger_.info("Temporary file got deleted before close");
            }
        }
    }

    private void prepareToWrite(int c) throws IOException {
        int c1 = this.count_ + c;
        if (this.file_ == null) {
            assert (this.count_ <= this.memLimit_);
            if (c1 > this.memLimit_) {
                this.baseOut_.close();
                this.file_ = AdaptiveByteStore.createFile();
                BytesOutputStream byteOut = (BytesOutputStream)this.baseOut_;
                logger_.info("AdaptiveByteStore: switching from memory buffer to temp file " + this.file_ + " at " + this.memLimit_ + " bytes");
                this.baseOut_ = new FileOutputStream(this.file_);
                byteOut.writeTo(this.baseOut_);
            }
        }
        this.count_ = c1;
    }

    private static File createFile() throws IOException {
        File file = File.createTempFile("AdaptiveByteStore", ".bin");
        file.deleteOnExit();
        return file;
    }

    public static int getDefaultLimit() {
        if (defaultLimit_ <= 0) {
            int maxmem = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
            defaultLimit_ = (int)((float)maxmem * 0.125f);
            logger_.info("AdaptiveByteStore default memory limit = " + AdaptiveByteStore.formatByteCount(maxmem) + " * " + 0.125f + " = " + AdaptiveByteStore.formatByteCount(defaultLimit_));
        }
        return defaultLimit_;
    }

    private static String formatByteCount(int nbyte) {
        return (int)Math.round((double)nbyte / 1024.0 / 1024.0) + "M";
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.table.storage");
    }

    private static class BytesOutputStream
    extends ByteArrayOutputStream {
        private BytesOutputStream() {
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }

    private class AdaptiveOutputStream
    extends OutputStream {
        private AdaptiveOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            AdaptiveByteStore.this.prepareToWrite(1);
            AdaptiveByteStore.this.baseOut_.write(b);
            AdaptiveByteStore.this.length_++;
        }

        @Override
        public void write(byte[] bs, int off, int len) throws IOException {
            AdaptiveByteStore.this.prepareToWrite(len);
            AdaptiveByteStore.this.baseOut_.write(bs, off, len);
            AdaptiveByteStore.this.length_ = AdaptiveByteStore.this.length_ + (long)len;
        }

        @Override
        public void write(byte[] bs) throws IOException {
            AdaptiveByteStore.this.prepareToWrite(bs.length);
            AdaptiveByteStore.this.baseOut_.write(bs);
            AdaptiveByteStore.this.length_ = AdaptiveByteStore.this.length_ + (long)bs.length;
        }

        @Override
        public void flush() throws IOException {
            AdaptiveByteStore.this.baseOut_.flush();
        }

        @Override
        public void close() throws IOException {
            AdaptiveByteStore.this.baseOut_.close();
        }
    }
}

