/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomRowSplittable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnWidth;
import uk.ac.starlink.table.storage.NioByteStoreAccess;
import uk.ac.starlink.table.storage.Offsets;
import uk.ac.starlink.util.Cleaner;
import uk.ac.starlink.util.DataBufferedOutputStream;
import uk.ac.starlink.util.IntList;

public class ByteStoreRowStore
implements RowStore {
    private final ByteStore byteStore_;
    private final DataBufferedOutputStream out_;
    private int ncol_;
    private int nrow_;
    private Codec[] codecs_;
    private IntList[] colSizeLists_;
    private Offsets offsets_;
    private StarTable template_;
    private StarTable storedTable_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");

    public ByteStoreRowStore(ByteStore byteStore) {
        this.byteStore_ = byteStore;
        this.out_ = new DataBufferedOutputStream(byteStore.getOutputStream());
        Cleaner.getInstance().register(this, new CleanAction(byteStore));
    }

    public ByteStore getByteStore() {
        return this.byteStore_;
    }

    @Override
    public void acceptMetadata(StarTable meta) throws TableFormatException {
        if (this.template_ != null) {
            throw new IllegalStateException("Metadata already submitted");
        }
        this.template_ = meta;
        this.ncol_ = meta.getColumnCount();
        this.codecs_ = new Codec[this.ncol_];
        this.colSizeLists_ = new IntList[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnInfo cinfo = meta.getColumnInfo(icol);
            Codec codec = Codec.getCodec(cinfo);
            if (codec == null) {
                throw new TableFormatException("No codec available for " + cinfo);
            }
            this.codecs_[icol] = codec;
            if (codec.getItemSize() >= 0) continue;
            this.colSizeLists_[icol] = new IntList();
        }
    }

    @Override
    public void acceptRow(Object[] row) throws IOException {
        if (this.template_ == null) {
            throw new IllegalStateException("acceptMetadata not called");
        }
        if (this.storedTable_ != null) {
            throw new IllegalStateException("endRows already called");
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            int nbyte = this.codecs_[icol].encode(row[icol], this.out_);
            if (this.colSizeLists_[icol] == null) continue;
            this.colSizeLists_[icol].add(nbyte);
        }
        ++this.nrow_;
    }

    @Override
    public void endRows() throws IOException {
        if (this.template_ == null) {
            throw new IllegalStateException("acceptMetadata not called");
        }
        if (this.storedTable_ != null) {
            throw new IllegalStateException("endRows already called");
        }
        this.out_.close();
        ColumnWidth[] colWidths = new ColumnWidth[this.ncol_];
        boolean someVariable = false;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnWidth cw;
            if (this.colSizeLists_[icol] == null) {
                cw = ColumnWidth.constantColumnWidth(this.codecs_[icol].getItemSize());
            } else {
                cw = ColumnWidth.variableColumnWidth(this.colSizeLists_[icol].toIntArray());
                this.colSizeLists_[icol] = null;
            }
            colWidths[icol] = cw;
        }
        this.colSizeLists_ = null;
        this.offsets_ = Offsets.getOffsets(colWidths, this.nrow_);
        logger_.config("Offset type is " + (this.offsets_.isFixed() ? "fixed" : "variable"));
        ByteBuffer[] bbufs = this.byteStore_.toByteBuffers();
        long nbyte = 0L;
        for (int ib = 0; ib < bbufs.length; ++ib) {
            nbyte += (long)bbufs[ib].limit();
        }
        logger_.config(this.nrow_ + " rows stored in " + nbyte + " bytes");
        this.storedTable_ = new ByteStoreStarTable(this.template_, this.nrow_, this.codecs_, this.offsets_, bbufs){

            @Override
            public void close() throws IOException {
                ByteStoreRowStore.this.byteStore_.close();
            }
        };
    }

    @Override
    public StarTable getStarTable() {
        if (this.storedTable_ == null) {
            throw new IllegalStateException("endRows not called");
        }
        return this.storedTable_;
    }

    Offsets getOffsets() {
        return this.offsets_;
    }

    private static class CleanAction
    implements Runnable {
        private final ByteStore bstore_;

        CleanAction(ByteStore bstore) {
            this.bstore_ = bstore;
        }

        @Override
        public void run() {
            this.bstore_.close();
        }
    }

    private static class ByteStoreStarTable
    extends WrapperStarTable {
        private final ByteBuffer[] bbufs_;
        private final ThreadLocal<ByteStoreAccess> accessLocal_;
        private final long nrow_;
        private final int ncol_;
        private final Codec[] codecs_;
        private final Offsets offsets_;

        ByteStoreStarTable(StarTable template, long nrow, Codec[] codecs, Offsets offsets, ByteBuffer[] bbufs) {
            super(template);
            this.nrow_ = nrow;
            this.ncol_ = template.getColumnCount();
            this.codecs_ = codecs;
            this.offsets_ = offsets;
            this.bbufs_ = bbufs;
            this.accessLocal_ = new ThreadLocal<ByteStoreAccess>(){

                @Override
                public ByteStoreAccess initialValue() {
                    return this.createAccess();
                }
            };
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public long getRowCount() {
            return this.nrow_;
        }

        @Override
        public Object[] getRow(long lrow) throws IOException {
            ByteStoreAccess access = this.accessLocal_.get();
            Object[] row = new Object[this.ncol_];
            access.seek(this.offsets_.getRowOffset(lrow));
            for (int icol = 0; icol < this.ncol_; ++icol) {
                row[icol] = this.codecs_[icol].decodeObject(access);
            }
            return row;
        }

        @Override
        public Object getCell(long lrow, int icol) throws IOException {
            ByteStoreAccess access = this.accessLocal_.get();
            access.seek(this.offsets_.getCellOffset(lrow, icol));
            return this.codecs_[icol].decodeObject(access);
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            final ByteStoreAccess access = this.createAccess();
            return new RowSequence(){
                long irow = -1L;

                @Override
                public boolean next() {
                    return ++this.irow < nrow_;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    if (this.irow >= 0L) {
                        access.seek(offsets_.getCellOffset(this.irow, icol));
                        return codecs_[icol].decodeObject(access);
                    }
                    throw new IllegalStateException();
                }

                @Override
                public Object[] getRow() throws IOException {
                    if (this.irow >= 0L) {
                        access.seek(offsets_.getRowOffset(this.irow));
                        Object[] row = new Object[ncol_];
                        for (int icol = 0; icol < ncol_; ++icol) {
                            row[icol] = codecs_[icol].decodeObject(access);
                        }
                        return row;
                    }
                    throw new IllegalStateException();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public RowSplittable getRowSplittable() throws IOException {
            return new RandomRowSplittable(this);
        }

        @Override
        public RowAccess getRowAccess() throws IOException {
            final ByteStoreAccess access = this.createAccess();
            final Object[] row = new Object[this.ncol_];
            return new RowAccess(){
                long irow_ = -1L;

                @Override
                public void setRowIndex(long irow) {
                    this.irow_ = irow;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    access.seek(offsets_.getCellOffset(this.irow_, icol));
                    return codecs_[icol].decodeObject(access);
                }

                @Override
                public Object[] getRow() throws IOException {
                    access.seek(offsets_.getRowOffset(this.irow_));
                    for (int icol = 0; icol < ncol_; ++icol) {
                        row[icol] = codecs_[icol].decodeObject(access);
                    }
                    return row;
                }

                @Override
                public void close() {
                }
            };
        }

        private ByteStoreAccess createAccess() {
            return NioByteStoreAccess.createAccess(NioByteStoreAccess.copyBuffers(this.bbufs_));
        }
    }
}

