/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.IOException;
import uk.ac.starlink.table.RandomRowSplittable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.table.storage.ColumnReader;
import uk.ac.starlink.table.storage.ColumnStore;

public class ColumnStoreStarTable
extends WrapperStarTable {
    private final long nrow_;
    private final int ncol_;
    private final ColumnStore[] colStores_;
    private final ThreadLocal<ColumnReader>[] colReaders_;

    public ColumnStoreStarTable(StarTable template, long nrow, ColumnStore[] colStores) {
        super(template);
        this.nrow_ = nrow;
        this.ncol_ = template.getColumnCount();
        this.colStores_ = colStores;
        ThreadLocal[] colReaders = new ThreadLocal[this.ncol_];
        this.colReaders_ = colReaders;
        for (int ic = 0; ic < this.ncol_; ++ic) {
            final ColumnStore colStore = colStores[ic];
            this.colReaders_[ic] = new ThreadLocal<ColumnReader>(){

                @Override
                protected ColumnReader initialValue() {
                    return colStore.createReader();
                }
            };
        }
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public Object getCell(long lrow, int icol) throws IOException {
        return this.colReaders_[icol].get().getObjectValue(lrow);
    }

    @Override
    public Object[] getRow(long lrow) throws IOException {
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = this.getCell(lrow, icol);
        }
        return row;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        final ColumnReader[] readers = new ColumnReader[this.ncol_];
        for (int ic = 0; ic < this.ncol_; ++ic) {
            readers[ic] = this.colStores_[ic].createReader();
        }
        return new RowSequence(){
            long irow = -1L;

            @Override
            public boolean next() {
                return ++this.irow < ColumnStoreStarTable.this.nrow_;
            }

            @Override
            public Object getCell(int icol) throws IOException {
                if (this.irow >= 0L) {
                    return readers[icol].getObjectValue(this.irow);
                }
                throw new IllegalStateException();
            }

            @Override
            public Object[] getRow() throws IOException {
                if (this.irow >= 0L) {
                    Object[] row = new Object[ColumnStoreStarTable.this.ncol_];
                    for (int ic = 0; ic < ColumnStoreStarTable.this.ncol_; ++ic) {
                        row[ic] = readers[ic].getObjectValue(this.irow);
                    }
                    return row;
                }
                throw new IllegalStateException();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        return new RandomRowSplittable(this);
    }

    @Override
    public RowAccess getRowAccess() throws IOException {
        final ColumnReader[] readers = new ColumnReader[this.ncol_];
        for (int ic = 0; ic < this.ncol_; ++ic) {
            readers[ic] = this.colStores_[ic].createReader();
        }
        final Object[] row = new Object[this.ncol_];
        return new RowAccess(){
            long irow_ = -1L;

            @Override
            public void setRowIndex(long irow) {
                this.irow_ = irow;
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return readers[icol].getObjectValue(this.irow_);
            }

            @Override
            public Object[] getRow() throws IOException {
                for (int ic = 0; ic < ColumnStoreStarTable.this.ncol_; ++ic) {
                    row[ic] = readers[ic].getObjectValue(this.irow_);
                }
                return row;
            }

            @Override
            public void close() {
            }
        };
    }
}

