/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;

public abstract class AbstractChoiceParameter<T, C>
extends Parameter<T> {
    private final Map<C, String> optionMap_;
    private final Class<C> optClazz_;

    protected AbstractChoiceParameter(String name, Class<T> paramClazz, Class<C> optClazz, C[] options) {
        super(name, paramClazz, true);
        this.optClazz_ = optClazz;
        this.optionMap_ = new LinkedHashMap<C, String>();
        if (options != null) {
            for (C opt : options) {
                this.addOption(opt);
            }
        }
    }

    public void addOption(C option, String name) {
        this.optionMap_.put(option, name);
    }

    public void addOption(C option) {
        this.addOption(option, this.stringifyOption(option));
    }

    public void clearOptions() {
        this.optionMap_.clear();
    }

    public String[] getOptionNames() {
        ArrayList<String> optNameList = new ArrayList<String>();
        for (C option : this.optionMap_.keySet()) {
            optNameList.add(this.getName(option));
        }
        return optNameList.toArray(new String[0]);
    }

    public C[] getOptions() {
        Collection<C> list = this.getOptionValueList();
        Object[] array = (Object[])Array.newInstance(this.optClazz_, list.size());
        return list.toArray(array);
    }

    public Collection<C> getOptionValueList() {
        return this.optionMap_.keySet();
    }

    public String getName(C option) {
        String name = this.optionMap_.get(option);
        return name == null ? this.stringifyOption(option) : name;
    }

    public String stringifyOption(C option) {
        return String.valueOf(option);
    }

    public C getOption(String name) {
        for (C option : this.optionMap_.keySet()) {
            if (!name.equalsIgnoreCase(this.getName(option))) continue;
            return option;
        }
        return null;
    }

    protected C stringToChoice(String sval) throws ParameterValueException {
        for (C option : this.optionMap_.keySet()) {
            if (!sval.equalsIgnoreCase(this.getName(option))) continue;
            return option;
        }
        String msg = new StringBuffer().append("Unknown value \"").append(sval).append("\" - must be one of ").append(this.optionMap_.keySet().stream().map(this::getName).collect(Collectors.joining(", "))).toString();
        throw new ParameterValueException(this, msg);
    }

    protected String choiceToString(C objVal) {
        return this.optionMap_.containsKey(objVal) ? this.optionMap_.get(objVal) : this.stringifyOption(objVal);
    }
}

