/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class DoubleParameter
extends Parameter<Double> {
    private Double min_;
    private Double max_;
    private boolean minInclusive_;
    private boolean maxInclusive_;

    public DoubleParameter(String name) {
        super(name, Double.class, false);
        this.setUsage("<float-value>");
    }

    public double doubleValue(Environment env) throws TaskException {
        Double objVal = (Double)this.objectValue(env);
        return objVal == null ? Double.NaN : objVal;
    }

    public void setDoubleDefault(double dflt) {
        this.setStringDefault(Double.isNaN(dflt) ? "" : Double.toString(dflt));
    }

    public void setMinimum(double min, boolean inclusive) {
        this.min_ = Double.isNaN(min) ? null : Double.valueOf(min);
        this.minInclusive_ = inclusive;
    }

    public void setMaximum(double max, boolean inclusive) {
        this.max_ = Double.isNaN(max) ? null : Double.valueOf(max);
    }

    @Override
    public Double stringToObject(Environment env, String stringval) throws TaskException {
        double dval;
        try {
            dval = Double.parseDouble(stringval);
        }
        catch (NumberFormatException e) {
            throw new ParameterValueException(this, e.getMessage());
        }
        if (this.min_ != null) {
            double dmin = this.min_;
            if (this.minInclusive_) {
                if (dval < dmin) {
                    throw new ParameterValueException(this, dval + " < minimum value " + dmin);
                }
            } else if (dval <= dmin) {
                throw new ParameterValueException(this, dval + " <= minimum value " + dmin);
            }
        }
        if (this.max_ != null) {
            double dmax = this.max_;
            if (this.maxInclusive_) {
                if (dval > dmax) {
                    throw new ParameterValueException(this, dval + " > maximum value " + dmax);
                }
            } else if (dval >= dmax) {
                throw new ParameterValueException(this, dval + " >= maximum value " + dmax);
            }
        }
        return dval;
    }

    @Override
    public void setValueFromString(Environment env, String stringval) throws TaskException {
        if ((stringval == null || stringval.trim().length() == 0) && this.isNullPermitted()) {
            this.setValue(stringval, Double.NaN);
        } else {
            super.setValueFromString(env, stringval);
        }
    }
}

