/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLUtils;

public class InputStreamParameter
extends Parameter<InputStream> {
    private final boolean allowSystem_;

    public InputStreamParameter(String name) {
        super(name, InputStream.class, true);
        this.allowSystem_ = true;
        this.setUsage("<location>");
    }

    @Override
    public InputStream stringToObject(Environment env, String sval) throws ParameterValueException {
        if (!sval.equals("-") && !new File(sval).exists()) {
            try {
                URLUtils.newURL(sval);
            }
            catch (MalformedURLException e) {
                String msg = "Value " + sval + " is not a file, URL or \"-\"";
                throw new ParameterValueException(this, msg);
            }
        }
        try {
            return DataSource.getInputStream(sval, this.allowSystem_);
        }
        catch (IOException e) {
            throw (ParameterValueException)new ParameterValueException(this, e.toString()).initCause(e);
        }
    }
}

