/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class IntegerParameter
extends Parameter<Integer> {
    private boolean even;
    private boolean odd;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public IntegerParameter(String name) {
        super(name, Integer.class, false);
        this.setUsage("<int-value>");
    }

    @Override
    public Integer stringToObject(Environment env, String stringval) throws ParameterValueException {
        int intval;
        try {
            intval = Integer.parseInt(stringval.replaceAll("_", ""));
        }
        catch (NumberFormatException e) {
            throw new ParameterValueException(this, "Not an integer");
        }
        if (this.odd && intval % 2 == 0) {
            throw new ParameterValueException(this, intval + " is not odd");
        }
        if (this.even && intval % 2 == 1) {
            throw new ParameterValueException(this, intval + " is not even");
        }
        if (intval < this.min) {
            throw new ParameterValueException(this, intval + " < minimum value " + this.min);
        }
        if (intval > this.max) {
            throw new ParameterValueException(this, intval + " > maximum value " + this.max);
        }
        return intval;
    }

    public int intValue(Environment env) throws TaskException {
        return (Integer)this.objectValue(env);
    }

    public void setIntDefault(int dflt) {
        this.setStringDefault(Integer.toString(dflt));
    }

    public void setEven() {
        this.even = true;
    }

    public void setOdd() {
        this.odd = true;
    }

    public void setMinimum(int min) {
        this.min = min;
    }

    public void setMaximum(int max) {
        this.max = max;
    }
}

