/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.task.LineFormatter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.util.LogUtils;

public class InvokeUtils {
    public static void configureLogging(int verbosity, boolean debug) {
        Logger rootLogger = LogUtils.getLogger("");
        int verbInt = Math.max(Level.ALL.intValue(), Level.WARNING.intValue() - verbosity * (Level.WARNING.intValue() - Level.INFO.intValue()));
        Level verbLevel = Level.parse(Integer.toString(verbInt));
        Handler[] rootHandlers = rootLogger.getHandlers();
        if (rootHandlers.length > 0 && rootHandlers[0] instanceof ConsoleHandler) {
            rootHandlers[0].setLevel(verbLevel);
            rootHandlers[0].setFormatter(new LineFormatter(debug));
        }
        rootLogger.setLevel(verbLevel);
        LogUtils.getLogger("org.apache.axis.utils.JavaUtils").setLevel(Level.SEVERE);
    }

    public static String getJavaVersion() {
        try {
            return System.getProperty("java.version");
        }
        catch (SecurityException e) {
            return "???";
        }
    }

    public static String getJavaVM() {
        try {
            return System.getProperty("java.vm.name", "???") + ", version " + System.getProperty("java.vm.version", "???") + ", JRE " + System.getProperty("java.specification.version", "???");
        }
        catch (SecurityException e) {
            return "???";
        }
    }

    public static void summariseError(Throwable error, PrintStream out) {
        String msg = error.getMessage();
        if (msg == null || msg.trim().length() == 0) {
            msg = error.toString();
        } else {
            out.println(msg);
        }
        Throwable cause = error.getCause();
        if (cause != null) {
            InvokeUtils.summariseError(cause, out);
        }
    }

    public static Parameter<?>[] sortParameters(Parameter<?>[] params) {
        ArrayList<Parameter<Object>> numbered = new ArrayList<Parameter<Object>>();
        ArrayList unNumbered = new ArrayList();
        for (int i = 0; i < params.length; ++i) {
            Parameter<?> param = params[i];
            (param.getPosition() > 0 ? numbered : unNumbered).add(param);
        }
        Collections.sort(numbered, new Comparator<Parameter<?>>(){

            @Override
            public int compare(Parameter<?> p1, Parameter<?> p2) {
                int pos2;
                int pos1 = p1.getPosition();
                if (pos1 < (pos2 = p2.getPosition())) {
                    return -1;
                }
                if (pos2 < pos1) {
                    return 1;
                }
                throw new IllegalArgumentException("Two params have same position");
            }
        });
        ArrayList<Parameter<Object>> paramList = numbered;
        paramList.addAll(unNumbered);
        return paramList.toArray(new Parameter[0]);
    }

    public static void main(String[] args) throws Throwable {
        String usage = "\n   " + InvokeUtils.class.getName() + " [+verbose|-verbose] ... [-debug] <main-class> <arg> ...\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean debug = false;
        int nverb = 0;
        Iterator argIt = argList.iterator();
        while (argIt.hasNext()) {
            String arg = (String)argIt.next();
            if ("-h".equals(arg) || "-help".equals(arg)) {
                argIt.remove();
                System.out.println(usage);
                return;
            }
            if ("-debug".equals(arg)) {
                argIt.remove();
                debug = true;
                continue;
            }
            if ("-v".equals(arg) || "-verbose".equals(arg)) {
                argIt.remove();
                ++nverb;
                continue;
            }
            if (!"+v".equals(arg) && !"+verbose".equals(arg)) break;
            argIt.remove();
            --nverb;
        }
        InvokeUtils.configureLogging(nverb, debug);
        try {
            String clazzName = (String)argList.remove(0);
            Class<?> clazz = Class.forName(clazzName);
            Method mainMethod = clazz.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{argList.toArray(new String[0])});
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Throwable e) {
            System.err.println(usage);
        }
    }
}

