/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.util.Destination;

public class OutputStreamParameter
extends Parameter<Destination> {
    public OutputStreamParameter(String name) {
        super(name, Destination.class, true);
        this.setUsage("<out-file>");
        this.setPrompt("Location of output file");
        this.setStringDefault("-");
        this.setDescription(new String[]{"<p>The location of the output file.  This is usually a filename", "to write to.", "If it is equal to the special value \"-\"", "the output will be written to standard output.", "</p>"});
    }

    @Override
    public Destination stringToObject(Environment env, String sval) throws ParameterValueException {
        if ("-".equals(sval)) {
            final PrintStream out = env.getOutputStream();
            return new Destination(){

                @Override
                public OutputStream createStream() {
                    return out;
                }
            };
        }
        final File file = new File(sval);
        File parentDir = new File(sval).getAbsoluteFile().getParentFile();
        if (!parentDir.exists()) {
            throw new ParameterValueException(this, "Bad pathname (no dir?)");
        }
        return new Destination(){

            @Override
            public OutputStream createStream() throws IOException {
                return new FileOutputStream(file);
            }
        };
    }
}

