/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.registry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.ivoa.registry.search.ParseException;
import net.ivoa.registry.search.Where2DOM;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.registry.SoapRequest;

public class RegistryRequestFactory {
    private static final String RS_NS = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0";

    public static SoapRequest adqlsSearch(String adqls) throws IOException {
        Element adWhereEl;
        String act = "Search";
        Where2DOM w2d = new Where2DOM(new StringReader("where " + adqls));
        try {
            adWhereEl = w2d.Where(null);
        }
        catch (ParseException e) {
            throw (IOException)new IOException("ADQL Syntax Error").initCause(e);
        }
        Document doc = adWhereEl.getOwnerDocument();
        Element rsWhereEl = doc.createElementNS(RS_NS, "rs:Where");
        for (Node child = adWhereEl.getFirstChild(); child != null; child = child.getNextSibling()) {
            rsWhereEl.appendChild(child);
        }
        Element searchEl = doc.createElementNS(RS_NS, "rs:" + act);
        searchEl.appendChild(rsWhereEl);
        return new DefaultSoapRequest(act, RegistryRequestFactory.nodeToString(searchEl));
    }

    public static SoapRequest keywordSearch(String[] keywords, boolean orValues) throws IOException {
        String act = "KeywordSearch";
        StringBuffer bbuf = new StringBuffer().append(RegistryRequestFactory.getStartEl(act)).append("<orValues>").append(orValues ? "true" : "false").append("</orValues>").append("<keywords>");
        for (int ik = 0; ik < keywords.length; ++ik) {
            if (ik > 0) {
                bbuf.append(' ');
            }
            bbuf.append(keywords[ik].replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        }
        bbuf.append("</keywords>").append(RegistryRequestFactory.getEndEl(act));
        return new DefaultSoapRequest(act, bbuf.toString());
    }

    public static SoapRequest illegalOperation() {
        String act = "DoWhat";
        String body = new StringBuffer().append(RegistryRequestFactory.getStartEl(act)).append(RegistryRequestFactory.getEndEl(act)).toString();
        return new DefaultSoapRequest(act, body);
    }

    private static String getStartEl(String act) {
        return new StringBuffer().append("<rs:").append(act).append(" ").append("xmlns:rs='").append(RS_NS).append("'>").toString();
    }

    private static String getEndEl(String act) {
        return "</rs:" + act + ">";
    }

    private static String nodeToString(Node node) throws IOException {
        DOMSource xsrc = new DOMSource(node);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamResult xres = new StreamResult(bout);
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("encoding", "UTF-8");
            trans.transform(xsrc, xres);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
        bout.flush();
        return new String(bout.toByteArray(), "utf-8");
    }

    private static class DefaultSoapRequest
    implements SoapRequest {
        private final String action_;
        private final String body_;

        DefaultSoapRequest(String act, String body) {
            this.action_ = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0#" + act;
            this.body_ = body;
        }

        @Override
        public String getAction() {
            return this.action_;
        }

        @Override
        public String getBody() {
            return this.body_;
        }
    }
}

