/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.hapi.HapiService;
import uk.ac.starlink.hapi.HapiServiceException;
import uk.ac.starlink.hapi.HapiVersion;
import uk.ac.starlink.hapi.Times;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.IOConsumer;
import uk.ac.starlink.util.IOSupplier;

public class ChunkStreamer {
    private final HapiService service_;
    private final int chunkLimit_;
    private final IOConsumer<String> limitCallback_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");

    public ChunkStreamer(HapiService service, int chunkLimit, IOConsumer<String> limitCallback) {
        this.service_ = service;
        this.chunkLimit_ = chunkLimit;
        this.limitCallback_ = limitCallback;
    }

    public int getChunkLimit() {
        return this.chunkLimit_;
    }

    public InputStream openMultiChunkStream(URL requestUrl) throws IOException {
        Map<String, String> reqParams = HapiService.getRequestParameters(requestUrl);
        Limit tmin = null;
        Limit tmax = null;
        for (HapiVersion version : HapiVersion.getStandardVersions()) {
            String stopParam;
            String stop;
            String startParam;
            String start;
            if (tmin == null && (start = reqParams.get(startParam = version.getStartRequestParam())) != null) {
                tmin = new Limit(startParam, start);
            }
            if (tmax != null || (stop = reqParams.get(stopParam = version.getStopRequestParam())) == null) continue;
            tmax = new Limit(stopParam, stop);
        }
        return this.chunkStream(requestUrl, tmin, tmax, new Progress(tmin.isoTime_, tmax.isoTime_));
    }

    private InputStream chunkStream(URL requestUrl, Limit tmin, Limit tmax, Progress progress) throws IOException {
        if (progress.ichunk_ >= this.chunkLimit_) {
            if (!progress.hasExceeded_) {
                progress.hasExceeded_ = true;
                if (this.limitCallback_ != null) {
                    String msg = "HAPI load chunk limit exceeded (" + this.chunkLimit_ + " " + (this.chunkLimit_ == 1 ? "chunk" : "chunks") + ", " + progress.getTimePercent(tmax.isoTime_) + "%)";
                    this.limitCallback_.accept(msg);
                }
            }
            return null;
        }
        try {
            return this.openStream(requestUrl, tmin, tmax, progress);
        }
        catch (HapiServiceException e) {
            if (e.getHapiCode() == 1408) {
                String midIso = ChunkStreamer.getIsoMidpoint(tmin.isoTime_, tmax.isoTime_);
                List<IOSupplier> streamSuppliers = Arrays.asList(() -> this.chunkStream(requestUrl, tmin, tmax.replaceTime(midIso), progress), () -> this.chunkStream(requestUrl, tmin.replaceTime(midIso), tmax, progress));
                return new SeqInputStream(streamSuppliers.iterator());
            }
            throw e;
        }
    }

    private InputStream openStream(URL templateUrl, Limit tmin, Limit tmax, Progress progress) throws IOException {
        String urlBase = templateUrl.toString();
        urlBase = urlBase.substring(0, urlBase.indexOf(63));
        Map<String, String> reqParams = HapiService.getRequestParameters(templateUrl);
        if (progress.ichunk_ > 0) {
            reqParams.remove("include");
        }
        reqParams.put(tmin.reqParam_, tmin.isoTime_);
        reqParams.put(tmax.reqParam_, tmax.isoTime_);
        CgiQuery query = new CgiQuery(urlBase);
        query.allowUnencodedChars(":,");
        for (Map.Entry<String, String> entry : reqParams.entrySet()) {
            query.addArgument(entry.getKey(), entry.getValue());
        }
        InputStream in = this.service_.openStream(query.toURL());
        ++progress.ichunk_;
        logger_.info("HAPI data chunk request " + progress.ichunk_ + " of max " + this.chunkLimit_ + ", " + progress.getTimePercent(tmax.isoTime_) + "%");
        return in;
    }

    private static String getIsoMidpoint(String isoMin, String isoMax) {
        double secMin = Times.isoToUnixSeconds(isoMin);
        double secMax = Times.isoToUnixSeconds(isoMax);
        double secMid = 0.5 * (secMax + secMin);
        return Times.formatUnixSeconds((long)secMid, "yyyy-MM-dd'T'HH:mm:ss");
    }

    private static class SeqInputStream
    extends InputStream {
        private final Iterator<IOSupplier<InputStream>> streamIt_;
        private InputStream in_;

        public SeqInputStream(Iterator<IOSupplier<InputStream>> streamIt) throws IOException {
            this.streamIt_ = streamIt;
            this.nextStream();
        }

        @Override
        public int available() throws IOException {
            return this.in_ == null ? 0 : this.in_.available();
        }

        @Override
        public int read() throws IOException {
            if (this.in_ == null) {
                return -1;
            }
            int c = this.in_.read();
            if (c == -1) {
                this.nextStream();
                return this.read();
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.in_ == null) {
                return -1;
            }
            int n = this.in_.read(b, off, len);
            if (n <= 0) {
                this.nextStream();
                return this.read(b, off, len);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            do {
                this.nextStream();
            } while (this.in_ != null);
        }

        private void nextStream() throws IOException {
            if (this.in_ != null) {
                this.in_.close();
            }
            if (this.streamIt_.hasNext()) {
                this.in_ = this.streamIt_.next().get();
                if (this.in_ == null) {
                    this.close();
                }
            } else {
                this.in_ = null;
            }
        }
    }

    private static class Progress {
        final String startIso_;
        final String stopIso_;
        int ichunk_;
        boolean hasExceeded_;

        Progress(String startIso, String stopIso) {
            this.startIso_ = startIso;
            this.stopIso_ = stopIso;
        }

        public double getTimeFraction(String epochIso) {
            double epochSec = Times.isoToUnixSeconds(epochIso);
            double startSec = Times.isoToUnixSeconds(this.startIso_);
            double stopSec = Times.isoToUnixSeconds(this.stopIso_);
            return (epochSec - startSec) / (stopSec - startSec);
        }

        public int getTimePercent(String epochIso) {
            return (int)Math.round(100.0 * this.getTimeFraction(epochIso));
        }
    }

    private static class Limit {
        final String reqParam_;
        final String isoTime_;

        Limit(String reqParam, String isoTime) {
            this.reqParam_ = reqParam;
            this.isoTime_ = isoTime;
        }

        Limit replaceTime(String isoTime) {
            return new Limit(this.reqParam_, isoTime);
        }
    }
}

