/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.starlink.util.ByteList;

public class CsvReader {
    private final ByteList buf_ = new ByteList();
    private final List<String> words_ = new ArrayList<String>();
    private final Set<String> warnings_ = new HashSet<String>();
    private Byte byte0_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");

    public void setPrefixByte(byte byte0) {
        this.byte0_ = byte0;
    }

    public String[] readCsvRow(InputStream in) throws IOException {
        this.buf_.clear();
        this.words_.clear();
        State state = State.INIT;
        if (this.byte0_ != null) {
            state = this.processByte(state, this.byte0_.byteValue());
            this.byte0_ = null;
        }
        while (!state.isEnd_) {
            state = this.processByte(state, in.read());
        }
        return state == State.END_FILE ? null : this.words_.toArray(new String[0]);
    }

    private void warning(String msg) {
        if (this.warnings_.add(msg)) {
            logger_.warning(msg);
        }
    }

    private State processByte(State state, int b) {
        switch (state) {
            case INIT: {
                switch (b) {
                    case -1: {
                        return State.END_FILE;
                    }
                    case 34: {
                        return State.READING_QUOTED;
                    }
                    case 44: {
                        this.addCurrentWord();
                        return State.INIT;
                    }
                    case 10: 
                    case 13: {
                        return State.INIT;
                    }
                }
                this.addByte(b);
                return State.READING_UNQUOTED;
            }
            case READING_UNQUOTED: {
                switch (b) {
                    case -1: {
                        this.addCurrentWord();
                        return State.END_FILE;
                    }
                    case 44: {
                        this.addCurrentWord();
                        return State.INIT;
                    }
                    case 10: 
                    case 13: {
                        this.addCurrentWord();
                        return State.END_LINE;
                    }
                    case 34: {
                        if (CsvReader.isWhitespace(this.buf_)) {
                            this.buf_.clear();
                            return State.READING_QUOTED;
                        }
                        this.addByte(b);
                        return State.READING_QUOTED;
                    }
                }
                this.addByte(b);
                return State.READING_UNQUOTED;
            }
            case READING_QUOTED: {
                switch (b) {
                    case -1: {
                        this.warning("EOF during quoted field");
                        this.addCurrentWord();
                        return State.END_FILE;
                    }
                    case 34: {
                        return State.QUOTE_IN_QUOTED;
                    }
                }
                this.addByte(b);
                return State.READING_QUOTED;
            }
            case QUOTE_IN_QUOTED: {
                switch (b) {
                    case -1: {
                        this.warning("EOF during quoted field");
                        this.addCurrentWord();
                        return State.END_FILE;
                    }
                    case 34: {
                        this.addByte(34);
                        return State.READING_QUOTED;
                    }
                }
                this.addCurrentWord();
                return State.END_QUOTED;
            }
            case END_QUOTED: {
                switch (b) {
                    case -1: {
                        return State.END_FILE;
                    }
                    case 44: {
                        return State.INIT;
                    }
                    case 10: 
                    case 13: {
                        return State.END_LINE;
                    }
                    case 32: {
                        this.warning("Space following quoted field");
                        return State.END_QUOTED;
                    }
                }
                this.warning("Content following quoted field");
                return State.END_QUOTED;
            }
        }
        assert (false);
        this.warning("Unexpected state (programming error)");
        return State.ERROR;
    }

    private void addByte(int b) {
        assert (b == (b & 0xFF));
        this.buf_.add((byte)b);
    }

    private void addCurrentWord() {
        this.words_.add(this.buf_.decodeUtf8());
        this.buf_.clear();
    }

    private static boolean isWhitespace(ByteList buf) {
        int nb = buf.size();
        for (int i = 0; i < nb; ++i) {
            if (i == 32) continue;
            return false;
        }
        return true;
    }

    private static enum State {
        INIT(false),
        READING_UNQUOTED(false),
        READING_QUOTED(false),
        QUOTE_IN_QUOTED(false),
        END_QUOTED(false),
        END_LINE(true),
        END_FILE(true),
        ERROR(true);

        final boolean isEnd_;

        private State(boolean isEnd) {
            this.isEnd_ = isEnd;
        }
    }
}

