/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import uk.ac.starlink.hapi.HapiTableLoadDialog;
import uk.ac.starlink.hapi.SlideDateRanger;
import uk.ac.starlink.hapi.Times;
import uk.ac.starlink.table.gui.LabelledComponentStack;

public class DateRangePanel
extends JPanel {
    private final JTextField startField_;
    private final JTextField stopField_;
    private final JLabel minLabel_;
    private final JLabel maxLabel_;
    private final ButtonModel lockModel_;
    private final SlideDateRanger slideRanger_;
    private final DateFormat isoFormat_ = Times.createDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private String isoMin_;
    private String isoMax_;
    private String isoStart_;
    private String isoStop_;
    public static final String PROP_ISOSTART = "isoStart";
    public static final String PROP_ISOSTOP = "isoStop";

    public DateRangePanel() {
        super(new BorderLayout());
        this.startField_ = new JTextField();
        this.startField_.addCaretListener(evt -> this.updateStart());
        this.stopField_ = new JTextField();
        this.stopField_.addCaretListener(evt -> this.updateStop());
        this.minLabel_ = new JLabel();
        this.maxLabel_ = new JLabel();
        JToggleButton lockButton = new JToggleButton(HapiTableLoadDialog.createIcon("lock.png"));
        lockButton.setToolTipText("Prevent auto-update of start/stop dates");
        this.lockModel_ = lockButton.getModel();
        this.slideRanger_ = new SlideDateRanger();
        this.slideRanger_.addPropertyChangeListener("range", evt -> this.updateFromSlider());
        this.lockModel_.addActionListener(evt -> {
            boolean isSlide = !this.lockModel_.isSelected();
            this.slideRanger_.setEnabled(!this.lockModel_.isSelected());
            this.updateFromSlider();
        });
        Box startBox = Box.createHorizontalBox();
        startBox.add(this.startField_);
        startBox.add(Box.createHorizontalStrut(10));
        startBox.add(this.minLabel_);
        Box stopBox = Box.createHorizontalBox();
        stopBox.add(this.stopField_);
        stopBox.add(Box.createHorizontalStrut(10));
        stopBox.add(this.maxLabel_);
        LabelledComponentStack fieldStack = new LabelledComponentStack();
        fieldStack.addLine("Start Date", null, startBox, true);
        fieldStack.addLine("Stop Date", null, stopBox, true);
        lockButton.setMargin(new Insets(0, 0, 0, 0));
        Box fieldLine = Box.createHorizontalBox();
        fieldLine.add(Box.createHorizontalStrut(5));
        fieldLine.add(lockButton);
        fieldLine.add(Box.createHorizontalStrut(5));
        fieldLine.add(fieldStack);
        Box box = Box.createVerticalBox();
        box.add(fieldLine);
        box.add(this.slideRanger_);
        this.add((Component)box, "North");
        this.setIsoLimits(null, null);
    }

    public void setIsoLimits(String isoMin, String isoMax) {
        long[] lArray;
        this.isoMin_ = isoMin;
        this.isoMax_ = isoMax;
        this.minLabel_.setText(isoMin == null ? "" : ">= " + isoMin + " ");
        this.maxLabel_.setText(isoMax == null ? "" : "<= " + isoMax + " ");
        double dmin = Times.isoToUnixSeconds(isoMin);
        double dmax = Times.isoToUnixSeconds(isoMax);
        if (dmin < dmax) {
            long[] lArray2 = new long[2];
            lArray2[0] = (long)dmin;
            lArray = lArray2;
            lArray2[1] = (long)dmax;
        } else {
            long[] lArray3 = new long[2];
            lArray3[0] = 0L;
            lArray = lArray3;
            lArray3[1] = 0L;
        }
        long[] secLimits = lArray;
        this.slideRanger_.setLimits(secLimits[0], secLimits[1]);
        this.revalidate();
    }

    public String getIsoStart() {
        return this.isoStart_ == null ? "" : this.isoStart_;
    }

    public String getIsoStop() {
        return this.isoStop_ == null ? "" : this.isoStop_;
    }

    public void setIsoStart(String isoStart) {
        String txt = isoStart == null ? "" : (Times.isoToUnixSeconds(isoStart) <= Times.isoToUnixSeconds(this.isoMin_) ? this.isoMin_ : isoStart);
        this.startField_.setText(txt);
        this.updateStart();
    }

    public void setIsoStop(String isoStop) {
        String txt = isoStop == null ? "" : (Times.isoToUnixSeconds(isoStop) >= Times.isoToUnixSeconds(this.isoMax_) ? this.isoMax_ : isoStop);
        this.stopField_.setText(txt);
        this.updateStop();
    }

    public void configureFromTemplate(DateRangePanel other) {
        boolean isLock = other.lockModel_.isSelected();
        this.lockModel_.setSelected(isLock);
        if (isLock) {
            this.setIsoStart(other.getIsoStart());
            this.setIsoStop(other.getIsoStop());
        }
    }

    private void updateFromSlider() {
        if (!this.lockModel_.isSelected()) {
            long[] range = this.slideRanger_.getRange();
            this.setIsoStart(Times.formatUnixSeconds(range[0], this.isoFormat_));
            this.setIsoStop(Times.formatUnixSeconds(range[1], this.isoFormat_));
            this.updateStart();
            this.updateStop();
        }
    }

    private void updateStart() {
        String oldStart = this.isoStart_;
        String newStart = this.startField_.getText().trim();
        if (!Objects.equals(oldStart, newStart)) {
            this.isoStart_ = newStart;
            this.firePropertyChange(PROP_ISOSTART, oldStart, newStart);
        }
    }

    private void updateStop() {
        String oldStop = this.isoStop_;
        String newStop = this.stopField_.getText().trim();
        if (!Objects.equals(oldStop, newStop)) {
            this.isoStop_ = newStop;
            this.firePropertyChange(PROP_ISOSTOP, oldStop, newStop);
        }
    }
}

