/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FilterListModel<T>
extends AbstractListModel<T> {
    private final BiPredicate<T, String> matcher_;
    private final JTextField filterField_;
    private final JLabel countLabel_;
    private final JComponent filterPanel_;
    private List<T> items_;
    private List<T> visibleItems_;

    public FilterListModel() {
        this("Filter", (e, txt) -> e.toString().toLowerCase().indexOf(txt.toLowerCase()) >= 0);
    }

    public FilterListModel(String title, BiPredicate<T, String> matcher) {
        this.matcher_ = matcher;
        this.filterField_ = new JTextField(12);
        this.filterField_.addCaretListener(evt -> this.updateState());
        this.countLabel_ = new JLabel();
        this.filterPanel_ = Box.createVerticalBox();
        Box titleLine = Box.createHorizontalBox();
        titleLine.add(new JLabel(title));
        titleLine.add(Box.createHorizontalGlue());
        Box countLine = Box.createHorizontalBox();
        countLine.add(Box.createHorizontalGlue());
        countLine.add(this.countLabel_);
        if (title != null) {
            this.filterPanel_.add(titleLine);
        }
        this.filterPanel_.add(this.filterField_);
        this.filterPanel_.add(countLine);
        this.visibleItems_ = Collections.emptyList();
        this.setItems(Collections.emptyList());
    }

    public void setItems(List<T> items) {
        int oldSize = items.size();
        this.items_ = Collections.emptyList();
        this.fireIntervalRemoved(this, 0, oldSize);
        this.items_ = items;
        this.fireIntervalAdded(this, 0, this.items_.size());
        this.updateState();
    }

    public JTextField getFilterField() {
        return this.filterField_;
    }

    public JComponent getFilterPanel() {
        return this.filterPanel_;
    }

    @Override
    public int getSize() {
        return this.visibleItems_.size();
    }

    @Override
    public T getElementAt(int i) {
        return this.visibleItems_.get(i);
    }

    private void updateState() {
        String txt0 = this.filterField_.getText();
        String txt = txt0 == null ? "" : txt0.trim();
        Predicate<Object> filter = txt.length() == 0 ? item -> true : item -> item != null && this.matcher_.test(item, txt);
        int nvis = this.visibleItems_ == null ? 0 : this.visibleItems_.size();
        List newVisibleItems = this.items_.stream().filter(filter).collect(Collectors.toList());
        if (newVisibleItems.size() != nvis) {
            this.visibleItems_ = Collections.emptyList();
            this.fireIntervalRemoved(this, 0, nvis);
            this.visibleItems_ = newVisibleItems;
            this.fireIntervalAdded(this, 0, this.visibleItems_.size());
            this.countLabel_.setText(Integer.toString(this.visibleItems_.size()) + " / " + Integer.toString(this.items_.size()));
        }
    }
}

