/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.IOException;
import java.io.InputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.starlink.hapi.HapiParam;
import uk.ac.starlink.hapi.HapiVersion;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.util.ByteList;

public interface HapiInfo {
    public HapiVersion getHapiVersion();

    public HapiParam[] getParameters();

    public String getStartDate();

    public String getStopDate();

    public String getFormat();

    public String getResourceUrl();

    public String getCadence();

    public String getMaxRequestDuration();

    public String getSampleStartDate();

    public String getSampleStopDate();

    public String getMetadata(String var1);

    public static HapiInfo fromJson(final JSONObject json) {
        HapiParam[] params;
        final HapiVersion version = HapiVersion.fromText(json.optString("HAPI", null));
        final String startDate = json.optString("startDate", null);
        final String stopDate = json.optString("stopDate", null);
        final String format = json.optString("format", null);
        final String resourceUrl = json.optString("resourceURL", null);
        final String cadence = json.optString("cadence", null);
        final String maxRequestDuration = json.optString("maxRequestDuration", null);
        final String sampleStartDate = json.optString("sampleStartDate", null);
        final String sampleStopDate = json.optString("sampleStopDate", null);
        JSONArray paramArray = json.optJSONArray("parameters");
        if (paramArray != null) {
            int np = paramArray.length();
            params = new HapiParam[np];
            for (int ip = 0; ip < np; ++ip) {
                params[ip] = HapiParam.fromJson(paramArray.optJSONObject(ip));
            }
        } else {
            params = new HapiParam[]{};
        }
        return new HapiInfo(){

            @Override
            public HapiVersion getHapiVersion() {
                return version;
            }

            @Override
            public String getStartDate() {
                return startDate;
            }

            @Override
            public String getStopDate() {
                return stopDate;
            }

            @Override
            public String getFormat() {
                return format;
            }

            @Override
            public String getResourceUrl() {
                return resourceUrl;
            }

            @Override
            public String getCadence() {
                return cadence;
            }

            @Override
            public String getMaxRequestDuration() {
                return maxRequestDuration;
            }

            @Override
            public String getSampleStartDate() {
                return sampleStartDate;
            }

            @Override
            public String getSampleStopDate() {
                return sampleStopDate;
            }

            @Override
            public HapiParam[] getParameters() {
                return (HapiParam[])params.clone();
            }

            @Override
            public String getMetadata(String key) {
                return json.optString(key, null);
            }
        };
    }

    public static HapiInfo fromCommentedStream(InputStream in, int[] overread1) throws IOException {
        JSONObject json;
        String jsonTxt = HapiInfo.readCommentedText(in, overread1);
        try {
            json = new JSONObject(jsonTxt);
        }
        catch (JSONException e) {
            throw new TableFormatException("Bad JSON in header", e);
        }
        try {
            return HapiInfo.fromJson(json);
        }
        catch (JSONException e) {
            throw new TableFormatException("Trouble parsing HAPI JSON", e);
        }
    }

    public static String readCommentedText(InputStream in, int[] overread1) throws IOException {
        ByteList buf = new ByteList();
        boolean isStart = true;
        block5: while (true) {
            int b = in.read();
            switch (b) {
                case -1: {
                    if (overread1 != null) {
                        overread1[0] = -1;
                    }
                    return buf.decodeUtf8();
                }
                case 10: 
                case 13: {
                    if (isStart) continue block5;
                    isStart = true;
                    buf.add((byte)10);
                    continue block5;
                }
                case 35: {
                    isStart = false;
                    continue block5;
                }
            }
            if (isStart) {
                if (overread1 != null) {
                    overread1[0] = b;
                }
                return buf.decodeUtf8();
            }
            buf.add((byte)b);
        }
    }
}

