/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import uk.ac.starlink.hapi.ChunkStreamer;
import uk.ac.starlink.hapi.HapiEndpoint;
import uk.ac.starlink.hapi.HapiServiceException;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.IOConsumer;
import uk.ac.starlink.util.URLUtils;

public class HapiService {
    private final String serviceUrl_;
    private final Supplier<ContentCoding> codingSupplier_;
    private static final Pattern HAPI_CODE_REGEX = Pattern.compile(".*[^0-9](1[0-9]{3})[^0-9].*");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");

    public HapiService(String url) throws MalformedURLException {
        this(url, null);
    }

    public HapiService(String url, Supplier<ContentCoding> codingSupplier) throws MalformedURLException {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new MalformedURLException("Bad HAPI server URL: " + url);
        }
        URLUtils.newURL(url);
        StringBuffer sbuf = new StringBuffer(url);
        if (sbuf.charAt(sbuf.length() - 1) != '/') {
            sbuf.append("/");
        }
        this.serviceUrl_ = sbuf.toString();
        this.codingSupplier_ = codingSupplier == null ? () -> ContentCoding.GZIP : codingSupplier;
    }

    public URL createQuery(HapiEndpoint endpoint, Map<String, String> requestParams) {
        CgiQuery query = new CgiQuery(this.serviceUrl_ + endpoint.getEndpoint());
        query.allowUnencodedChars(":,");
        if (requestParams != null) {
            for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                query.addArgument(entry.getKey(), entry.getValue());
            }
        }
        return query.toURL();
    }

    public InputStream openStream(URL url) throws IOException {
        String urlTxt = url.toString();
        String endpoint = urlTxt.startsWith(this.serviceUrl_) ? urlTxt.substring(this.serviceUrl_.length()).replaceFirst("[/?].*", "") : null;
        String reqTxt = endpoint == null ? "HAPI request" : "HAPI " + endpoint + " request";
        logger_.info(reqTxt + ": " + url);
        ContentCoding coding = this.codingSupplier_.get();
        HttpURLConnection hconn = (HttpURLConnection)coding.openConnection(url);
        hconn.setInstanceFollowRedirects(false);
        hconn = (HttpURLConnection)URLUtils.followRedirects(hconn, null);
        hconn.connect();
        int httpCode = hconn.getResponseCode();
        String httpMsg = hconn.getResponseMessage();
        if (httpCode != 200) {
            throw HapiService.createException(httpCode, httpMsg, urlTxt);
        }
        return coding.getInputStream(hconn);
    }

    public InputStream openChunkedStream(URL url, int chunkLimit, IOConsumer<String> limitCallback) throws IOException {
        return new ChunkStreamer(this, chunkLimit, limitCallback).openMultiChunkStream(url);
    }

    public JSONObject readJson(HapiEndpoint endpoint) throws IOException {
        return this.readJson(endpoint, null);
    }

    public JSONObject readJson(HapiEndpoint endpoint, Map<String, String> requestParams) throws IOException {
        return this.readJson(this.createQuery(endpoint, requestParams));
    }

    public int hashCode() {
        return this.serviceUrl_.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof HapiService) {
            HapiService other = (HapiService)o;
            return this.serviceUrl_.equals(other.serviceUrl_);
        }
        return false;
    }

    private JSONObject readJson(URL url) throws IOException {
        Throwable throwable = null;
        try (InputStream in = this.openStream(url);){
            Object json;
            try {
                json = new JSONTokener(in).nextValue();
            }
            catch (JSONException e) {
                throw new IOException("Not a JSON object at: " + url, e);
            }
            if (json instanceof JSONObject) {
                JSONObject jSONObject = (JSONObject)json;
                return jSONObject;
            }
            try {
                throw new IOException("Not a JSON object at: " + url);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static Map<String, String> getRequestParameters(URL hapiUrl) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String query = hapiUrl.getQuery();
        if (query != null) {
            for (String assignment : query.split("&", -1)) {
                String[] parts = assignment.split("=", 2);
                map.put(HapiService.urlDecode(parts[0]), HapiService.urlDecode(parts[1]));
            }
        }
        return map;
    }

    private static String urlDecode(String txt) {
        if (txt.indexOf(37) < 0) {
            return txt;
        }
        int nc = txt.length();
        StringBuffer sbuf = new StringBuffer(nc * 2);
        for (int i = 0; i < nc; ++i) {
            char c = txt.charAt(i);
            if (c == '%') {
                sbuf.append((char)Integer.parseInt(txt.substring(i + 1, i + 3), 16));
                i += 2;
                continue;
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    private static IOException createException(int httpCode, String httpMsg, String urlTxt) {
        if (httpMsg != null) {
            Matcher matcher = HAPI_CODE_REGEX.matcher(httpMsg);
            if (matcher.matches()) {
                int hapiCode = Integer.parseInt(matcher.group(1));
                return new HapiServiceException(httpMsg, hapiCode);
            }
            return new IOException("HAPI load error: " + httpMsg);
        }
        return new IOException("HAPI load error: " + httpCode);
    }
}

