/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import uk.ac.starlink.hapi.HapiBrowser;
import uk.ac.starlink.hapi.HapiService;
import uk.ac.starlink.hapi.HapiSource;
import uk.ac.starlink.hapi.ServerListing;
import uk.ac.starlink.hapi.ServerMeta;
import uk.ac.starlink.hapi.ServicePanel;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.gui.AbstractTableLoadDialog;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.IOConsumer;

public class HapiTableLoadDialog
extends AbstractTableLoadDialog {
    private final Consumer<URL> docUrlHandler_;
    private HapiBrowser browser_;
    private JMenu menu_;
    private Action[] toolActs_;
    private boolean failOnLimit_;
    private static final Icon ICON_TRUE_ALL = HapiTableLoadDialog.createIcon("trueAll.png");
    private static final Icon ICON_FALSE_ALL = HapiTableLoadDialog.createIcon("falseAll.png");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");

    public HapiTableLoadDialog() {
        this(null);
    }

    public HapiTableLoadDialog(Consumer<URL> docUrlHandler) {
        super("HAPI Query", "Load time series using Heliophysics Data Application Programmer's Interface service");
        this.docUrlHandler_ = docUrlHandler;
        this.setIconUrl(HapiTableLoadDialog.class.getResource("hapi.png"));
    }

    @Override
    protected Component createQueryComponent() {
        this.menu_ = new JMenu("HAPI");
        JMenu serverMenu = new JMenu("Server List");
        ButtonGroup serverButtGroup = new ButtonGroup();
        ServerListing[] serverListingArray = ServerListing.LISTINGS;
        int n = serverListingArray.length;
        for (int i = 0; i < n; ++i) {
            ServerListing slist;
            final ServerListing serverListing = slist = serverListingArray[i];
            AbstractAction act = new AbstractAction(serverListing.toString()){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new Thread(() -> {
                        ServerMeta[] servers = serverListing.getServers();
                        SwingUtilities.invokeLater(() -> HapiTableLoadDialog.this.browser_.setServers(servers));
                    }, "HAPI service list loader").start();
                }
            };
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(act);
            serverButtGroup.add(menuItem);
            serverMenu.add(menuItem);
        }
        this.menu_.add(serverMenu);
        JMenu formatMenu = new JMenu("Streaming Format");
        ButtonGroup formatButtGroup = new ButtonGroup();
        String[] stringArray = new String[]{null, "csv", "binary"};
        int slist = stringArray.length;
        for (int serverListing = 0; serverListing < slist; ++serverListing) {
            String fmt;
            final String format = fmt = stringArray[serverListing];
            AbstractAction act = new AbstractAction(fmt == null ? "Auto" : fmt){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    HapiTableLoadDialog.this.browser_.setFormat(format);
                }
            };
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(act);
            formatButtGroup.add(menuItem);
            formatMenu.add(menuItem);
        }
        this.menu_.add(formatMenu);
        JCheckBoxMenuItem failmodeMenuItem = new JCheckBoxMenuItem("Fail on Limit");
        failmodeMenuItem.addActionListener(evt -> {
            this.failOnLimit_ = failmodeMenuItem.isSelected();
        });
        this.menu_.add(failmodeMenuItem);
        JCheckBoxMenuItem headerMenuItem = new JCheckBoxMenuItem("Include Header with Data");
        headerMenuItem.addActionListener(evt -> this.browser_.setIncludeHeader(headerMenuItem.isSelected()));
        headerMenuItem.setSelected(false);
        this.menu_.add(headerMenuItem);
        JCheckBoxMenuItem gzipMenuItem = new JCheckBoxMenuItem("GZIP coding");
        gzipMenuItem.setSelected(true);
        this.menu_.add(gzipMenuItem);
        Supplier<ContentCoding> codingSupplier = () -> gzipMenuItem.isSelected() ? ContentCoding.GZIP : ContentCoding.NONE;
        this.toolActs_ = new Action[]{this.createIncludeAllAction(false), this.createIncludeAllAction(true)};
        this.browser_ = new HapiBrowser(codingSupplier, this.docUrlHandler_);
        this.browser_.addPropertyChangeListener("hapiSource", evt -> this.updateReady());
        serverMenu.getItem(0).doClick();
        formatMenu.getItem(0).doClick();
        return this.browser_;
    }

    @Override
    public JMenu[] getMenus() {
        return new JMenu[]{this.menu_};
    }

    @Override
    public Action[] getToolbarActions() {
        return this.toolActs_;
    }

    @Override
    public boolean isReady() {
        return this.browser_.getHapiSource() != null;
    }

    @Override
    public TableLoader createTableLoader() {
        final HapiSource hsrc = this.browser_.getHapiSource();
        final int chunkLimit = this.browser_.getChunkLimit();
        final boolean failOnLimit = this.failOnLimit_;
        if (hsrc != null) {
            HapiService service = this.browser_.getService();
            return new TableLoader(){

                @Override
                public String getLabel() {
                    return hsrc.getLabel();
                }

                @Override
                public TableSequence loadTables(final StarTableFactory tfact) throws IOException {
                    return new TableSequence(){
                        boolean isDone_;

                        @Override
                        public StarTable nextTable() throws IOException {
                            if (!this.isDone_) {
                                this.isDone_ = true;
                                return HapiTableLoadDialog.createHapiTable(tfact, hsrc, chunkLimit, failOnLimit);
                            }
                            return null;
                        }
                    };
                }
            };
        }
        return null;
    }

    private Action createIncludeAllAction(final boolean isIncluded) {
        AbstractAction act = new AbstractAction((isIncluded ? "Include" : "Exclude") + " all fields"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicePanel sp = HapiTableLoadDialog.this.browser_.getServicePanel();
                if (sp != null) {
                    sp.setAllIncluded(isIncluded);
                }
            }
        };
        act.putValue("ShortDescription", (isIncluded ? "Select" : "Unselect") + " all rows of displayed dataset for download");
        act.putValue("SmallIcon", isIncluded ? ICON_TRUE_ALL : ICON_FALSE_ALL);
        return act;
    }

    static Icon createIcon(String name) {
        URL url = HapiTableLoadDialog.class.getResource(name);
        if (url != null) {
            return new ImageIcon(url);
        }
        assert (false);
        return null;
    }

    private static StarTable createHapiTable(StarTableFactory tfact, HapiSource hsrc, int chunkLimit, boolean failOnLimit) throws IOException {
        RowStore rowStore = tfact.getStoragePolicy().makeRowStore();
        boolean[] overflowFlag = new boolean[1];
        IOConsumer<String> limitCallback = msg -> {
            overflowFlag[0] = true;
            if (failOnLimit) {
                throw new IOException((String)msg);
            }
            logger_.warning(msg + " - table truncated");
        };
        hsrc.streamHapi(rowStore, chunkLimit, limitCallback);
        StarTable table = rowStore.getStarTable();
        if (overflowFlag[0]) {
            table.setParameter(new DescribedValue(Tables.QUERY_STATUS_INFO, "OVERFLOW"));
        }
        table.setURL(hsrc.getStandaloneUrl());
        return table;
    }
}

