/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.json.JSONObject;
import uk.ac.starlink.hapi.DateRangePanel;
import uk.ac.starlink.hapi.FilterListModel;
import uk.ac.starlink.hapi.HapiBrowser;
import uk.ac.starlink.hapi.HapiCapabilities;
import uk.ac.starlink.hapi.HapiCatalog;
import uk.ac.starlink.hapi.HapiEndpoint;
import uk.ac.starlink.hapi.HapiInfo;
import uk.ac.starlink.hapi.HapiParam;
import uk.ac.starlink.hapi.HapiService;
import uk.ac.starlink.hapi.HapiSource;
import uk.ac.starlink.hapi.HapiVersion;
import uk.ac.starlink.hapi.Times;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.util.gui.ArrayTableColumn;
import uk.ac.starlink.util.gui.ArrayTableModel;

public class ServicePanel
extends JPanel {
    private final HapiService service_;
    private final Consumer<URL> docUrlHandler_;
    private final Map<String, DatasetMeta> metaMap_;
    private final JList<String> dsList_;
    private final FilterListModel<String> dslistModel_;
    private final JTable paramTable_;
    private final ParamTableModel paramTableModel_;
    private final JSplitPane splitter_;
    private final DateRangePanel rangePanel_;
    private final JLabel cadenceLabel_;
    private final JLabel maxDurationLabel_;
    private final JTextField resourceUrlField_;
    private HapiVersion hapiVersion_;
    private boolean supportsBinary_;
    private Supplier<String> formatSupplier_;
    private BooleanSupplier headerInclusion_;
    private String dsId_;
    private HapiSource hapiSrc_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");

    public ServicePanel(HapiService service, Consumer<URL> docUrlHandler) {
        super(new BorderLayout());
        this.service_ = service;
        this.docUrlHandler_ = docUrlHandler;
        this.hapiVersion_ = HapiVersion.ASSUMED;
        this.metaMap_ = new HashMap<String, DatasetMeta>();
        this.dslistModel_ = new FilterListModel();
        this.dsList_ = new JList<String>(this.dslistModel_);
        this.dsList_.setSelectionMode(0);
        this.paramTableModel_ = new ParamTableModel();
        this.paramTable_ = new JTable(this.paramTableModel_);
        this.paramTable_.setRowSelectionAllowed(false);
        this.paramTable_.setColumnSelectionAllowed(false);
        this.dsList_.addListSelectionListener(evt -> this.setDataset(this.dsList_.getSelectedValue()));
        JComponent filterPanel = this.dslistModel_.getFilterPanel();
        this.rangePanel_ = new DateRangePanel();
        this.cadenceLabel_ = new JLabel();
        this.maxDurationLabel_ = new JLabel();
        this.resourceUrlField_ = new JTextField();
        this.resourceUrlField_.setEditable(false);
        if (this.docUrlHandler_ != null) {
            this.resourceUrlField_.setForeground(Color.BLUE);
            this.resourceUrlField_.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    URL url;
                    try {
                        url = URLUtils.newURL(ServicePanel.this.resourceUrlField_.getText());
                    }
                    catch (MalformedURLException e) {
                        return;
                    }
                    ServicePanel.this.docUrlHandler_.accept(url);
                }
            });
        }
        this.paramTableModel_.addTableModelListener(evt -> this.updateHapiSource());
        this.rangePanel_.addPropertyChangeListener(evt -> {
            String prop = evt.getPropertyName();
            if ("isoStart".equals(prop) || "isoStop".equals(prop)) {
                this.updateHapiSource();
            }
        });
        LabelledComponentStack metaStack = new LabelledComponentStack();
        metaStack.addLine("Cadence", this.cadenceLabel_);
        metaStack.addLine("Max Duration", this.maxDurationLabel_);
        metaStack.addLine("Resource URL", null, this.resourceUrlField_, true);
        JPanel rangeBox = new JPanel(new BorderLayout());
        rangeBox.add((Component)this.rangePanel_, "North");
        JPanel dsPanel = new JPanel(new BorderLayout());
        JPanel filterBox = new JPanel(new BorderLayout());
        filterBox.add((Component)filterPanel, "North");
        filterBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        dsPanel.add((Component)filterBox, "East");
        JScrollPane dsScroller = new JScrollPane(this.dsList_);
        dsScroller.setVerticalScrollBarPolicy(20);
        dsScroller.setHorizontalScrollBarPolicy(31);
        dsScroller.setPreferredSize(new Dimension(300, 120));
        dsPanel.add((Component)dsScroller, "Center");
        JPanel paramPanel = new JPanel(new BorderLayout());
        JScrollPane paramScroller = new JScrollPane(this.paramTable_);
        paramScroller.setVerticalScrollBarPolicy(20);
        paramScroller.setHorizontalScrollBarPolicy(30);
        paramPanel.add((Component)paramScroller, "Center");
        paramScroller.setPreferredSize(new Dimension(300, 150));
        boolean useSplit = true;
        if (useSplit) {
            this.splitter_ = new JSplitPane();
            this.splitter_.setOrientation(0);
            this.splitter_.setTopComponent(dsPanel);
            this.splitter_.setBottomComponent(paramPanel);
            this.add((Component)this.splitter_, "Center");
        } else {
            this.splitter_ = null;
            this.add((Component)dsPanel, "West");
            this.add((Component)paramPanel, "Center");
        }
        Box fieldsBox = Box.createVerticalBox();
        fieldsBox.add(metaStack);
        fieldsBox.add(rangeBox);
        this.add((Component)fieldsBox, "South");
        dsPanel.setBorder(HapiBrowser.createTitledBorder("Datasets"));
        paramPanel.setBorder(HapiBrowser.createTitledBorder("Dataset Parameters"));
        metaStack.setBorder(HapiBrowser.createTitledBorder("Dataset Metadata"));
        rangeBox.setBorder(HapiBrowser.createTitledBorder("Interval"));
        this.initForService();
    }

    public void setFormatSupplier(Supplier<String> formatSupplier) {
        this.formatSupplier_ = formatSupplier;
    }

    public void setHeaderInclusion(BooleanSupplier headerInclusion) {
        this.headerInclusion_ = headerInclusion;
    }

    public void setAllIncluded(boolean isIncluded) {
        DatasetMeta dsmeta = this.paramTableModel_.dsmeta_;
        if (dsmeta != null) {
            dsmeta.setAllIncluded(isIncluded);
        }
        this.paramTableModel_.fireTableDataChanged();
    }

    public HapiSource getHapiSource() {
        String dsId = this.dsId_;
        String startDate = this.rangePanel_.getIsoStart();
        String stopDate = this.rangePanel_.getIsoStop();
        DatasetMeta dsmeta = this.paramTableModel_.dsmeta_;
        if (dsId != null && Times.isoToUnixSeconds(startDate) < Times.isoToUnixSeconds(stopDate)) {
            String fmt;
            LinkedHashMap<String, String> reqMap = new LinkedHashMap<String, String>();
            reqMap.put(this.hapiVersion_.getDatasetRequestParam(), dsId);
            reqMap.put(this.hapiVersion_.getStartRequestParam(), startDate);
            reqMap.put(this.hapiVersion_.getStopRequestParam(), stopDate);
            if (dsmeta != null && !dsmeta.isAllIncluded()) {
                reqMap.put("parameters", Arrays.stream(dsmeta.params_).filter(p -> dsmeta.isIncluded((HapiParam)p)).map(p -> p.getName()).collect(Collectors.joining(",")));
            }
            String string = fmt = this.formatSupplier_ == null ? null : this.formatSupplier_.get();
            if (fmt != null) {
                reqMap.put("format", fmt);
            } else if (this.supportsBinary_) {
                reqMap.put("format", "binary");
            }
            String format = (String)reqMap.get("format");
            URL dataUrl = this.service_.createQuery(HapiEndpoint.DATA, reqMap);
            HapiParam[] params = dsmeta == null || this.headerInclusion_ != null && this.headerInclusion_.getAsBoolean() ? null : (HapiParam[])Arrays.stream(dsmeta.info_.getParameters()).filter(p -> dsmeta.isIncluded((HapiParam)p)).toArray(HapiParam[]::new);
            return new HapiSource(this.service_, dataUrl, params);
        }
        return null;
    }

    public DateRangePanel getDateRangePanel() {
        return this.rangePanel_;
    }

    private void updateHapiSource() {
        HapiSource hapiSrc = this.getHapiSource();
        if (!Objects.equals(this.hapiSrc_, hapiSrc)) {
            this.firePropertyChange("hapiSource", this.hapiSrc_, hapiSrc);
            this.hapiSrc_ = hapiSrc;
        }
    }

    private void setCatalog(HapiCatalog catalog) {
        this.hapiVersion_ = catalog.getHapiVersion();
        this.dslistModel_.setItems(Arrays.asList(catalog.getDatasetIds()));
        if (this.dslistModel_.getSize() > 0) {
            this.dsList_.setSelectedIndex(0);
        }
        this.revalidate();
        if (this.splitter_ != null) {
            this.splitter_.setDividerLocation(0.45);
        }
        this.repaint();
    }

    private void setDataset(String dsId) {
        if (Objects.equals(dsId, this.dsId_)) {
            return;
        }
        this.dsId_ = dsId;
        if (dsId == null) {
            this.setDatasetMeta(null);
        } else if (this.metaMap_.containsKey(dsId)) {
            this.setDatasetMeta(this.metaMap_.get(dsId));
        } else {
            this.setDatasetMeta(null);
            LinkedHashMap<String, String> infoMap = new LinkedHashMap<String, String>();
            infoMap.put(this.hapiVersion_.getDatasetRequestParam(), dsId);
            new Thread(() -> {
                JSONObject infoJson;
                try {
                    infoJson = this.service_.readJson(HapiEndpoint.INFO, infoMap);
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Info query failed", e);
                    infoJson = new JSONObject();
                }
                DatasetMeta dsmeta = new DatasetMeta(HapiInfo.fromJson(infoJson));
                SwingUtilities.invokeLater(() -> {
                    this.metaMap_.put(dsId, dsmeta);
                    if (dsId.equals(this.dsId_)) {
                        this.setDatasetMeta(dsmeta);
                    }
                });
            }, "HAPI dataset metadata load").start();
        }
    }

    private void setDatasetMeta(DatasetMeta dsmeta) {
        String[] stringArray;
        HapiInfo info;
        this.paramTableModel_.setDatasetMeta(dsmeta);
        HapiInfo hapiInfo = info = dsmeta == null ? null : dsmeta.info_;
        if (info == null) {
            stringArray = new String[2];
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = info.getStartDate();
            stringArray = stringArray2;
            stringArray2[1] = info.getStopDate();
        }
        String[] isoLimits = stringArray;
        this.rangePanel_.setIsoLimits(isoLimits[0], isoLimits[1]);
        if (this.rangePanel_.getIsoStart().trim().length() == 0) {
            String sampleStart = info == null ? null : info.getSampleStartDate();
            this.rangePanel_.setIsoStart(sampleStart);
        }
        if (this.rangePanel_.getIsoStop().trim().length() == 0) {
            String sampleStop = info == null ? null : info.getSampleStopDate();
            this.rangePanel_.setIsoStop(sampleStop);
        }
        this.cadenceLabel_.setText(info == null ? null : info.getCadence());
        this.maxDurationLabel_.setText(info == null ? null : info.getMaxRequestDuration());
        this.resourceUrlField_.setText(info == null ? null : info.getResourceUrl());
        this.resourceUrlField_.setCaretPosition(0);
        this.repaint();
        StarJTable.configureColumnWidths(this.paramTable_, 1200, 1000);
    }

    private void initForService() {
        new Thread(() -> {
            JSONObject capsJson;
            JSONObject catalogJson;
            try {
                catalogJson = this.service_.readJson(HapiEndpoint.CATALOG);
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Catalog query failed", e);
                catalogJson = new JSONObject();
            }
            HapiCatalog catalog = HapiCatalog.fromJson(catalogJson);
            SwingUtilities.invokeLater(() -> this.setCatalog(catalog));
            try {
                capsJson = this.service_.readJson(HapiEndpoint.CAPABILITIES);
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Capabilities query failed", e);
                capsJson = new JSONObject();
            }
            HapiCapabilities hapiCaps = HapiCapabilities.fromJson(capsJson);
            SwingUtilities.invokeLater(() -> {
                if (Arrays.asList(hapiCaps.getOutputFormats()).contains("binary")) {
                    this.supportsBinary_ = true;
                }
            });
        }, "HAPI service catalog load").start();
    }

    private static class ParamTableModel
    extends ArrayTableModel<HapiParam> {
        private DatasetMeta dsmeta_;

        ParamTableModel() {
            super(new HapiParam[0]);
            ArrayList<ArrayTableColumn<HapiParam, String>> colList = new ArrayList<ArrayTableColumn<HapiParam, String>>();
            colList.add(new ArrayTableColumn<HapiParam, Boolean>("Include", Boolean.class){

                @Override
                public Boolean getValue(HapiParam param) {
                    return dsmeta_.isIncluded(param);
                }
            });
            colList.add(ParamTableModel.createStringColumn("Name", p -> p.getName()));
            colList.add(ParamTableModel.createStringColumn("Type", p -> p.getType().toString()));
            colList.add(ParamTableModel.createStringColumn("Size", p -> {
                int leng = p.getLength();
                int[] size = p.getSize();
                StringBuffer sbuf = new StringBuffer();
                if (leng > 0) {
                    sbuf.append(Integer.toString(leng));
                }
                if (size != null) {
                    if (sbuf.length() > 0) {
                        sbuf.append("; ");
                    }
                    sbuf.append('[').append(DefaultValueInfo.formatShape(size)).append(']');
                }
                return sbuf.toString();
            }));
            colList.add(ParamTableModel.createStringColumn("Units", p -> {
                Object[] units = p.getUnits();
                if (units == null || units.length == 0) {
                    return null;
                }
                if (units.length == 1) {
                    return units[0];
                }
                return Arrays.toString(units);
            }));
            colList.add(ParamTableModel.createStringColumn("Description", p -> p.getDescription()));
            this.setColumns(colList);
        }

        @Override
        public boolean isCellEditable(int irow, int icol) {
            return icol == 0 && irow != 0;
        }

        @Override
        public void setValueAt(Object newValue, int irow, int icol) {
            if (icol == 0 && irow != 0) {
                this.dsmeta_.setIncluded(this.dsmeta_.params_[irow], Boolean.TRUE.equals(newValue));
            }
        }

        public void setDatasetMeta(DatasetMeta dsmeta) {
            this.dsmeta_ = dsmeta;
            this.setItems(dsmeta == null ? new HapiParam[]{} : dsmeta.params_);
        }

        private static ArrayTableColumn<HapiParam, String> createStringColumn(String name, final Function<HapiParam, String> func) {
            return new ArrayTableColumn<HapiParam, String>(name, String.class){

                @Override
                public String getValue(HapiParam param) {
                    return (String)func.apply(param);
                }
            };
        }
    }

    private static class DatasetMeta {
        private final HapiInfo info_;
        private final HapiParam[] params_;
        private final Set<String> excluded_;

        DatasetMeta(HapiInfo info) {
            this.info_ = info;
            this.params_ = info.getParameters();
            this.excluded_ = new HashSet<String>();
        }

        void setIncluded(HapiParam param, boolean isIncluded) {
            if (isIncluded) {
                this.excluded_.remove(param.getName());
            } else {
                this.excluded_.add(param.getName());
            }
        }

        void setAllIncluded(boolean isIncluded) {
            if (isIncluded) {
                this.excluded_.clear();
            } else {
                for (int i = 1; i < this.params_.length; ++i) {
                    this.excluded_.add(this.params_[i].getName());
                }
            }
        }

        boolean isIncluded(HapiParam param) {
            return !this.excluded_.contains(param.getName());
        }

        boolean isAllIncluded() {
            return this.excluded_.isEmpty();
        }
    }
}

