/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import adql.parser.ADQLParser;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.TapCapability;

public enum AdqlVersion {
    V20("2.0", "2.0", new Ivoid("ivo://ivoa.net/std/ADQL#v2.0"), ADQLParser.ADQLVersion.V2_0, new String[]{"features-udf", "features-adqlgeo"}),
    V21("2.1", "2.1", new Ivoid("ivo://ivoa.net/std/ADQL#v2.1"), ADQLParser.ADQLVersion.V2_1, new String[]{"features-udf", "features-adqlgeo", "features-adql-common-table", "features-adql-conditional", "features-adql-offset", "features-adql-sets", "features-adql-string", "features-adql-type", "features-adql-unit"});

    private final String name_;
    private final String number_;
    private final Ivoid ivoid_;
    private final ADQLParser.ADQLVersion volltVersion_;
    private final Ivoid[] featureUris_;

    private AdqlVersion(String name, String number, Ivoid ivoid, ADQLParser.ADQLVersion volltVersion, String[] tapregextFeatureFragments) {
        this.name_ = name;
        this.number_ = number;
        this.ivoid_ = ivoid;
        this.volltVersion_ = volltVersion;
        int nfeat = tapregextFeatureFragments.length;
        this.featureUris_ = new Ivoid[nfeat];
        for (int ifeat = 0; ifeat < nfeat; ++ifeat) {
            this.featureUris_[ifeat] = TapCapability.createTapRegExtIvoid(tapregextFeatureFragments[ifeat]);
        }
    }

    public String getName() {
        return this.name_;
    }

    public String getNumber() {
        return this.number_;
    }

    public Ivoid getIvoid() {
        return this.ivoid_;
    }

    public Ivoid[] getFeatureUris() {
        return (Ivoid[])this.featureUris_.clone();
    }

    ADQLParser.ADQLVersion getVolltVersion() {
        return this.volltVersion_;
    }

    public String toString() {
        return "V" + this.name_;
    }

    public static AdqlVersion byNumber(String number) {
        for (AdqlVersion v : AdqlVersion.values()) {
            if (!v.number_.equals(number)) continue;
            return v;
        }
        return null;
    }

    public static AdqlVersion byIvoid(Ivoid ivoid) {
        for (AdqlVersion v : AdqlVersion.values()) {
            if (!v.ivoid_.equalsIvoid(ivoid)) continue;
            return v;
        }
        return null;
    }
}

