/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.ConeSearch;
import uk.ac.starlink.vo.ConeVerbosity;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.SkyDalTableLoadDialog;
import uk.ac.starlink.vo.SkyPositionEntry;

public class ConeSearchDialog
extends SkyDalTableLoadDialog {
    private final ContentCoding coding_ = ContentCoding.GZIP;
    private DoubleValueField raField_;
    private DoubleValueField decField_;
    private DoubleValueField srField_;
    private JComboBox<ConeVerbosity> verbSelector_;
    private static final ValueInfo SR_INFO = new DefaultValueInfo("Radius", Double.class, "Search Radius");

    public ConeSearchDialog() {
        super("Cone Search", "Cone", "Obtain source catalogues using cone search web services", Capability.CONE, true, false);
        this.setIcon(ResourceIcon.TLD_CONE);
    }

    @Override
    protected Component createQueryComponent() {
        Component queryPanel = super.createQueryComponent();
        SkyPositionEntry skyEntry = this.getSkyEntry();
        this.raField_ = skyEntry.getRaDegreesField();
        this.decField_ = skyEntry.getDecDegreesField();
        this.srField_ = DoubleValueField.makeSizeDegreesField(SR_INFO);
        skyEntry.addField(this.srField_);
        Box verbLine = Box.createHorizontalBox();
        this.verbSelector_ = new JComboBox<ConeVerbosity>(ConeVerbosity.getOptions());
        this.verbSelector_.setSelectedIndex(1);
        assert (this.getVerbosity() == 2);
        verbLine.add(new JLabel("Verbosity: "));
        verbLine.add((Component)new ShrinkWrapper(this.verbSelector_));
        verbLine.add(Box.createHorizontalGlue());
        this.getControlBox().add(Box.createVerticalStrut(5));
        this.getControlBox().add(verbLine);
        return queryPanel;
    }

    public TableLoader createTableLoader() {
        String serviceUrl = this.getServiceUrl();
        this.checkUrl(serviceUrl);
        final ConeSearch coner = new ConeSearch(serviceUrl, this.coding_);
        final double ra = this.raField_.getValue();
        final double dec = this.decField_.getValue();
        final double sr = this.srField_.getValue();
        final int verb = this.getVerbosity();
        final ArrayList<DescribedValue> metadata = new ArrayList<DescribedValue>();
        metadata.addAll(Arrays.asList(this.raField_.getDescribedValue(), this.decField_.getDescribedValue(), this.srField_.getDescribedValue()));
        metadata.addAll(Arrays.asList(this.getResourceMetadata(serviceUrl)));
        final String summary = this.getQuerySummary(serviceUrl, sr);
        return new TableLoader(){

            public TableSequence loadTables(StarTableFactory factory) throws IOException {
                StarTable st = coner.performSearch(ra, dec, sr, verb, factory);
                st.getParameters().addAll(metadata);
                return Tables.singleTableSequence((StarTable)st);
            }

            public String getLabel() {
                return summary;
            }
        };
    }

    public int getVerbosity() {
        return this.verbSelector_.getItemAt(this.verbSelector_.getSelectedIndex()).getLevel();
    }

    public JComboBox<ConeVerbosity> getVerbositySelector() {
        return this.verbSelector_;
    }

    public double getSearchRadius() {
        try {
            return this.srField_.getValue();
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }
}

