/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import uk.ac.starlink.vo.AdqlVersion;

public class HintPanel
extends JPanel {
    private final Consumer<URL> urlHandler_;
    private final JEditorPane edPanel_;
    private final Map<AdqlVersion, HTMLDocument> docMap_;
    private final Supplier<HTMLDocument> docSupplier_;
    private AdqlVersion adqlVersion_;
    private String examplesUrl_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public HintPanel(final Consumer<URL> urlHandler) {
        super(new BorderLayout());
        this.urlHandler_ = urlHandler;
        this.docMap_ = new HashMap<AdqlVersion, HTMLDocument>();
        HTMLEditorKit edKit = new HTMLEditorKit();
        this.docSupplier_ = () -> (HTMLDocument)edKit.createDefaultDocument();
        this.edPanel_ = new JEditorPane();
        this.edPanel_.setEditorKit(edKit);
        this.edPanel_.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.edPanel_.setEditable(false);
        this.edPanel_.setOpaque(false);
        if (urlHandler != null) {
            this.edPanel_.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(evt.getEventType())) {
                        URL url = evt.getURL();
                        urlHandler.accept(url);
                    }
                }
            });
        }
        this.setAdqlVersion(AdqlVersion.V21);
        this.add((Component)this.edPanel_, "Center");
    }

    public void setAdqlVersion(AdqlVersion version) {
        if (this.adqlVersion_ != version && version != null) {
            this.adqlVersion_ = version;
            this.updateContent();
        }
    }

    public void setExamplesUrl(String url) {
        if (this.examplesUrl_ == null || !this.examplesUrl_.equals(url)) {
            this.examplesUrl_ = url;
            this.updateContent();
        }
    }

    private void updateContent() {
        Element exEl;
        HTMLDocument doc = this.docMap_.computeIfAbsent(this.adqlVersion_, v -> this.createHintsDocument((AdqlVersion)((Object)v)));
        if (this.edPanel_.getDocument() != doc) {
            this.edPanel_.setDocument(doc);
        }
        if ((exEl = doc.getElement("EXAMPLE_CONTENT")) != null) {
            StringBuffer sbuf = new StringBuffer();
            if (this.examplesUrl_ == null) {
                sbuf.append("This service has no ").append("<em>service-provided</em> examples");
            } else {
                sbuf.append("This service has data-specific examples:").append("<br></br>").append("you can see them in the ").append("<span id='menu'>Service Provided</span> ").append("Examples sub-menu, <br></br>").append("or <a href='").append(this.examplesUrl_).append("'>with explanation</a> in your browser.");
            }
            try {
                doc.setInnerHTML(exEl, sbuf.toString());
            }
            catch (IOException | BadLocationException e) {
                logger_.warning("Problem editing HTML");
            }
        }
        this.edPanel_.setCaretPosition(0);
    }

    private final HTMLDocument createHintsDocument(AdqlVersion adqlVersion) {
        String errMsg;
        URL docResource = HintPanel.getDocResource(adqlVersion);
        HTMLDocument doc = this.docSupplier_.get();
        if (docResource != null) {
            try {
                this.edPanel_.read(docResource.openStream(), (Object)doc);
                errMsg = null;
            }
            catch (IOException e) {
                errMsg = "Read error for " + docResource + " - " + e;
            }
        } else {
            errMsg = "No hints document for ADQL " + (Object)((Object)adqlVersion);
        }
        if (errMsg != null) {
            logger_.warning(errMsg);
            try {
                doc.insertString(0, errMsg, null);
            }
            catch (BadLocationException e) {
                logger_.warning("Can't even insert error into document: " + errMsg);
            }
        }
        return doc;
    }

    static final URL getDocResource(AdqlVersion adqlVersion) {
        String docName;
        switch (adqlVersion) {
            case V20: {
                docName = "adql_hints_v2.0.html";
                break;
            }
            case V21: {
                docName = "adql_hints_v2.1.html";
                break;
            }
            default: {
                assert (adqlVersion == null);
                return null;
            }
        }
        return HintPanel.class.getResource(docName);
    }
}

