/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.util.gui.RenderingComboBox;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.AndButton;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.RegistryProtocol;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryFactory;
import uk.ac.starlink.vo.RegistrySelector;
import uk.ac.starlink.vo.RegistrySelectorModel;
import uk.ac.starlink.vo.ResourceField;

public class KeywordServiceQueryFactory
implements RegistryQueryFactory {
    private final Capability capability_;
    private final JComponent queryPanel_;
    private final RegistrySelector regSelector_;
    private final JTextField keywordField_;
    private final AndButton andButton_;
    private final Map<ResourceField, JCheckBox> fieldSelMap_;

    public KeywordServiceQueryFactory(Capability capability) {
        ResourceField[] fields;
        this.capability_ = capability;
        this.regSelector_ = new RegistrySelector();
        RenderingComboBox<RegistrySelectorModel> protoSelector = new RenderingComboBox<RegistrySelectorModel>(){

            protected String getRendererText(RegistrySelectorModel item) {
                return item.getProtocol().getShortName();
            }
        };
        for (RegistryProtocol proto : Arrays.asList(RegistryProtocol.PROTOCOLS)) {
            protoSelector.addItem(new RegistrySelectorModel(proto));
        }
        protoSelector.addActionListener(new ActionListener((JComboBox)protoSelector){
            final /* synthetic */ JComboBox val$protoSelector;
            {
                this.val$protoSelector = jComboBox;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeywordServiceQueryFactory.this.regSelector_.setModel((RegistrySelectorModel)this.val$protoSelector.getSelectedItem());
            }
        });
        protoSelector.setToolTipText("Registry access protocol");
        protoSelector.setSelectedItem(protoSelector.getItemAt(0));
        Box urlLine = Box.createHorizontalBox();
        urlLine.add(this.regSelector_);
        urlLine.add(Box.createHorizontalStrut(5));
        urlLine.add((Component)new ShrinkWrapper((Component)protoSelector));
        this.queryPanel_ = new Box(1, (JComboBox)protoSelector){
            final /* synthetic */ JComboBox val$protoSelector;
            {
                this.val$protoSelector = jComboBox;
                super(x0);
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                KeywordServiceQueryFactory.this.regSelector_.setEnabled(enabled);
                this.val$protoSelector.setEnabled(enabled);
                KeywordServiceQueryFactory.this.keywordField_.setEnabled(enabled);
                KeywordServiceQueryFactory.this.andButton_.setEnabled(enabled);
                for (JCheckBox button : KeywordServiceQueryFactory.this.fieldSelMap_.values()) {
                    button.setEnabled(enabled);
                }
            }
        };
        this.queryPanel_.add(urlLine);
        this.queryPanel_.add(Box.createVerticalStrut(5));
        this.andButton_ = new AndButton(true);
        Box keywordLine = Box.createHorizontalBox();
        this.keywordField_ = new JTextField();
        this.keywordField_.setToolTipText("Space-separated list of keywords to match in resource title, description, IVORN, etc");
        keywordLine.add(new JLabel("Keywords: "));
        keywordLine.add(this.keywordField_);
        keywordLine.add(Box.createHorizontalStrut(5));
        keywordLine.add(this.andButton_);
        this.queryPanel_.add(keywordLine);
        this.fieldSelMap_ = new LinkedHashMap<ResourceField, JCheckBox>();
        Box matchLine = Box.createHorizontalBox();
        matchLine.add(new JLabel("Match Fields: "));
        for (ResourceField rf : fields = new ResourceField[]{ResourceField.SHORTNAME, ResourceField.TITLE, ResourceField.SUBJECTS, ResourceField.ID, ResourceField.PUBLISHER, ResourceField.DESCRIPTION}) {
            JCheckBox checkBox = new JCheckBox(rf.getLabel());
            checkBox.setSelected(rf != ResourceField.DESCRIPTION);
            checkBox.setToolTipText("Match keywords against VOResource \"" + rf.getXpath() + " field?");
            matchLine.add(Box.createHorizontalStrut(5));
            matchLine.add(checkBox);
            this.fieldSelMap_.put(rf, checkBox);
        }
        matchLine.add(Box.createHorizontalGlue());
        this.queryPanel_.add(matchLine);
    }

    @Override
    public RegistryQuery getQuery() throws MalformedURLException {
        boolean isAnd = this.andButton_.isAnd();
        String conjunction = isAnd ? "and" : "or";
        String keyText = this.keywordField_.getText();
        String[] keywords = keyText == null || keyText.trim().length() == 0 ? new String[]{} : keyText.trim().split("\\s+");
        ArrayList<ResourceField> rfList = new ArrayList<ResourceField>();
        for (ResourceField rf : this.fieldSelMap_.keySet()) {
            if (!this.fieldSelMap_.get(rf).isSelected()) continue;
            rfList.add(rf);
        }
        RegistryProtocol proto = this.regSelector_.getModel().getProtocol();
        ResourceField[] fields = rfList.toArray(new ResourceField[0]);
        return proto.createKeywordQuery(keywords, fields, !isAnd, this.capability_, this.getUrl());
    }

    @Override
    public RegistryQuery getIdListQuery(String[] ivoids) throws MalformedURLException {
        RegistryProtocol proto = this.regSelector_.getModel().getProtocol();
        return proto.createIdListQuery(ivoids, this.capability_, this.getUrl());
    }

    @Override
    public JComponent getComponent() {
        return this.queryPanel_;
    }

    @Override
    public void addEntryListener(ActionListener listener) {
        this.keywordField_.addActionListener(listener);
    }

    @Override
    public void removeEntryListener(ActionListener listener) {
        this.keywordField_.removeActionListener(listener);
    }

    @Override
    public RegistrySelector getRegistrySelector() {
        return this.regSelector_;
    }

    private URL getUrl() throws MalformedURLException {
        return URLUtils.newURL((String)this.regSelector_.getUrl());
    }
}

