/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class LinkedBlockingStack<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private Node<E> head;
    private int count;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();

    public LinkedBlockingStack() {
    }

    public LinkedBlockingStack(Collection<E> c) {
        this.addAll(c);
    }

    protected ReentrantLock getLock() {
        return this.lock;
    }

    private void insert(E o) {
        this.head = new Node<E>(o, this.head);
        ++this.count;
        this.cond.signal();
    }

    private E extract() {
        Object x = this.head.item;
        this.head = this.head.next;
        --this.count;
        return x;
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            this.insert(o);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void put(E o) {
        this.offer(o);
    }

    @Override
    public boolean offer(E o, long t, TimeUnit unit) {
        return this.offer(o);
    }

    @Override
    public E peek() {
        this.lock.lock();
        try {
            if (this.count == 0) {
                E e = null;
                return e;
            }
            Object e = this.head.item;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.count == 0) {
                this.cond.await();
            }
            E e = this.extract();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll() {
        this.lock.lock();
        try {
            if (this.count == 0) {
                E e = null;
                return e;
            }
            E e = this.extract();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll(long t, TimeUnit unit) throws InterruptedException {
        long ns = unit.toNanos(t);
        this.lock.lock();
        try {
            while (true) {
                if (this.count != 0) {
                    E e = this.extract();
                    return e;
                }
                if (ns <= 0L) {
                    E e = null;
                    return e;
                }
                ns = this.cond.awaitNanos(ns);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.lock.lock();
        try {
            Node<E> p = this.head;
            while (p != null) {
                if (o.equals(p.item)) {
                    boolean bl = true;
                    return bl;
                }
                p = p.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.lock();
        try {
            Node<E> trail = null;
            Node<E> p = this.head;
            while (p != null) {
                Node next = p.next;
                if (o.equals(p.item)) {
                    if (trail == null) {
                        this.head = next;
                    } else {
                        trail.next = next;
                    }
                    --this.count;
                    boolean bl = true;
                    return bl;
                }
                trail = p;
                p = next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.head = null;
            this.count = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        Node<E> p;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            p = this.head;
            this.head = null;
            this.count = 0;
        }
        finally {
            this.lock.unlock();
        }
        int n = 0;
        while (p != null) {
            Object x = p.item;
            c.add(x);
            ++n;
            p = p.next;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int max) {
        E x;
        int n;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < max && (x = this.poll()) != null; ++n) {
            c.add(x);
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    Node<E> getNext(Node<E> p) {
        this.lock.lock();
        try {
            Node node = p.next;
            return node;
        }
        finally {
            this.lock.unlock();
        }
    }

    Node<E> getHead() {
        this.lock.lock();
        try {
            Node<E> node = this.head;
            return node;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeNode(Node<E> x) {
        this.lock.lock();
        try {
            Node<E> trail = null;
            Node<E> p = this.head;
            while (p != null) {
                Node next = p.next;
                if (p == x) {
                    if (trail == null) {
                        this.head = next;
                    } else {
                        trail.next = next;
                    }
                    --this.count;
                    boolean bl = true;
                    return bl;
                }
                trail = p;
                p = next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    class Itr
    implements Iterator<E> {
        Node<E> last;
        Node<E> current;
        Node<E> next;

        Itr() {
            this.next = LinkedBlockingStack.this.getHead();
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return true;
            }
            this.current = this.next;
            if (this.current == null) {
                return false;
            }
            this.next = LinkedBlockingStack.this.getNext(this.next);
            return true;
        }

        @Override
        public E next() {
            if (this.current == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.current;
            this.current = null;
            return this.last.item;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedBlockingStack.this.removeNode(this.last);
        }
    }

    static class Node<E> {
        E item;
        Node<E> next;

        Node(E x, Node<E> n) {
            this.item = x;
            this.next = n;
        }
    }
}

