/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.BitSet;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.vo.CheckBoxMenu;

public class MetaColumnModel
extends DefaultTableColumnModel {
    private DefaultListModel<TableColumn> listModel;
    private ListSelectionModel visibleModel;
    private TableModel tableModel;
    private BitSet purgedColumns = new BitSet();

    public MetaColumnModel(TableColumnModel baseColumnModel, TableModel tableModel) {
        int ipos;
        this.tableModel = tableModel;
        for (ipos = 0; ipos < baseColumnModel.getColumnCount(); ++ipos) {
            super.addColumn(baseColumnModel.getColumn(ipos));
        }
        this.setColumnMargin(baseColumnModel.getColumnMargin());
        this.setSelectionModel(baseColumnModel.getSelectionModel());
        this.setColumnSelectionAllowed(baseColumnModel.getColumnSelectionAllowed());
        this.listModel = new DefaultListModel();
        for (ipos = 0; ipos < baseColumnModel.getColumnCount(); ++ipos) {
            this.listModel.addElement(baseColumnModel.getColumn(ipos));
        }
        this.visibleModel = new DefaultListSelectionModel();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (!this.isVisible(i)) continue;
            this.visibleModel.addSelectionInterval(i, i);
        }
        this.visibleModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MetaColumnModel.this.handleSelectionChange(evt);
            }
        });
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                MetaColumnModel.this.handleTableChange(evt);
            }
        });
    }

    public ListModel<TableColumn> getListModel() {
        return this.listModel;
    }

    public ListSelectionModel getVisibleModel() {
        return this.visibleModel;
    }

    private boolean isVisible(int i) {
        return this.tableColumns.contains(this.listModel.get(i));
    }

    @Override
    public void addColumn(TableColumn tcol) {
        super.addColumn(tcol);
        if (!this.listModel.contains(tcol)) {
            int insertPos = this.listModel.getSize();
            this.listModel.addElement(tcol);
            this.visibleModel.addSelectionInterval(insertPos, insertPos);
            this.purgedColumns.clear(insertPos);
        }
    }

    @Override
    public void removeColumn(TableColumn tcol) {
        super.removeColumn(tcol);
        int ipos = this.listModel.indexOf(tcol);
        if (ipos >= 0) {
            this.visibleModel.removeSelectionInterval(ipos, ipos);
            this.purgedColumns.clear(ipos);
        }
    }

    public void removeColumn(int ipos) {
        this.removeColumn(this.listModel.get(ipos));
    }

    public void purgeEmptyColumns() {
        int nrow = this.tableModel.getRowCount();
        for (int ipos = 0; ipos < this.listModel.getSize(); ++ipos) {
            TableColumn tcol = this.listModel.get(ipos);
            int modelIndex = tcol.getModelIndex();
            boolean stillBlank = true;
            for (int irow = 0; irow < nrow && stillBlank; ++irow) {
                Object val = this.tableModel.getValueAt(irow, modelIndex);
                stillBlank = stillBlank && (val == null || val.toString().trim().length() == 0);
            }
            if (!stillBlank) continue;
            this.removeColumn(tcol);
            this.purgedColumns.set(ipos);
        }
    }

    public JMenu makeCheckBoxMenu(String name) {
        CheckBoxMenu menu = new CheckBoxMenu(name);
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            TableColumn tcol = this.listModel.getElementAt(i);
            Object title = tcol.getHeaderValue();
            menu.addMenuItem(title == null ? null : title.toString());
        }
        menu.setSelectionModel(this.visibleModel);
        return menu;
    }

    private void handleSelectionChange(ListSelectionEvent evt) {
        for (int i = evt.getFirstIndex(); i <= evt.getLastIndex(); ++i) {
            int ipos;
            TableColumn tcol;
            if (!this.visibleModel.isSelectedIndex(i) && this.isVisible(i)) {
                tcol = this.listModel.get(i);
                this.removeColumn(tcol);
                continue;
            }
            if (!this.visibleModel.isSelectedIndex(i) || this.isVisible(i)) continue;
            tcol = this.listModel.get(i);
            this.addColumn(tcol);
            int colPos = this.listModel.indexOf(tcol);
            for (ipos = 0; ipos < this.getColumnCount() && this.listModel.indexOf(this.getColumn(ipos)) < colPos; ++ipos) {
            }
            int from = this.getColumnCount() - 1;
            if (ipos >= from || ipos < 0) continue;
            this.moveColumn(from, ipos);
        }
    }

    private void handleTableChange(TableModelEvent evt) {
        if (evt.getType() == -1) {
            return;
        }
        TableModel tableModel = (TableModel)evt.getSource();
        int first = Math.max(evt.getFirstRow(), 0);
        int last = Math.min(evt.getLastRow(), tableModel.getRowCount() - 1);
        for (int ipos = 0; ipos < this.listModel.size(); ++ipos) {
            if (!this.purgedColumns.get(ipos)) continue;
            for (int irow = first; irow <= last; ++irow) {
                TableColumn tcol = this.listModel.get(ipos);
                int modelIndex = tcol.getModelIndex();
                Object val = tableModel.getValueAt(irow, modelIndex);
                if (this.isVisible(ipos) || val == null || val.toString().trim().length() <= 0) continue;
                this.visibleModel.addSelectionInterval(ipos, ipos);
            }
        }
    }
}

