/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;

public abstract class MetaNameFixer {
    private final Map<String, String> origTableNames_ = new HashMap<String, String>();
    private final Map<String, String> origColumnNames_ = new HashMap<String, String>();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    public static MetaNameFixer NONE = new MetaNameFixer(){

        @Override
        public String getFixedTableName(String tname, SchemaMeta schema) {
            return tname;
        }

        @Override
        public String getFixedColumnName(String cname) {
            return cname;
        }

        @Override
        public void fixSchemas(SchemaMeta[] schemas) {
        }

        @Override
        public void fixTables(TableMeta[] tables, SchemaMeta schema) {
        }

        @Override
        public void fixColumns(ColumnMeta[] columns) {
        }
    };

    protected MetaNameFixer() {
    }

    public abstract String getFixedTableName(String var1, SchemaMeta var2);

    public abstract String getFixedColumnName(String var1);

    public void fixSchemas(SchemaMeta[] schemas) {
        FixCount fc0 = this.getCurrentFixCount();
        for (SchemaMeta schema : schemas) {
            TableMeta[] tables = schema.getTables();
            if (tables == null) continue;
            for (TableMeta table : tables) {
                this.checkTable(table, schema);
            }
        }
        this.reportFixes(fc0);
    }

    public void fixTables(TableMeta[] tables, SchemaMeta schema) {
        if (tables != null) {
            FixCount fc0 = this.getCurrentFixCount();
            for (TableMeta table : tables) {
                this.checkTable(table, schema);
            }
            this.reportFixes(fc0);
        }
    }

    public void fixColumns(ColumnMeta[] columns) {
        if (columns != null) {
            FixCount fc0 = this.getCurrentFixCount();
            for (ColumnMeta column : columns) {
                this.checkColumn(column);
            }
            this.reportFixes(fc0);
        }
    }

    public String getOriginalColumnName(ColumnMeta column) {
        String cname = column.getName();
        String origName = this.origColumnNames_.get(column.getName());
        return origName == null ? cname : origName;
    }

    public String getOriginalTableName(TableMeta table) {
        String tname = table.getName();
        String origName = this.origTableNames_.get(table.getName());
        return origName == null ? tname : origName;
    }

    private void checkTable(TableMeta table, SchemaMeta schema) {
        ColumnMeta[] columns;
        String fixedName;
        String tname = table.getName();
        if (tname != null && !tname.equals(fixedName = this.getFixedTableName(tname, schema))) {
            table.name_ = fixedName;
            if (this.origTableNames_.isEmpty()) {
                logger_.warning("Fixed at least one broken TAP table name (" + tname + " -> " + fixedName + ")");
            }
            this.origTableNames_.put(fixedName, tname);
        }
        if ((columns = table.getColumns()) != null) {
            for (ColumnMeta column : columns) {
                this.checkColumn(column);
            }
        }
    }

    private void checkColumn(ColumnMeta column) {
        String fixedName;
        String cname = column.getName();
        if (cname != null && !cname.equals(fixedName = this.getFixedColumnName(cname))) {
            column.name_ = fixedName;
            if (this.origColumnNames_.isEmpty()) {
                logger_.warning("Fixed at least one broken TAP column name (" + cname + " -> " + fixedName + ")");
            }
            this.origColumnNames_.put(fixedName, cname);
        }
    }

    private FixCount getCurrentFixCount() {
        return new FixCount(this.origTableNames_.size(), this.origColumnNames_.size());
    }

    private void reportFixes(FixCount fc0) {
        FixCount fc1 = this.getCurrentFixCount();
        int ntFix = fc1.nt_ - fc0.nt_;
        int ncFix = fc1.nc_ - fc0.nc_;
        StringBuffer sbuf = new StringBuffer();
        if (ntFix > 0) {
            sbuf.append(ntFix).append(" bad table names");
        }
        if (ncFix > 0) {
            if (sbuf.length() > 0) {
                sbuf.append(", ");
            }
            sbuf.append(ncFix).append(" bad column names");
        }
        if (sbuf.length() > 0) {
            logger_.config("Fixed " + sbuf);
        }
    }

    public static MetaNameFixer createDefaultFixer() {
        return MetaNameFixer.createAdqlFixer(AdqlSyntax.getInstance());
    }

    public static MetaNameFixer createAdqlFixer(final AdqlSyntax syntax) {
        return new MetaNameFixer(){

            @Override
            public String getFixedTableName(String tname, SchemaMeta schema) {
                String sprefix;
                if (syntax.isAdqlTableName(tname)) {
                    return tname;
                }
                String sname = schema.getName();
                if (sname != null && sname.length() > 0 && tname.startsWith(sprefix = sname + ".")) {
                    String tsub = tname.substring(sprefix.length());
                    return syntax.quoteIfNecessary(sname) + "." + syntax.quoteIfNecessary(tsub);
                }
                return syntax.quote(tname);
            }

            @Override
            public String getFixedColumnName(String cname) {
                return syntax.isAdqlColumnName(cname) ? cname : syntax.quote(cname);
            }
        };
    }

    private static class FixCount {
        final int nt_;
        final int nc_;

        FixCount(int nt, int nc) {
            this.nt_ = nt;
            this.nc_ = nc;
        }
    }
}

