/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.ResourceIcon;

public class MetaPanel
extends JPanel
implements Scrollable {
    private final JLabel logoLabel_;
    private Thread logoWorker_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public MetaPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.logoLabel_ = new JLabel();
        Box logoLine = Box.createHorizontalBox();
        logoLine.add(Box.createHorizontalGlue());
        logoLine.add(this.logoLabel_);
        this.add(logoLine);
    }

    public JTextComponent addLineField(String heading) {
        JTextField field = new JTextField();
        field.setEditable(false);
        field.setOpaque(false);
        field.setBorder(BorderFactory.createEmptyBorder());
        this.addHeadedComponent(heading, field);
        return field;
    }

    public JTextComponent addMultiLineField(String heading) {
        JTextArea field = new JTextArea();
        field.setLineWrap(true);
        field.setWrapStyleWord(true);
        field.setEditable(false);
        field.setOpaque(false);
        this.addHeadedComponent(heading, field);
        return field;
    }

    public JTextComponent addHtmlField(String heading) {
        JEditorPane field = new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width, Math.max(size.height, 15));
            }
        };
        field.setEditorKit(new HTMLEditorKit());
        field.putClientProperty("JEditorPane.honorDisplayProperties", true);
        field.setEditable(false);
        field.setOpaque(false);
        this.addHeadedComponent(heading, field);
        return field;
    }

    public JTextComponent addUrlField(String heading, final Consumer<URL> urlHandler) {
        final JTextField field = new JTextField(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        field.setEditable(false);
        field.setOpaque(false);
        field.setBorder(BorderFactory.createEmptyBorder());
        final AbstractAction linkAct = new AbstractAction(null){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String txt = field.getText();
                if (txt != null && txt.length() > 0 && urlHandler != null) {
                    try {
                        urlHandler.accept(URLUtils.newURL((String)txt));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        };
        linkAct.putValue("ShortDescription", "Open link in web browser");
        JButton linkButton = new JButton(linkAct);
        linkButton.setBorder(BorderFactory.createEmptyBorder());
        linkButton.setMargin(new Insets(0, 0, 0, 0));
        Box line = Box.createHorizontalBox();
        line.add(field);
        line.add(Box.createHorizontalStrut(5));
        line.add(linkButton);
        line.add(Box.createHorizontalGlue());
        this.addHeadedComponent(heading, line);
        if (urlHandler != null) {
            field.setForeground(new Color(238));
            field.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    linkAct.actionPerformed(null);
                }
            });
            field.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent evt) {
                    boolean hasUrl = false;
                    String txt = field.getText();
                    if (txt != null && txt.length() > 0) {
                        try {
                            URLUtils.newURL((String)txt);
                            hasUrl = true;
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    linkAct.putValue("SmallIcon", hasUrl ? ResourceIcon.EXTLINK : null);
                    linkAct.setEnabled(hasUrl);
                }
            });
        }
        return field;
    }

    public void addTextLine(String txt) {
        this.addHeadedComponent(txt, null);
    }

    public void setFieldText(JTextComponent field, String text) {
        JScrollPane scroller = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        final JScrollBar hbar = scroller == null ? null : scroller.getHorizontalScrollBar();
        final JScrollBar vbar = scroller == null ? null : scroller.getVerticalScrollBar();
        final int hpos = hbar == null ? -1 : hbar.getValue();
        final int vpos = vbar == null ? -1 : vbar.getValue();
        field.setText(text);
        field.setCaretPosition(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (hbar != null) {
                    hbar.setValue(hpos);
                }
                if (vbar != null) {
                    vbar.setValue(vpos);
                }
            }
        });
    }

    public void setLogo(Icon logoIcon) {
        this.logoLabel_.setIcon(logoIcon);
    }

    public void setLogoUrl(final URL iconUrl) {
        this.setLogo(null);
        if (iconUrl != null) {
            if (this.logoWorker_ != null) {
                this.logoWorker_.interrupt();
            }
            this.logoWorker_ = new Thread("ImageLoader"){

                @Override
                public void run() {
                    Icon icon;
                    final 7 worker = this;
                    try {
                        icon = MetaPanel.this.readLogoIcon(iconUrl);
                    }
                    catch (Throwable e) {
                        logger_.log(Level.INFO, "Logo load failed: " + e, e);
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (MetaPanel.this.logoWorker_ == worker) {
                                MetaPanel.this.setLogo(icon);
                                MetaPanel.this.logoWorker_ = null;
                            }
                        }
                    });
                }
            };
            this.logoWorker_.setDaemon(true);
            this.logoWorker_.start();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return super.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unit = this.getFontMetrics(this.getFont()).getHeight();
        int block = orientation == 1 ? visibleRect.height : visibleRect.width;
        return Math.max(block - unit, unit);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private void addHeadedComponent(String heading, JComponent comp) {
        Box headLine = Box.createHorizontalBox();
        headLine.add(new JLabel(heading + ":"));
        headLine.add(Box.createHorizontalGlue());
        this.add(headLine);
        if (comp != null) {
            comp.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            this.add(comp);
        }
    }

    public static String mapToHtml(Map<String, ?> map) {
        StringBuffer sbuf = new StringBuffer();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object valObj = entry.getValue();
            sbuf.append("<strong>").append(entry.getKey()).append(":").append("</strong>");
            if (valObj != null) {
                sbuf.append(" ").append(valObj.toString());
            }
            sbuf.append("<br />\n");
        }
        return sbuf.toString();
    }

    private Icon readLogoIcon(URL url) {
        if (url == null) {
            return null;
        }
        ImageIcon icon0 = new ImageIcon(url);
        int w = icon0.getIconWidth();
        int h = icon0.getIconHeight();
        int maxWidth = Math.max(this.getWidth(), 200);
        int maxHeight = 100;
        if (w <= maxWidth && h <= maxHeight) {
            return icon0;
        }
        double scale = Math.min((double)maxWidth * 1.0 / (double)w, (double)maxHeight * 1.0 / (double)h);
        return new ImageIcon(icon0.getImage().getScaledInstance((int)((double)w * scale), (int)((double)h * scale), 4));
    }
}

