/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.registry.RegistryQueryException;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.vo.CapabilityTableModel;
import uk.ac.starlink.vo.MetaColumnModel;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryFactory;
import uk.ac.starlink.vo.RegistryTable;

public class RegistryPanel
extends JPanel {
    private final Action submitQueryAction_;
    private final Action cancelQueryAction_;
    private final JScrollPane resScroller_;
    private final RegistryTable regTable_;
    private final JTable capTable_;
    private final CapabilityTableModel capTableModel_;
    private final RegistryQueryFactory queryFactory_;
    private final JComponent controlBox_;
    private final JLabel countLabel_;
    private final List<ActionListener> listenerList_;
    private Thread queryWorker_;
    private JComponent workingPanel_;
    private JComponent dataPanel_;
    private List<Object> activeItems_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public RegistryPanel(RegistryQueryFactory queryFactory, boolean showCapabilities) {
        super(new BorderLayout());
        this.queryFactory_ = queryFactory;
        this.activeItems_ = new ArrayList<Object>();
        this.cancelQueryAction_ = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegistryPanel.this.cancelQuery();
            }
        };
        this.submitQueryAction_ = new AbstractAction("Find Services"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegistryPanel.this.submitQuery();
            }
        };
        this.activeItems_.add(this.submitQueryAction_);
        this.queryFactory_.addEntryListener(this.submitQueryAction_);
        JComponent queryComponent = queryFactory.getComponent();
        this.controlBox_ = Box.createHorizontalBox();
        if (queryComponent != null) {
            Box qBox = Box.createVerticalBox();
            this.activeItems_.add(queryComponent);
            qBox.add(queryComponent);
            qBox.add(Box.createVerticalStrut(5));
            Box controlLine = Box.createHorizontalBox();
            controlLine.add(this.controlBox_);
            controlLine.add(Box.createHorizontalGlue());
            controlLine.add(new JButton(this.cancelQueryAction_));
            controlLine.add(Box.createHorizontalStrut(5));
            controlLine.add(new JButton(this.submitQueryAction_));
            qBox.add(controlLine);
            qBox.add(Box.createVerticalStrut(5));
            this.add((Component)qBox, "North");
        }
        this.resScroller_ = new JScrollPane();
        this.workingPanel_ = new JPanel(new BorderLayout());
        this.regTable_ = new RegistryTable();
        this.regTable_.setColumnSelectionAllowed(false);
        this.regTable_.setRowSelectionAllowed(true);
        this.dataPanel_ = this.regTable_;
        this.setWorking(null);
        this.capTableModel_ = new CapabilityTableModel();
        this.capTable_ = new JTable(this.capTableModel_);
        this.capTable_.setColumnSelectionAllowed(false);
        this.capTable_.setRowSelectionAllowed(true);
        ListSelectionModel regSelModel = this.regTable_.getSelectionModel();
        regSelModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RegResource[] resources = RegistryPanel.this.getSelectedResources();
                if (resources.length == 1) {
                    RegCapabilityInterface[] caps = RegistryPanel.this.getCapabilities(resources[0]);
                    RegistryPanel.this.capTableModel_.setCapabilities(caps);
                    if (caps.length > 0) {
                        RegistryPanel.this.capTable_.setRowSelectionInterval(0, 0);
                    }
                }
            }
        });
        this.listenerList_ = new ArrayList<ActionListener>();
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    RegistryPanel.this.fireAction();
                }
            }
        };
        AbstractAction invokeAction = new AbstractAction("invoke"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegistryPanel.this.fireAction();
            }
        };
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        for (JTable table : Arrays.asList(this.regTable_, this.capTable_)) {
            table.addMouseListener(mouseListener);
            table.getInputMap().put(enterKey, "invoke");
            table.getActionMap().put("invoke", invokeAction);
        }
        if (showCapabilities) {
            JSplitPane splitter = new JSplitPane(0);
            splitter.setTopComponent(this.resScroller_);
            splitter.setBottomComponent(new JScrollPane(this.capTable_));
            splitter.setResizeWeight(0.8);
            this.add((Component)splitter, "Center");
        } else {
            this.resScroller_.setBorder(BorderFactory.createEtchedBorder());
            this.add((Component)this.resScroller_, "Center");
        }
        Box countLine = Box.createHorizontalBox();
        this.countLabel_ = new JLabel();
        countLine.add(new JLabel("Resource Count: "));
        countLine.add(this.countLabel_);
        countLine.add(Box.createHorizontalGlue());
        this.add((Component)countLine, "South");
    }

    public void performAutoQuery(String workingMsg) {
        try {
            RegistryQuery query = this.queryFactory_.getQuery();
            if (query != null) {
                this.performQuery(query, workingMsg);
            } else {
                logger_.warning("No query to perform");
            }
        }
        catch (Exception e) {
            logger_.warning("Registry query failed: " + e);
        }
    }

    protected void gotData(RegResource[] resources) {
    }

    public RegResource[] getResources() {
        return this.regTable_.getData();
    }

    public RegCapabilityInterface[] getCapabilities(RegResource resource) {
        return resource.getCapabilities();
    }

    public RegResource[] getSelectedResources() {
        ListSelectionModel smodel = this.getResourceSelectionModel();
        ArrayList<RegResource> sres = new ArrayList<RegResource>();
        RegResource[] data = this.getResources();
        for (int i = smodel.getMinSelectionIndex(); i <= smodel.getMaxSelectionIndex(); ++i) {
            if (!smodel.isSelectedIndex(i)) continue;
            sres.add(data[i]);
        }
        return sres.toArray(new RegResource[0]);
    }

    public RegCapabilityInterface[] getSelectedCapabilities() {
        if (this.capTable_ == null) {
            RegResource[] resources = this.getSelectedResources();
            ArrayList<RegCapabilityInterface> capList = new ArrayList<RegCapabilityInterface>();
            if (resources != null) {
                for (int ir = 0; ir < resources.length; ++ir) {
                    RegCapabilityInterface[] caps = this.getCapabilities(resources[ir]);
                    if (caps == null) continue;
                    capList.addAll(Arrays.asList(caps));
                }
            }
            return capList.toArray(new RegCapabilityInterface[0]);
        }
        ListSelectionModel smodel = this.capTable_.getSelectionModel();
        RegCapabilityInterface[] allCaps = this.capTableModel_.getCapabilities();
        ArrayList<RegCapabilityInterface> capList = new ArrayList<RegCapabilityInterface>();
        for (int i = smodel.getMinSelectionIndex(); i <= smodel.getMaxSelectionIndex(); ++i) {
            if (!smodel.isSelectedIndex(i)) continue;
            capList.add(allCaps[i]);
        }
        return capList.toArray(new RegCapabilityInterface[0]);
    }

    public void submitQuery() {
        RegistryQuery query;
        try {
            query = this.queryFactory_.getQuery();
        }
        catch (Exception e) {
            ErrorDialog.showError((Component)this, (String)"Query Error", (Throwable)e);
            return;
        }
        if (query == null || query.getText() == null || query.getText().trim() == null) {
            JOptionPane.showMessageDialog(this, "No query selected", "No Query", 0);
        } else {
            this.performQuery(query, "Searching Registry");
        }
    }

    public void performQuery(final RegistryQuery query, String workingMessage) {
        final JProgressBar progBar = this.setWorking(workingMessage);
        progBar.setString("Found 0");
        this.countLabel_.setText(null);
        Thread worker = new Thread("Registry query"){
            List<RegResource> resourceList;
            String errmsg;
            Thread wk;
            {
                super(x0);
                this.resourceList = new ArrayList<RegResource>();
                this.wk = this;
            }

            @Override
            public void run() {
                Throwable error = null;
                try {
                    Iterator<RegResource> it = query.getQueryIterator();
                    while (it.hasNext() && !this.isInterrupted()) {
                        this.resourceList.add(it.next());
                        progBar.setString("Found " + this.resourceList.size());
                    }
                    logger_.info("Records found: " + this.resourceList.size());
                    if (this.resourceList.isEmpty()) {
                        this.errmsg = "No resources found for query";
                    }
                }
                catch (RegistryQueryException e) {
                    error = e;
                }
                catch (Throwable e) {
                    error = e;
                }
                final Throwable error1 = error;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progBar.setIndeterminate(false);
                        boolean visible = RegistryPanel.this.isShowing();
                        if (RegistryPanel.this.queryWorker_ == wk) {
                            String countTxt;
                            if (errmsg != null) {
                                if (visible) {
                                    JOptionPane.showMessageDialog(RegistryPanel.this, errmsg, "Query Failed", 0);
                                } else {
                                    logger_.warning("Registry query failed: " + errmsg);
                                }
                                countTxt = null;
                            } else if (error1 != null) {
                                if (visible) {
                                    ErrorDialog.showError((Component)RegistryPanel.this, (String)"Query Error", (Throwable)error1);
                                } else {
                                    logger_.warning("Registry query failed: " + error1);
                                }
                                countTxt = null;
                            } else {
                                RegResource[] resources = resourceList.toArray(new RegResource[0]);
                                RegistryPanel.this.regTable_.setData(resources);
                                countTxt = Integer.toString(resources.length);
                                RegistryPanel.this.gotData(resources);
                            }
                            RegistryPanel.this.countLabel_.setText(countTxt);
                            RegistryPanel.this.setWorking(null);
                        }
                    }
                });
            }
        };
        Thread oldWorker = this.queryWorker_;
        if (oldWorker != null) {
            oldWorker.interrupt();
        }
        this.queryWorker_ = worker;
        worker.start();
    }

    public void cancelQuery() {
        if (this.queryWorker_ != null) {
            this.queryWorker_.interrupt();
            this.queryWorker_ = null;
        }
        this.setWorking(null);
    }

    public ListSelectionModel getResourceSelectionModel() {
        return this.regTable_.getSelectionModel();
    }

    public ListSelectionModel getCapabilitySelectionModel() {
        return this.capTable_.getSelectionModel();
    }

    public void displayAdviceMessage(String[] lines) {
        Box linesBox = Box.createVerticalBox();
        linesBox.add(Box.createVerticalGlue());
        for (int i = 0; i < lines.length; ++i) {
            Box line = Box.createHorizontalBox();
            line.add(new JLabel(lines[i]));
            line.add(Box.createHorizontalGlue());
            linesBox.add(line);
        }
        linesBox.add(Box.createVerticalGlue());
        Box adviceBox = Box.createHorizontalBox();
        adviceBox.add(Box.createHorizontalGlue());
        adviceBox.add(linesBox);
        adviceBox.add(Box.createHorizontalGlue());
        this.resScroller_.setViewportView(adviceBox);
    }

    public Action getSubmitQueryAction() {
        return this.submitQueryAction_;
    }

    public JMenu makeColumnVisibilityMenu(String name) {
        return ((MetaColumnModel)this.regTable_.getColumnModel()).makeCheckBoxMenu(name);
    }

    public Action getRegistryUpdateAction() {
        return this.queryFactory_.getRegistrySelector().getRegistryUpdateAction();
    }

    public JComponent getControlBox() {
        return this.controlBox_;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList_.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList_.remove(listener);
    }

    protected void fireAction() {
        ActionEvent evt = new ActionEvent(this, 0, "invoke");
        for (ActionListener listener : this.listenerList_) {
            listener.actionPerformed(evt);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Object item : this.activeItems_) {
            if (item instanceof Action) {
                ((Action)item).setEnabled(enabled);
                continue;
            }
            if (item instanceof Component) {
                ((Component)item).setEnabled(enabled);
                continue;
            }
            assert (false);
        }
    }

    private JProgressBar setWorking(String message) {
        JProgressBar progBar;
        boolean working;
        boolean bl = working = message != null;
        if (!working) {
            this.resScroller_.setViewportView(this.dataPanel_);
            progBar = null;
        } else {
            this.regTable_.setData(new RegResource[0]);
            if (this.capTableModel_ != null) {
                this.capTableModel_.setCapabilities(new RegCapabilityInterface[0]);
            }
            Box msgLine = Box.createHorizontalBox();
            msgLine.add(Box.createHorizontalGlue());
            msgLine.add(new JLabel(message));
            msgLine.add(Box.createHorizontalGlue());
            Box progLine = Box.createHorizontalBox();
            progBar = new JProgressBar();
            progBar.setStringPainted(true);
            progBar.setIndeterminate(true);
            progLine.add(Box.createHorizontalGlue());
            progLine.add(progBar);
            progLine.add(Box.createHorizontalGlue());
            Box workBox = Box.createVerticalBox();
            workBox.add(Box.createVerticalGlue());
            workBox.add(msgLine);
            workBox.add(Box.createVerticalStrut(5));
            workBox.add(progLine);
            workBox.add(Box.createVerticalGlue());
            this.workingPanel_.removeAll();
            this.workingPanel_.add(workBox);
            this.resScroller_.setViewportView(this.workingPanel_);
        }
        this.setEnabled(!working);
        this.cancelQueryAction_.setEnabled(working);
        return progBar;
    }
}

