/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.GlotsServiceFinder;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.TapServiceFinder;
import uk.ac.starlink.vo.TapServices;

public class Regtap12ServiceFinder
implements TapServiceFinder {
    private final TapService regtapService_;
    private final ContentCoding coding_;
    private final AdqlSyntax syntax_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public Regtap12ServiceFinder() {
        this(TapServices.getRegTap12Service(), ContentCoding.GZIP);
    }

    public Regtap12ServiceFinder(TapService regtapService, ContentCoding coding) {
        this.regtapService_ = regtapService;
        this.coding_ = coding;
        this.syntax_ = AdqlSyntax.getInstance();
    }

    @Override
    public TapServiceFinder.Service[] readAllServices() throws IOException {
        CharSequence[] charSequenceArray = new String[6];
        String IVOID = "ivoid";
        charSequenceArray[0] = "ivoid";
        String NAME = "short_name";
        charSequenceArray[1] = "short_name";
        String TITLE = "res_title";
        charSequenceArray[2] = "res_title";
        String DESCRIP = "res_description";
        charSequenceArray[3] = "res_description";
        String URL2 = "access_url";
        charSequenceArray[4] = "access_url";
        String NTABLE = "ntable";
        charSequenceArray[5] = "ntable";
        CharSequence[] colNames = charSequenceArray;
        String adql = String.join((CharSequence)"\n", "SELECT " + String.join((CharSequence)", ", colNames), "FROM (", "   SELECT svcid AS ivoid, COUNT(*) AS ntable", "   FROM rr.tap_table", "   GROUP BY svcid", ") AS tt", "NATURAL JOIN rr.resource", "NATURAL JOIN rr.capability", "NATURAL JOIN rr.interface", "WHERE standard_id = 'ivo://ivoa.net/std/tap'", "  AND intf_type = 'vs:paramhttp'", "ORDER BY ntable DESC");
        Function<Object[], TapServiceFinder.Service> serviceReader = arg_0 -> this.lambda$readAllServices$0((String[])colNames, IVOID, NAME, TITLE, DESCRIP, URL2, NTABLE, arg_0);
        return this.readQuery(adql, serviceReader).toArray(new TapServiceFinder.Service[0]);
    }

    @Override
    public TapServiceFinder.Table[] readSelectedTables(TapServiceFinder.Constraint constraint) throws IOException {
        String[] words = constraint.getKeywords();
        boolean isAnd = constraint.isAndKeywords();
        ArrayList<TapServiceFinder.Target> tTargets = new ArrayList<TapServiceFinder.Target>();
        for (TapServiceFinder.Target targ2 : constraint.getTargets()) {
            if (targ2.isServiceMeta()) continue;
            assert (targ2.getRrTapTablesCol() != null);
            tTargets.add(targ2);
        }
        if (tTargets.size() == 0) {
            return new TapServiceFinder.Table[0];
        }
        CharSequence[] charSequenceArray = new String[3];
        String SERVICE_ID = "svcid";
        charSequenceArray[0] = "svcid";
        String NAME = "table_name";
        charSequenceArray[1] = "table_name";
        String DESCRIP = "table_description";
        charSequenceArray[2] = "table_description";
        CharSequence[] colNames = charSequenceArray;
        ArrayList<String> wheres = new ArrayList<String>();
        for (String word : words) {
            wheres.add(tTargets.stream().map(targ -> this.getAdqlTest(word, (TapServiceFinder.Target)((Object)targ))).collect(Collectors.joining(" OR ")));
        }
        boolean fixDuplicates = false;
        StringBuffer sbuf = new StringBuffer().append("SELECT ");
        if (fixDuplicates) {
            sbuf.append("DISTINCT ");
        }
        sbuf.append(String.join((CharSequence)", ", colNames)).append("\nFROM rr.tap_table");
        for (int iw = 0; iw < wheres.size(); ++iw) {
            sbuf.append("\n");
            if (iw == 0) {
                sbuf.append("WHERE");
            } else {
                sbuf.append(isAnd ? "  AND" : "   OR");
            }
            sbuf.append(" (").append((String)wheres.get(iw)).append(")");
        }
        String adql = sbuf.toString();
        Function<Object[], TapServiceFinder.Table> tableReader = arg_0 -> this.lambda$readSelectedTables$2((String[])colNames, SERVICE_ID, NAME, DESCRIP, arg_0);
        return this.readQuery(adql, tableReader).toArray(new TapServiceFinder.Table[0]);
    }

    private <T> List<T> readQuery(String adql, final Function<Object[], T> rowReader) throws IOException {
        logger_.info("RegTAP 1.2 query: " + adql.replaceAll("\\s+", " "));
        logger_.config("RegTAP 1.2 query:\n" + adql);
        TapQuery tq = new TapQuery(this.regtapService_, adql, null);
        final ArrayList resultList = new ArrayList();
        try {
            final int[] nrows = new int[1];
            boolean isTrunc = tq.executeSync(new TableSink(){

                public void acceptRow(Object[] row) {
                    nrows[0] = nrows[0] + 1;
                    Object result = rowReader.apply(row);
                    if (result != null) {
                        resultList.add(result);
                    }
                }

                public void acceptMetadata(StarTable meta) {
                }

                public void endRows() {
                }
            }, this.coding_);
            int nrow = nrows[0];
            if (isTrunc) {
                logger_.warning("Result truncated at " + nrow + " rows");
            } else {
                logger_.info("Received " + nrow + " rows");
            }
        }
        catch (SAXException e) {
            throw new IOException("Error parsing VOTable result: " + e, e);
        }
        return resultList;
    }

    private String getAdqlTest(String keyword, TapServiceFinder.Target target) {
        String colName = target.getRrTapTablesCol();
        if (target.isWords()) {
            return new StringBuffer().append("1=ivo_hasword(").append(colName).append(", ").append(this.syntax_.characterLiteral(keyword)).append(")").toString();
        }
        return new StringBuffer().append(colName).append(" ILIKE ").append(this.syntax_.characterLiteral("%" + keyword + "%")).toString();
    }

    private /* synthetic */ TapServiceFinder.Table lambda$readSelectedTables$2(String[] colNames, String SERVICE_ID, String NAME, String DESCRIP, Object[] row) {
        Map<String, String> valueMap = GlotsServiceFinder.toValueMap(colNames, row);
        final String serviceId = valueMap.get(SERVICE_ID);
        final String name = valueMap.get(NAME);
        final String descrip = valueMap.get(DESCRIP);
        return new TapServiceFinder.Table(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getDescription() {
                return descrip;
            }

            @Override
            public String getServiceId() {
                return serviceId;
            }
        };
    }

    private /* synthetic */ TapServiceFinder.Service lambda$readAllServices$0(String[] colNames, String IVOID, String NAME, String TITLE, String DESCRIP, String URL2, String NTABLE, Object[] row) {
        Map<String, String> valueMap = GlotsServiceFinder.toValueMap(colNames, row);
        final String id = valueMap.get(IVOID);
        final String name = valueMap.get(NAME);
        final String title = valueMap.get(TITLE);
        final String descrip = valueMap.get(DESCRIP);
        final String url = valueMap.get(URL2);
        String ntableStr = valueMap.get(NTABLE);
        int nt = -1;
        if (ntableStr != null && ntableStr.matches("[0-9]+")) {
            try {
                nt = Integer.parseInt(ntableStr);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        final int ntable = nt;
        return new TapServiceFinder.Service(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getTitle() {
                return title;
            }

            @Override
            public String getDescription() {
                return descrip;
            }

            @Override
            public String getServiceUrl() {
                return url;
            }

            @Override
            public int getTableCount() {
                return ntable;
            }
        };
    }
}

