/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.ResolverException;

public class ResolverInfo {
    private double raDegrees_;
    private double decDegrees_;
    public static final String SESAME_URL = "http://cdsweb.u-strasbg.fr/cgi-bin/nph-sesame/-ox2?";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    private ResolverInfo(Element resolverEl) throws ResolverException {
        ResolverInfo.checkTagname(resolverEl, "Resolver");
        this.raDegrees_ = Double.NaN;
        this.decDegrees_ = Double.NaN;
        for (Node node = resolverEl.getFirstChild(); node != null; node = node.getNextSibling()) {
            String tag = ResolverInfo.getTagname(node);
            if ("jradeg".equals(tag)) {
                this.raDegrees_ = ResolverInfo.getDoubleContent((Element)node);
                continue;
            }
            if (!"jdedeg".equals(tag)) continue;
            this.decDegrees_ = ResolverInfo.getDoubleContent((Element)node);
        }
        if (Double.isNaN(this.raDegrees_) || Double.isNaN(this.decDegrees_)) {
            throw new ResolverException("No position information");
        }
    }

    public double getRaDegrees() {
        return this.raDegrees_;
    }

    public double getDecDegrees() {
        return this.decDegrees_;
    }

    public static ResolverInfo resolve(String name) throws ResolverException {
        return ResolverInfo.resolve(name, SESAME_URL);
    }

    public static ResolverInfo resolve(String name, String resolverUrl) throws ResolverException {
        try {
            URL url = URLUtils.newURL((String)(resolverUrl + URLEncoder.encode(name, "UTF-8")));
            logger_.info(url.toString());
            Element el = new SourceReader().getElement((Source)new StreamSource(AuthManager.getInstance().openStream(url)));
            String tag = ResolverInfo.getTagname(el);
            if ("Sesame".equals(tag)) {
                return ResolverInfo.interpretSesame(el);
            }
            throw new ResolverException("Bad element type <" + tag + "> from Sesame");
        }
        catch (IOException e) {
            throw new ResolverException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new ResolverException(e.getMessage(), e);
        }
    }

    private static ResolverInfo interpretSesame(Element sesameEl) throws ResolverException {
        ResolverInfo.checkTagname(sesameEl, "Sesame");
        ResolverInfo.checkForErrors(sesameEl);
        for (Node node = sesameEl.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"Resolver".equals(ResolverInfo.getTagname(node))) continue;
            Element resolverEl = (Element)node;
            ResolverInfo.checkForErrors(resolverEl);
            return new ResolverInfo(resolverEl);
        }
        throw new ResolverException("Name not resolved");
    }

    private static void checkForErrors(Element el) throws ResolverException {
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"ERROR".equals(ResolverInfo.getTagname(node))) continue;
            throw new ResolverException(DOMUtils.getTextContent((Element)((Element)node)));
        }
    }

    private static void checkTagname(Node el, String tagname) {
        if (!tagname.equals(ResolverInfo.getTagname(el))) {
            throw new IllegalArgumentException("Node is not a <" + tagname + ">");
        }
    }

    private static String getTagname(Node node) {
        return node instanceof Element ? ((Element)node).getTagName() : null;
    }

    private static double getDoubleContent(Element el) {
        try {
            return Double.parseDouble(DOMUtils.getTextContent((Element)el));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    private static String getStringContent(Element el) {
        String s = DOMUtils.getTextContent((Element)el);
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return s.trim();
    }

    public static void main(String[] args) throws ResolverException {
        for (int i = 0; i < args.length; ++i) {
            String name = args[i];
            ResolverInfo info = ResolverInfo.resolve(name);
            System.out.println("\t" + name + ":\t" + (float)info.getRaDegrees() + ",\t" + (float)info.getDecDegrees());
        }
    }
}

