/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

public class SiaFormatOption {
    private final String v1Value_;
    private final String[] v2Values_;
    public static final SiaFormatOption ALL = new SiaFormatOption("ALL", new String[0]);
    public static final SiaFormatOption GRAPHIC = new SiaFormatOption("GRAPHIC", new String[]{"image/png", "image/jpeg", "image/gif"});
    public static final SiaFormatOption FITS = new SiaFormatOption("image/fits");
    public static final SiaFormatOption DATALINK = new SiaFormatOption("application/x-votable+xml;content=datalink");
    private static final SiaFormatOption[] OPTIONS = new SiaFormatOption[]{ALL, GRAPHIC, FITS, DATALINK};

    public SiaFormatOption(String value) {
        this(value, new String[]{value});
    }

    public SiaFormatOption(String v1Value, String[] v2Values) {
        this.v1Value_ = v1Value;
        this.v2Values_ = v2Values;
    }

    public String getSiav1Value() {
        return this.v1Value_;
    }

    public String[] getSiav2Values() {
        return (String[])this.v2Values_.clone();
    }

    public String toString() {
        return this.v1Value_;
    }

    public static SiaFormatOption[] getStandardOptions() {
        return (SiaFormatOption[])OPTIONS.clone();
    }

    public static SiaFormatOption fromObject(Object formatOrString) {
        if (formatOrString instanceof SiaFormatOption) {
            return (SiaFormatOption)formatOrString;
        }
        if (formatOrString instanceof String && ((String)formatOrString).trim().length() > 0) {
            String formatTxt = ((String)formatOrString).trim();
            for (SiaFormatOption opt : OPTIONS) {
                if (!opt.toString().equalsIgnoreCase(formatTxt)) continue;
                return opt;
            }
            return new SiaFormatOption(((String)formatOrString).trim());
        }
        return null;
    }
}

