/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.DalQuery;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.SiaFormatOption;

public enum SiaVersion {
    V10("1.0", 1, new Ivoid("ivo://ivoa.net/std/SIA"), "http://www.ivoa.net/Documents/SIA/20091116/", true){

        @Override
        public StarTable executeQuery(String serviceUrl, double ra, double dec, double size, SiaFormatOption format, StarTableFactory factory, ContentCoding coding) throws IOException {
            DalQuery query = new DalQuery(serviceUrl, "SIA", ra, dec, size, coding);
            if (format != null) {
                query.addArgument("FORMAT", format.getSiav1Value());
            }
            return query.execute(factory);
        }
    }
    ,
    V20("2.0", 2, new Ivoid("ivo://ivoa.net/std/SIA#query-2.0"), "http://www.ivoa.net/Documents/SIA/20151223/", false){

        @Override
        public StarTable executeQuery(String serviceUrl, double ra, double dec, double size, SiaFormatOption format, StarTableFactory factory, ContentCoding coding) throws IOException {
            CgiQuery query = new CgiQuery(serviceUrl);
            String posTxt = new StringBuffer().append("CIRCLE ").append(CgiQuery.formatDouble((double)ra)).append(" ").append(CgiQuery.formatDouble((double)dec)).append(" ").append(size >= 0.0 ? CgiQuery.formatDouble((double)(0.5 * size)) : "0").toString();
            query.addArgument("POS", posTxt);
            if (format != null) {
                for (String fmt : format.getSiav2Values()) {
                    query.addArgument("FORMAT", fmt);
                }
            }
            return DalQuery.executeQuery(query.toURL(), factory, coding);
        }
    };

    private final String number_;
    private final int majorVersion_;
    private final Ivoid standardId_;
    private final String docUrl_;
    private final boolean usesUcd1_;

    private SiaVersion(String number, int majorVersion, Ivoid standardId, String docUrl, boolean usesUcd1) {
        this.number_ = number;
        this.majorVersion_ = majorVersion;
        this.standardId_ = standardId;
        this.docUrl_ = docUrl;
        this.usesUcd1_ = usesUcd1;
    }

    public int getMajorVersion() {
        return this.majorVersion_;
    }

    public String getDocumentUrl() {
        return this.docUrl_;
    }

    public Ivoid getStandardId() {
        return this.standardId_;
    }

    public boolean usesUcd1() {
        return this.usesUcd1_;
    }

    public abstract StarTable executeQuery(String var1, double var2, double var4, double var6, SiaFormatOption var8, StarTableFactory var9, ContentCoding var10) throws IOException;

    public String toString() {
        return this.number_;
    }

    public static SiaVersion forInterface(RegCapabilityInterface intf) {
        Ivoid stdId = new Ivoid(intf.getStandardId());
        for (SiaVersion vers : SiaVersion.values()) {
            if (!vers.standardId_.equalsIvoid(stdId)) continue;
            return vers;
        }
        String versTxt = intf.getVersion();
        for (SiaVersion vers : SiaVersion.values()) {
            if (!vers.number_.equals(versTxt)) continue;
            return vers;
        }
        return V10;
    }
}

