/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.util.gui.ArrayTableColumn;
import uk.ac.starlink.util.gui.ArrayTableModel;
import uk.ac.starlink.util.gui.ArrayTableSorter;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.AdqlFeature;
import uk.ac.starlink.vo.AdqlVersion;
import uk.ac.starlink.vo.AndButton;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.FeatureTreeModel;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.HasContentIcon;
import uk.ac.starlink.vo.HintPanel;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.MaskTreeModel;
import uk.ac.starlink.vo.MetaPanel;
import uk.ac.starlink.vo.RegRole;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.ResultHandler;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapMetaOrder;
import uk.ac.starlink.vo.TapMetaReader;
import uk.ac.starlink.vo.TapMetaTreeModel;
import uk.ac.starlink.vo.TapServiceFinder;
import uk.ac.starlink.vo.TapServiceFinderPanel;
import uk.ac.starlink.vo.TapServiceKit;
import uk.ac.starlink.vo.TapTableLoadDialog;

public class TableSetPanel
extends JPanel {
    private final TapTableLoadDialog tld_;
    private final JTree tTree_;
    private final CountTableTreeCellRenderer renderer_;
    private final JTextField keywordField_;
    private final AndButton keyAndButt_;
    private final JCheckBox useNameButt_;
    private final JCheckBox useDescripButt_;
    private final JRadioButton sortAlphaButt_;
    private final JRadioButton sortServiceButt_;
    private final TreeSelectionModel selectionModel_;
    private final JTree featureTree_;
    private final FeatureTreeModel featureTreeModel_;
    private final JTable colTable_;
    private final JTable foreignTable_;
    private final ArrayTableModel<ColumnMeta> colTableModel_;
    private final ArrayTableModel<ForeignMeta> foreignTableModel_;
    private final ResourceMetaPanel servicePanel_;
    private final SchemaMetaPanel schemaPanel_;
    private final TableMetaPanel tablePanel_;
    private final HintPanel hintPanel_;
    private final JTabbedPane detailTabber_;
    private final JScrollPane treeScroller_;
    private final int itabService_;
    private final int itabFeature_;
    private final int itabSchema_;
    private final int itabTable_;
    private final int itabCol_;
    private final int itabForeign_;
    private final int itabHint_;
    private final JComponent treeContainer_;
    private TapServiceKit serviceKit_;
    private SchemaMeta[] schemas_;
    private ColumnMeta[] selectedColumns_;
    private TapMetaTreeModel treeModel_;
    private static final String featureTitle_ = "ADQL";
    private static final List<ColMetaColumn<?>> colMetaColumns_ = TableSetPanel.createColumnMetaColumns();
    public static final String TABLE_SELECTION_PROPERTY = "selectedTable";
    public static final String COLUMNS_SELECTION_PROPERTY = "selectedColumns";
    public static final String SCHEMAS_PROPERTY = "schemas";
    private static final int TREE_EXPAND_THRESHOLD = 100;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TableSetPanel(TapTableLoadDialog tld) {
        super(new BorderLayout());
        this.tld_ = tld;
        this.renderer_ = new CountTableTreeCellRenderer();
        this.tTree_ = new JTree();
        this.tTree_.setRootVisible(true);
        this.tTree_.setShowsRootHandles(false);
        this.tTree_.setExpandsSelectedPaths(true);
        this.tTree_.setCellRenderer(this.renderer_);
        this.selectionModel_ = this.tTree_.getSelectionModel();
        this.selectionModel_.setSelectionMode(1);
        this.selectionModel_.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TableSetPanel.this.updateForTableSelection();
                TableMeta oldSel = TapMetaTreeModel.getTable(evt.getOldLeadSelectionPath());
                TableMeta newSel = TapMetaTreeModel.getTable(evt.getNewLeadSelectionPath());
                assert (newSel == TableSetPanel.this.getSelectedTable());
                TableSetPanel.this.firePropertyChange(TableSetPanel.TABLE_SELECTION_PROPERTY, oldSel, newSel);
            }
        });
        this.keywordField_ = new JTextField();
        this.keywordField_.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                TableSetPanel.this.updateTree(false);
            }
        });
        this.keywordField_.setToolTipText("Enter one or more search terms to restrict the content of the metadata display tree");
        this.keyAndButt_ = new AndButton(false);
        this.keyAndButt_.setMargin(new Insets(0, 0, 0, 0));
        this.keyAndButt_.setToolTipText("Choose to match either all (And) or any (Or) of the entered search terms against table metadata");
        this.useNameButt_ = new JCheckBox("Name", true);
        this.useNameButt_.setToolTipText("Select to match search terms against table/schema names");
        this.useDescripButt_ = new JCheckBox("Descrip", false);
        this.useDescripButt_.setToolTipText("Select to match search terms against table/schema descriptions");
        ActionListener findParamListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!TableSetPanel.this.useNameButt_.isSelected() && !TableSetPanel.this.useDescripButt_.isSelected()) {
                    (evt.getSource() == TableSetPanel.this.useNameButt_ ? TableSetPanel.this.useDescripButt_ : TableSetPanel.this.useNameButt_).setSelected(true);
                }
                TableSetPanel.this.updateTree(false);
            }
        };
        this.keyAndButt_.addAndListener(findParamListener);
        this.useNameButt_.addActionListener(findParamListener);
        this.useDescripButt_.addActionListener(findParamListener);
        this.sortAlphaButt_ = new JRadioButton("Alphabetic");
        this.sortServiceButt_ = new JRadioButton("Service");
        ButtonGroup sortGrp = new ButtonGroup();
        sortGrp.add(this.sortAlphaButt_);
        sortGrp.add(this.sortServiceButt_);
        this.sortAlphaButt_.setToolTipText("Select for alphabetic ordering");
        this.sortServiceButt_.setToolTipText("Select for service-defined ordering");
        this.sortAlphaButt_.addActionListener(evt -> this.updateTreeOrder());
        this.sortServiceButt_.addActionListener(evt -> this.updateTreeOrder());
        this.sortServiceButt_.setSelected(true);
        this.colTableModel_ = new ArrayTableModel((Object[])new ColumnMeta[0]);
        this.colTableModel_.setColumns(colMetaColumns_);
        this.colTable_ = new JTable((TableModel)this.colTableModel_);
        StarJTable.configureDefaultRenderers((JTable)this.colTable_);
        this.colTable_.setColumnSelectionAllowed(false);
        new ArrayTableSorter(this.colTableModel_).install(this.colTable_.getTableHeader());
        ListSelectionModel colSelModel = this.colTable_.getSelectionModel();
        colSelModel.setSelectionMode(2);
        colSelModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TableSetPanel.this.columnSelectionChanged();
            }
        });
        this.selectedColumns_ = new ColumnMeta[0];
        this.foreignTableModel_ = new ArrayTableModel((Object[])new ForeignMeta[0]);
        this.foreignTableModel_.setColumns(TableSetPanel.createForeignMetaColumns());
        this.foreignTable_ = new JTable((TableModel)this.foreignTableModel_);
        StarJTable.configureDefaultRenderers((JTable)this.foreignTable_);
        this.foreignTable_.setColumnSelectionAllowed(false);
        this.foreignTable_.setRowSelectionAllowed(false);
        new ArrayTableSorter(this.foreignTableModel_).install(this.foreignTable_.getTableHeader());
        this.featureTree_ = new JTree();
        JScrollPane featureScroller = TableSetPanel.metaScroller(this.featureTree_);
        this.featureTreeModel_ = new FeatureTreeModel(featureScroller);
        this.featureTree_.setModel(this.featureTreeModel_);
        this.featureTree_.setRootVisible(false);
        this.featureTree_.setShowsRootHandles(true);
        this.featureTree_.setSelectionModel(null);
        this.featureTree_.setLargeModel(false);
        this.featureTree_.putClientProperty("JTree.lineStyle", "None");
        this.featureTree_.setCellRenderer(FeatureTreeModel.createRenderer());
        this.featureTree_.setRowHeight(0);
        this.featureTreeModel_.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent evt) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent evt) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent evt) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent evt) {
                TreePath path = evt.getTreePath();
                if (path.getPathCount() == 1) {
                    Object root = path.getLastPathComponent();
                    int nc = TableSetPanel.this.featureTreeModel_.getChildCount(root);
                    for (int i = 0; i < nc; ++i) {
                        Object child = TableSetPanel.this.featureTreeModel_.getChild(root, i);
                        TableSetPanel.this.featureTree_.expandPath(path.pathByAddingChild(child));
                    }
                }
            }
        });
        Consumer<URL> urlHandler = url -> tld.getUrlHandler().accept((URL)url);
        this.tablePanel_ = new TableMetaPanel();
        this.schemaPanel_ = new SchemaMetaPanel();
        this.servicePanel_ = new ResourceMetaPanel(urlHandler);
        this.hintPanel_ = new HintPanel(urlHandler);
        this.detailTabber_ = new JTabbedPane();
        int itab = 0;
        this.detailTabber_.addTab("Service", TableSetPanel.metaScroller(this.servicePanel_));
        this.itabService_ = itab++;
        this.detailTabber_.addTab(featureTitle_, featureScroller);
        this.itabFeature_ = itab++;
        this.detailTabber_.addTab("Schema", TableSetPanel.metaScroller(this.schemaPanel_));
        this.itabSchema_ = itab++;
        this.detailTabber_.addTab("Table", TableSetPanel.metaScroller(this.tablePanel_));
        this.itabTable_ = itab++;
        this.detailTabber_.addTab("Columns", new JScrollPane(this.colTable_));
        this.itabCol_ = itab++;
        this.detailTabber_.addTab("FKeys", new JScrollPane(this.foreignTable_));
        this.itabForeign_ = itab++;
        this.detailTabber_.addTab("Hints", new JScrollPane(this.hintPanel_));
        this.itabHint_ = itab++;
        this.detailTabber_.setSelectedIndex(this.itabCol_);
        Box findWordBox = Box.createHorizontalBox();
        findWordBox.add(this.keywordField_);
        findWordBox.add(Box.createHorizontalStrut(5));
        findWordBox.add(this.keyAndButt_);
        Box findFieldBox = Box.createHorizontalBox();
        this.useNameButt_.setMargin(new Insets(0, 0, 0, 0));
        this.useDescripButt_.setMargin(new Insets(0, 0, 0, 0));
        findFieldBox.add(this.useNameButt_);
        findFieldBox.add(this.useDescripButt_);
        GridBagLayout gridLayer = new GridBagLayout();
        JPanel findBox = new JPanel(gridLayer);
        GridBagConstraints gcons = new GridBagConstraints();
        gcons.gridx = 0;
        gcons.gridy = 0;
        gcons.anchor = 17;
        JLabel findLabel = new JLabel("Find: ");
        gridLayer.setConstraints(findLabel, gcons);
        findBox.add(findLabel);
        ++gcons.gridx;
        gcons.weightx = 1.0;
        gcons.fill = 2;
        gridLayer.setConstraints(findWordBox, gcons);
        findBox.add(findWordBox);
        ++gcons.gridy;
        gcons.fill = 0;
        gridLayer.setConstraints(findFieldBox, gcons);
        findBox.add(findFieldBox);
        Box sortBox = Box.createHorizontalBox();
        sortBox.add(new JLabel("Sort: "));
        sortBox.add(this.sortServiceButt_);
        sortBox.add(this.sortAlphaButt_);
        sortBox.add(Box.createHorizontalGlue());
        JPanel treePanel = new JPanel(new BorderLayout());
        this.treeContainer_ = new JPanel(new BorderLayout());
        this.treeScroller_ = new JScrollPane(this.tTree_);
        this.treeContainer_.add((Component)this.treeScroller_, "Center");
        treePanel.add((Component)this.treeContainer_, "Center");
        treePanel.add((Component)sortBox, "South");
        Box treeOptBox = Box.createVerticalBox();
        treeOptBox.add(findBox);
        treeOptBox.add(sortBox);
        treeOptBox.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        treePanel.add((Component)treeOptBox, "North");
        JSplitPane metaSplitter = new JSplitPane(1);
        metaSplitter.setBorder(BorderFactory.createEmptyBorder());
        JPanel detailPanel = new JPanel(new BorderLayout());
        detailPanel.add((Component)this.detailTabber_, "Center");
        detailPanel.add((Component)TableSetPanel.createHorizontalStrut(500), "South");
        metaSplitter.setLeftComponent(treePanel);
        metaSplitter.setRightComponent(detailPanel);
        this.add((Component)metaSplitter, "Center");
        this.setServiceKit(null);
        this.setCapability(null);
    }

    public void setServiceKit(final TapServiceKit serviceKit) {
        if (this.serviceKit_ != null && this.serviceKit_ != serviceKit) {
            this.serviceKit_.shutdown();
        }
        this.serviceKit_ = serviceKit;
        this.setSchemas(null);
        this.setResourceInfo(null);
        if (serviceKit == null) {
            this.servicePanel_.setId(null, null);
        } else {
            final String ivoid = serviceKit.getIvoid();
            this.servicePanel_.setId(serviceKit.getTapService().getIdentity(), ivoid);
            serviceKit.acquireResource(new ResultHandler<Map<String, String>>(){

                @Override
                public boolean isActive() {
                    return serviceKit == TableSetPanel.this.serviceKit_;
                }

                @Override
                public void showWaiting() {
                    logger_.info("Reading resource record for " + ivoid);
                }

                @Override
                public void showResult(Map<String, String> resourceMap) {
                    TableSetPanel.this.setResourceInfo(resourceMap);
                }

                @Override
                public void showError(IOException error) {
                    TableSetPanel.this.setResourceInfo(null);
                }
            });
            serviceKit.acquireRoles(new ResultHandler<RegRole[]>(){

                @Override
                public boolean isActive() {
                    return serviceKit == TableSetPanel.this.serviceKit_;
                }

                @Override
                public void showWaiting() {
                    logger_.info("Reading res_role records for " + ivoid);
                }

                @Override
                public void showResult(RegRole[] roles) {
                    TableSetPanel.this.setResourceRoles(roles);
                }

                @Override
                public void showError(IOException error) {
                    TableSetPanel.this.setResourceRoles(null);
                }
            });
            serviceKit.acquireSchemas(new ResultHandler<SchemaMeta[]>(){
                private JProgressBar progBar;

                @Override
                public boolean isActive() {
                    return serviceKit == TableSetPanel.this.serviceKit_;
                }

                @Override
                public void showWaiting() {
                    logger_.info("Reading up-front table metadata");
                    this.progBar = TableSetPanel.this.showFetchProgressBar();
                }

                @Override
                public void showResult(SchemaMeta[] result) {
                    this.stopProgress();
                    logger_.info("Read " + this.getMetaDescrip());
                    TableSetPanel.this.setSchemas(result);
                }

                @Override
                public void showError(IOException error) {
                    this.stopProgress();
                    logger_.log(Level.WARNING, "Error reading " + this.getMetaDescrip(), error);
                    TableSetPanel.this.showFetchFailure(error, serviceKit.getMetaReader());
                }

                private void stopProgress() {
                    if (this.progBar != null) {
                        this.progBar.setIndeterminate(false);
                        this.progBar.setValue(0);
                        this.progBar = null;
                    }
                }

                private String getMetaDescrip() {
                    TapMetaReader metaRdr = serviceKit.getMetaReader();
                    StringBuffer sbuf = new StringBuffer().append("up-front table metadata");
                    if (metaRdr != null) {
                        sbuf.append(" from ").append(metaRdr.getSource()).append(" using ").append(metaRdr.getMeans());
                    }
                    return sbuf.toString();
                }
            });
        }
    }

    public TapServiceKit getServiceKit() {
        return this.serviceKit_;
    }

    public SchemaMeta[] getSchemas() {
        return this.schemas_;
    }

    private void setSchemas(SchemaMeta[] schemas) {
        String countTxt;
        if (schemas != null) {
            this.checkSchemasPopulated(schemas);
        }
        SchemaMeta[] oldSchemas = this.schemas_;
        this.schemas_ = schemas;
        this.treeModel_ = new TapMetaTreeModel(this.schemas_ == null ? new SchemaMeta[]{} : this.schemas_, this.getTreeOrder());
        this.tTree_.setModel(new MaskTreeModel(this.treeModel_, true));
        this.updateTree(true);
        SwingUtilities.invokeLater(() -> this.highlightFinderSelection());
        if (schemas == null) {
            countTxt = "no metadata";
        } else {
            int nTable = 0;
            for (SchemaMeta schema : schemas) {
                nTable += schema.getTables().length;
            }
            countTxt = schemas.length + " schemas, " + nTable + " tables";
        }
        this.servicePanel_.setSize(countTxt);
        this.replaceTreeComponent(null);
        this.updateForTableSelection();
        this.firePropertyChange(SCHEMAS_PROPERTY, oldSchemas, schemas);
        this.repaint();
    }

    public void setCapability(TapCapability capability) {
        this.servicePanel_.setCapability(capability);
        this.featureTreeModel_.setCapability(capability);
        this.detailTabber_.setIconAt(this.itabFeature_, this.activeIcon(capability != null));
    }

    public void setHasExamples(boolean hasExamples) {
        URL exampleUrl = hasExamples && this.serviceKit_ != null ? this.serviceKit_.getTapService().getExamplesEndpoint() : null;
        String exurl = exampleUrl == null ? null : exampleUrl.toString();
        this.servicePanel_.setExamplesUrl(exurl);
        this.hintPanel_.setExamplesUrl(exurl);
    }

    public void setAdqlVersion(AdqlVersion version) {
        this.hintPanel_.setAdqlVersion(version == null ? AdqlVersion.V20 : version);
        this.featureTreeModel_.setAdqlVersion(version);
    }

    private void setResourceInfo(Map<String, String> map) {
        String rootName = null;
        if (map != null) {
            if (rootName == null || rootName.trim().length() == 0) {
                rootName = map.get("short_name");
            }
            if (rootName == null || rootName.trim().length() == 0) {
                rootName = map.get("res_title");
            }
        }
        this.renderer_.rootName_ = rootName;
        this.tTree_.repaint();
        this.servicePanel_.setResourceInfo(map == null ? new HashMap() : map);
        this.detailTabber_.setIconAt(this.itabService_, this.activeIcon(map != null));
    }

    private void setResourceRoles(RegRole[] roles) {
        this.servicePanel_.setResourceRoles(roles == null ? new RegRole[]{} : roles);
    }

    public void setAuthId(String authId) {
        this.servicePanel_.setAuthId(authId);
    }

    public void highlightFinderSelection() {
        TapServiceFinderPanel finderPanel = this.tld_ == null ? null : this.tld_.getFinderPanel();
        TapServiceFinder.Table selTable = finderPanel == null ? null : finderPanel.getSelectedTable();
        String tname = selTable == null ? null : selTable.getName();
        TreePath selPath = this.treeModel_.getPathForTableName(tname);
        this.selectionModel_.setSelectionPath(selPath);
        this.scrollTreeToPath(selPath);
    }

    private TapMetaOrder getTreeOrder() {
        return this.sortServiceButt_.isSelected() ? TapMetaOrder.INDEXED : TapMetaOrder.ALPHABETIC;
    }

    private void updateTreeOrder() {
        TapMetaOrder order = this.getTreeOrder();
        if (this.treeModel_ != null && this.treeModel_.getOrder() != order) {
            TreePath selPath = this.tTree_.getSelectionPath();
            ArrayList<TreePath> expandeds = new ArrayList<TreePath>();
            TreePath rootPath = new TreePath(this.treeModel_.getRoot());
            Enumeration<TreePath> exEn = this.tTree_.getExpandedDescendants(rootPath);
            while (exEn.hasMoreElements()) {
                expandeds.add(exEn.nextElement());
            }
            this.treeModel_.setOrder(order);
            for (TreePath exp : expandeds) {
                this.tTree_.expandPath(exp);
            }
            if (selPath != null) {
                this.tTree_.setSelectionPath(selPath);
                this.scrollTreeToPath(selPath);
            }
        }
    }

    private void scrollTreeToPath(TreePath path) {
        JScrollBar hbar = this.treeScroller_.getHorizontalScrollBar();
        JScrollBar vbar = this.treeScroller_.getVerticalScrollBar();
        if (path == null) {
            hbar.setValue(hbar.getMinimum());
            vbar.setValue(vbar.getMinimum());
        } else {
            int hscroll = hbar == null ? 0 : hbar.getValue();
            Rectangle pathBounds = this.tTree_.getPathBounds(path);
            if (pathBounds == null) {
                this.keywordField_.setText("");
                pathBounds = this.tTree_.getPathBounds(path);
            }
            assert (pathBounds != null);
            TreePath parentPath = path.getParentPath();
            if (parentPath != null) {
                this.tTree_.scrollPathToVisible(parentPath);
            }
            if (pathBounds != null) {
                Rectangle viewBounds = this.treeScroller_.getViewport().getViewRect();
                if (viewBounds.y > pathBounds.y || viewBounds.y + viewBounds.height < pathBounds.y + pathBounds.height) {
                    this.tTree_.scrollPathToVisible(path);
                }
            }
            if (hbar != null) {
                hbar.setValue(hscroll);
            }
        }
    }

    private JProgressBar showFetchProgressBar() {
        JProgressBar progBar = new JProgressBar();
        progBar.setIndeterminate(true);
        Box progLine = Box.createHorizontalBox();
        progLine.add(Box.createHorizontalGlue());
        progLine.add(progBar);
        progLine.add(Box.createHorizontalGlue());
        Box workBox = Box.createVerticalBox();
        workBox.add(Box.createVerticalGlue());
        workBox.add(this.createLabelLine("Fetching table metadata"));
        workBox.add(Box.createVerticalStrut(5));
        workBox.add(progLine);
        workBox.add(Box.createVerticalGlue());
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBackground(UIManager.getColor("Tree.background"));
        workPanel.setBorder(BorderFactory.createEtchedBorder());
        workPanel.add((Component)workBox, "Center");
        this.replaceTreeComponent(workPanel);
        return progBar;
    }

    private void showFetchFailure(Throwable error, TapMetaReader metaReader) {
        ArrayList<String> msgList = new ArrayList<String>();
        msgList.add("Error reading TAP service table metadata");
        if (metaReader != null) {
            msgList.add("Method: " + metaReader.getMeans());
            msgList.add("Source: " + metaReader.getSource());
        }
        String[] msgLines = msgList.toArray(new String[0]);
        ErrorDialog.showError((Component)this, (String)"Table Metadata Error", (Throwable)error, (String[])msgLines);
        Box errLine = Box.createHorizontalBox();
        errLine.setAlignmentX(0.0f);
        errLine.add(new JLabel("Error: "));
        String errtxt = error.getMessage();
        if (errtxt == null || errtxt.trim().length() == 0) {
            errtxt = error.toString();
        }
        JTextField errField = new JTextField(errtxt);
        errField.setEditable(false);
        errField.setBorder(BorderFactory.createEmptyBorder());
        errLine.add((Component)new ShrinkWrapper((Component)errField));
        Box linesBox = Box.createVerticalBox();
        linesBox.add(Box.createVerticalGlue());
        linesBox.add(this.createLabelLine("No table metadata"));
        linesBox.add(Box.createVerticalStrut(15));
        for (String line : msgLines) {
            linesBox.add(this.createLabelLine(line));
        }
        linesBox.add(Box.createVerticalStrut(15));
        linesBox.add(errLine);
        linesBox.add(Box.createVerticalGlue());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)linesBox, "Center");
        JScrollPane scroller = new JScrollPane(panel);
        this.replaceTreeComponent(scroller);
    }

    private JComponent createLabelLine(String text) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        return label;
    }

    public void replaceTreeComponent(JComponent content) {
        this.treeContainer_.removeAll();
        this.treeContainer_.add((Component)(content != null ? content : this.treeScroller_), "Center");
        this.treeContainer_.revalidate();
        this.treeContainer_.repaint();
    }

    private void checkSchemasPopulated(SchemaMeta[] schemas) {
        for (SchemaMeta smeta : schemas) {
            if (smeta.getTables() != null) continue;
            logger_.warning("Schema metadata object(s) not populated with tables, probably will cause trouble; use a different TapMetaReader?");
            return;
        }
    }

    public TableMeta getSelectedTable() {
        return TapMetaTreeModel.getTable(this.selectionModel_.getSelectionPath());
    }

    public ColumnMeta[] getSelectedColumns() {
        return this.selectedColumns_;
    }

    private void updateForTableSelection() {
        TreePath path = this.selectionModel_.getSelectionPath();
        final TableMeta table = TapMetaTreeModel.getTable(path);
        SchemaMeta schema = TapMetaTreeModel.getSchema(path);
        if (table == null || !this.serviceKit_.onColumns(table, new Runnable(){

            @Override
            public void run() {
                if (table == TableSetPanel.this.getSelectedTable()) {
                    ColumnMeta[] cols = table.getColumns();
                    TableSetPanel.this.displayColumns(table, cols);
                    TableSetPanel.this.tablePanel_.setColumns(cols);
                }
            }
        })) {
            this.displayColumns(table, new ColumnMeta[0]);
        }
        if (table == null || !this.serviceKit_.onForeignKeys(table, new Runnable(){

            @Override
            public void run() {
                if (table == TableSetPanel.this.getSelectedTable()) {
                    ForeignMeta[] fkeys = table.getForeignKeys();
                    TableSetPanel.this.displayForeignKeys(table, fkeys);
                    TableSetPanel.this.tablePanel_.setForeignKeys(fkeys);
                }
            }
        })) {
            this.displayForeignKeys(table, new ForeignMeta[0]);
        }
        this.schemaPanel_.setSchema(schema);
        this.detailTabber_.setIconAt(this.itabSchema_, this.activeIcon(schema != null));
        this.tablePanel_.setTable(table);
        this.detailTabber_.setIconAt(this.itabTable_, this.activeIcon(table != null));
    }

    private void columnSelectionChanged() {
        Object[] oldCols = this.selectedColumns_;
        LinkedHashSet<ColumnMeta> curSet = new LinkedHashSet<ColumnMeta>();
        ListSelectionModel selModel = this.colTable_.getSelectionModel();
        if (!selModel.isSelectionEmpty()) {
            ColumnMeta[] colmetas = (ColumnMeta[])this.colTableModel_.getItems();
            int imin = selModel.getMinSelectionIndex();
            int imax = selModel.getMaxSelectionIndex();
            for (int i = imin; i <= imax; ++i) {
                if (!selModel.isSelectedIndex(i)) continue;
                curSet.add(colmetas[i]);
            }
        }
        ArrayList<ColumnMeta> newList = new ArrayList<ColumnMeta>();
        for (ColumnMeta columnMeta : oldCols) {
            ColumnMeta oldCol = TableSetPanel.getNamedEntry(curSet, columnMeta.getName());
            if (oldCol == null) continue;
            newList.add(oldCol);
        }
        for (ColumnMeta col : curSet) {
            if (TableSetPanel.getNamedEntry(newList, col.getName()) != null) continue;
            newList.add(col);
        }
        assert (new HashSet(newList).equals(curSet));
        this.selectedColumns_ = newList.toArray(new ColumnMeta[0]);
        if (!Arrays.equals(this.selectedColumns_, oldCols)) {
            this.firePropertyChange(COLUMNS_SELECTION_PROPERTY, oldCols, this.selectedColumns_);
        }
    }

    private void displayColumns(TableMeta table, ColumnMeta[] cols) {
        String[] extras;
        assert (table == this.getSelectedTable());
        if (cols != null && cols.length > 0) {
            LinkedHashMap extrasMap = new LinkedHashMap();
            for (ColumnMeta col : cols) {
                for (Map.Entry<String, Object> entry : col.getExtras().entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (!extrasMap.containsKey(key)) {
                        extrasMap.put(key, new ArrayList());
                    }
                    ((List)extrasMap.get(key)).add(value);
                }
            }
            extras = extrasMap.keySet().toArray(new String[0]);
            ArrayList colList = new ArrayList();
            colList.addAll(colMetaColumns_);
            for (Map.Entry entry : extrasMap.entrySet()) {
                colList.add(ExtraColumn.createInstance((String)entry.getKey(), (List)entry.getValue()));
            }
            if (!new HashSet(this.colTableModel_.getColumns()).equals(new HashSet(colList))) {
                this.colTableModel_.setColumns(colList);
            }
        } else {
            extras = new String[]{};
        }
        this.tablePanel_.setColumnExtras(extras);
        this.colTableModel_.setItems((Object[])cols);
        this.detailTabber_.setIconAt(this.itabCol_, this.activeIcon(cols != null && cols.length > 0));
        if (table != null) {
            this.configureColumnWidths(this.colTable_);
        }
        this.columnSelectionChanged();
    }

    private void displayForeignKeys(TableMeta table, ForeignMeta[] fkeys) {
        assert (table == this.getSelectedTable());
        this.foreignTableModel_.setItems((Object[])fkeys);
        this.detailTabber_.setIconAt(this.itabForeign_, this.activeIcon(fkeys != null && fkeys.length > 0));
        if (table != null) {
            this.configureColumnWidths(this.foreignTable_);
        }
    }

    private void configureColumnWidths(final JTable jtable) {
        Runnable configer = new Runnable(){

            @Override
            public void run() {
                StarJTable.configureColumnWidths((JTable)jtable, (int)360, (int)9999);
            }
        };
        if (this.detailTabber_.getSize().width > 0) {
            configer.run();
        } else {
            SwingUtilities.invokeLater(configer);
        }
    }

    private void updateTree(boolean dataChanged) {
        TreePath[] newExpanded;
        WordMatchMask mask;
        TreeModel treeModel = this.tTree_.getModel();
        if (!(treeModel instanceof MaskTreeModel)) {
            return;
        }
        MaskTreeModel mModel = (MaskTreeModel)treeModel;
        String text = this.keywordField_.getText();
        if (text == null || text.trim().length() == 0) {
            mask = null;
        } else {
            String[] searchTerms = text.split("\\s+");
            assert (searchTerms.length > 0);
            boolean isAnd = this.keyAndButt_.isAnd();
            boolean useName = this.useNameButt_.isSelected();
            boolean useDescrip = this.useDescripButt_.isSelected();
            NodeStringer stringer = NodeStringer.createInstance(useName, useDescrip);
            mask = new WordMatchMask(searchTerms, stringer, isAnd);
        }
        Object root = mModel.getRoot();
        TreePath[] selections = this.tTree_.getSelectionPaths();
        ArrayList<TreePath> expandedList = new ArrayList<TreePath>();
        Enumeration<TreePath> tpEn = this.tTree_.getExpandedDescendants(new TreePath(root));
        while (tpEn.hasMoreElements()) {
            expandedList.add(tpEn.nextElement());
        }
        TreePath[] oldExpanded = expandedList.toArray(new TreePath[0]);
        int oldCount = mModel.getNodeCount();
        mModel.setMask(mask);
        int newCount = mModel.getNodeCount();
        int ne = 100;
        if ((dataChanged || oldCount > ne) && newCount < ne) {
            int nc = mModel.getChildCount(root);
            newExpanded = new TreePath[nc];
            for (int ic = 0; ic < nc; ++ic) {
                Object child = mModel.getChild(root, ic);
                newExpanded[ic] = new TreePath(new Object[]{root, child});
            }
        } else {
            newExpanded = dataChanged || oldCount < ne && newCount > ne ? new TreePath[]{} : oldExpanded;
        }
        for (TreePath expTp : newExpanded) {
            this.tTree_.expandPath(expTp);
        }
        if (mask != null && selections != null) {
            selections = TableSetPanel.sanitiseSelections(selections, mModel);
        }
        if (selections == null || selections.length == 0) {
            TreePath[] treePathArray;
            TreePath tp;
            TreePath tp0 = this.tTree_.getPathForRow(0);
            TreePath tp1 = this.tTree_.getPathForRow(1);
            TreePath treePath = tp = tp1 != null && tp0 != null && mModel.isLeaf(tp1.getLastPathComponent()) && !mModel.isLeaf(tp0.getLastPathComponent()) ? tp1 : tp0;
            if (tp != null) {
                TreePath[] treePathArray2 = new TreePath[1];
                treePathArray = treePathArray2;
                treePathArray2[0] = tp;
            } else {
                treePathArray = new TreePath[]{};
            }
            selections = treePathArray;
        }
        this.tTree_.setSelectionPaths(selections);
    }

    private static ColumnMeta getNamedEntry(Collection<ColumnMeta> list, String name) {
        if (name != null) {
            for (ColumnMeta c : list) {
                if (!name.equals(c.getName())) continue;
                return c;
            }
        }
        return null;
    }

    private static TreePath[] sanitiseSelections(TreePath[] selections, TreeModel model) {
        ArrayList<TreePath> okPaths = new ArrayList<TreePath>();
        Object root = model.getRoot();
        for (TreePath path : selections) {
            TreePath okPath;
            if (path.getPathComponent(0) != root) {
                assert (false);
                continue;
            }
            int nel = path.getPathCount();
            ArrayList<Object> els = new ArrayList<Object>(nel);
            els.add(root);
            for (int i = 1; i < nel; ++i) {
                Object pathEl = path.getPathComponent(i);
                if (model.getIndexOfChild(els.get(i - 1), pathEl) < 0) break;
                els.add(pathEl);
            }
            if ((okPath = new TreePath(els.toArray(new Object[0]))).getPathCount() <= 1 || okPaths.contains(okPath)) continue;
            okPaths.add(okPath);
        }
        return okPaths.toArray(new TreePath[0]);
    }

    private Icon activeIcon(boolean isActive) {
        return HasContentIcon.getIcon(isActive);
    }

    private static String arrayLength(Object[] array) {
        return array == null ? null : Integer.toString(array.length);
    }

    private static List<ColMetaColumn<?>> createColumnMetaColumns() {
        ArrayList list = new ArrayList();
        list.add(new ColMetaColumn<String>("Name", String.class){

            public String getValue(ColumnMeta col) {
                return col.getName();
            }
        });
        list.add(new ColMetaColumn<String>("Type", String.class){

            public String getValue(ColumnMeta col) {
                String asize;
                String datatype = col.getDataType();
                String arraysize = col.getArraysize();
                StringBuffer sbuf = new StringBuffer();
                if (datatype != null) {
                    sbuf.append(datatype);
                }
                if (arraysize != null && (asize = arraysize.trim()).length() > 0 && !asize.equals("1")) {
                    sbuf.append('(').append(asize).append(')');
                }
                return sbuf.toString();
            }
        });
        list.add(new ColMetaColumn<String>("Unit", String.class){

            public String getValue(ColumnMeta col) {
                return col.getUnit();
            }
        });
        list.add(new ColMetaColumn<Boolean>("Indexed", Boolean.class){

            public Boolean getValue(ColumnMeta col) {
                return Arrays.asList(col.getFlags()).indexOf("indexed") >= 0;
            }
        });
        list.add(new ColMetaColumn<String>("Description", String.class){

            public String getValue(ColumnMeta col) {
                return col.getDescription();
            }
        });
        list.add(new ColMetaColumn<String>("UCD", String.class){

            public String getValue(ColumnMeta col) {
                return col.getUcd();
            }
        });
        list.add(new ColMetaColumn<String>("Utype", String.class){

            public String getValue(ColumnMeta col) {
                return col.getUtype();
            }
        });
        list.add(new ColMetaColumn<String>("Xtype", String.class){

            public String getValue(ColumnMeta col) {
                return col.getXtype();
            }
        });
        list.add(new ColMetaColumn<String>("Flags", String.class){

            public String getValue(ColumnMeta col) {
                String[] flags = col.getFlags();
                if (flags != null && flags.length > 0) {
                    StringBuffer sbuf = new StringBuffer();
                    for (int i = 0; i < flags.length; ++i) {
                        if (i > 0) {
                            sbuf.append(' ');
                        }
                        sbuf.append(flags[i]);
                    }
                    return sbuf.toString();
                }
                return null;
            }
        });
        return list;
    }

    private static List<ForeignMetaColumn> createForeignMetaColumns() {
        ArrayList<ForeignMetaColumn> list = new ArrayList<ForeignMetaColumn>();
        list.add(new ForeignMetaColumn("Target Table"){

            public String getValue(ForeignMeta fm) {
                return fm.getTargetTable();
            }
        });
        list.add(new ForeignMetaColumn("Links"){

            public String getValue(ForeignMeta fm) {
                ForeignMeta.Link[] links = fm.getLinks();
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < links.length; ++i) {
                    ForeignMeta.Link link = links[i];
                    if (i > 0) {
                        sbuf.append("; ");
                    }
                    sbuf.append(link.getFrom()).append("->").append(link.getTarget());
                }
                return sbuf.toString();
            }
        });
        list.add(new ForeignMetaColumn("Description"){

            public String getValue(ForeignMeta fm) {
                return fm.getDescription();
            }
        });
        list.add(new ForeignMetaColumn("Utype"){

            public String getValue(ForeignMeta fm) {
                return fm.getUtype();
            }
        });
        return list;
    }

    private static JScrollPane metaScroller(JComponent panel) {
        return new JScrollPane(panel, 20, 31);
    }

    private static JComponent createHorizontalStrut(int width) {
        JPanel c = new JPanel();
        c.setPreferredSize(new Dimension(width, 0));
        return c;
    }

    private static class ResourceMetaPanel
    extends MetaPanel {
        private final JTextComponent ivoidField_;
        private final JTextComponent servurlField_;
        private final JTextComponent authField_;
        private final JTextComponent nameField_ = this.addLineField("Short Name");
        private final JTextComponent titleField_ = this.addLineField("Title");
        private final JTextComponent refurlField_;
        private final JTextComponent examplesurlField_;
        private final JTextComponent sizeField_;
        private final JTextComponent publisherField_;
        private final JTextComponent creatorField_;
        private final JTextComponent contactField_;
        private final JTextComponent descripField_;
        private final JTextComponent dmField_;
        private final JTextComponent geoField_;
        private final JTextComponent adql21Field_;
        private final JTextComponent nonstdField_;

        ResourceMetaPanel(Consumer<URL> urlHandler) {
            this.ivoidField_ = this.addLineField("IVO ID");
            this.servurlField_ = this.addLineField("Service URL");
            this.authField_ = this.addLineField("Authentication");
            this.refurlField_ = this.addUrlField("Reference URL", urlHandler);
            this.examplesurlField_ = this.addUrlField("Examples URL", urlHandler);
            this.sizeField_ = this.addLineField("Size");
            this.publisherField_ = this.addMultiLineField("Publisher");
            this.creatorField_ = this.addMultiLineField("Creator");
            this.contactField_ = this.addMultiLineField("Contact");
            this.descripField_ = this.addMultiLineField("Description");
            this.dmField_ = this.addMultiLineField("Data Models");
            String star = " [*]";
            this.geoField_ = this.addMultiLineField("Geometry Functions" + star);
            this.adql21Field_ = this.addMultiLineField("ADQL 2.1 Optional Features" + star);
            this.nonstdField_ = this.addMultiLineField("Non-Standard Language Features" + star);
            this.addTextLine("<html></html>");
            this.addTextLine("<html>" + star + " <em>see " + TableSetPanel.featureTitle_ + " tab for details</em></html>");
        }

        public void setId(String serviceLabel, String ivoid) {
            this.setFieldText(this.servurlField_, serviceLabel);
            this.setFieldText(this.ivoidField_, ivoid);
        }

        public void setSize(String sizeTxt) {
            this.setFieldText(this.sizeField_, sizeTxt);
        }

        public void setResourceInfo(Map<String, String> info) {
            this.setFieldText(this.nameField_, info.remove("short_name"));
            this.setFieldText(this.titleField_, info.remove("res_title"));
            this.setFieldText(this.refurlField_, info.remove("reference_url"));
            this.setFieldText(this.descripField_, info.remove("res_description"));
        }

        public void setResourceRoles(RegRole[] roles) {
            this.setFieldText(this.publisherField_, ResourceMetaPanel.getRoleText(roles, "publisher"));
            this.setFieldText(this.creatorField_, ResourceMetaPanel.getRoleText(roles, "creator"));
            this.setFieldText(this.contactField_, ResourceMetaPanel.getRoleText(roles, "contact"));
            this.setLogoUrl(ResourceMetaPanel.getLogoUrl(roles));
        }

        public void setExamplesUrl(String examplesUrl) {
            this.setFieldText(this.examplesurlField_, examplesUrl);
        }

        public void setCapability(TapCapability tcap) {
            this.setFieldText(this.dmField_, ResourceMetaPanel.getDataModelText(tcap));
            this.setFieldText(this.geoField_, ResourceMetaPanel.getFeatureFormsText(tcap, AdqlFeature.ADQLGEO_FILTER));
            this.setFieldText(this.adql21Field_, ResourceMetaPanel.getFeatureFormsText(tcap, AdqlFeature.ADQL21MISC_FILTER));
            this.setFieldText(this.nonstdField_, ResourceMetaPanel.getFeatureFormsText(tcap, AdqlFeature.NONSTD_FILTER));
        }

        public void setAuthId(String authId) {
            this.setFieldText(this.authField_, authId);
        }

        private static String getDataModelText(TapCapability tcap) {
            if (tcap == null) {
                return null;
            }
            Ivoid[] dms = tcap.getDataModels();
            if (dms == null || dms.length == 0) {
                return null;
            }
            StringBuffer sbuf = new StringBuffer();
            if (dms != null) {
                for (Ivoid dm : dms) {
                    if (sbuf.length() != 0) {
                        sbuf.append('\n');
                    }
                    sbuf.append(dm);
                }
            }
            return sbuf.toString();
        }

        private static String getFeatureFormsText(TapCapability tcap, Predicate<Ivoid> featTypeFilter) {
            return Arrays.stream(tcap == null ? new TapLanguage[]{} : tcap.getLanguages()).flatMap(lang -> lang.getFeaturesMap().entrySet().stream()).filter(entry -> featTypeFilter.test((Ivoid)entry.getKey())).flatMap(entry -> Arrays.stream((Object[])entry.getValue())).map(feature -> feature.getForm()).collect(Collectors.joining(", "));
        }

        private static String getRoleText(RegRole[] roles, String baseRole) {
            StringBuffer sbuf = new StringBuffer();
            for (RegRole role : roles) {
                boolean hasEmail;
                String name = role.getName();
                String email = role.getEmail();
                boolean hasName = name != null && name.trim().length() > 0;
                boolean bl = hasEmail = email != null && email.trim().length() > 0;
                if (!baseRole.equalsIgnoreCase(role.getBaseRole()) || !hasName && !hasEmail) continue;
                if (sbuf.length() > 0) {
                    sbuf.append('\n');
                }
                if (hasName) {
                    sbuf.append(name.trim());
                }
                if (hasName && hasEmail) {
                    sbuf.append(' ');
                }
                if (!hasEmail) continue;
                sbuf.append('<').append(email.trim()).append('>');
            }
            return sbuf.toString();
        }

        private static URL getLogoUrl(RegRole[] roles) {
            for (RegRole role : roles) {
                String logo = role.getLogo();
                if (logo == null || logo.trim().length() <= 0) continue;
                try {
                    return URLUtils.newURL((String)logo);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class SchemaMetaPanel
    extends MetaPanel {
        private final JTextComponent nameField_ = this.addLineField("Name");
        private final JTextComponent ntableField_ = this.addLineField("Tables");
        private final JTextComponent descripField_ = this.addMultiLineField("Description");
        private SchemaMeta schema_;

        SchemaMetaPanel() {
        }

        public void setSchema(SchemaMeta schema) {
            if (schema != this.schema_) {
                this.schema_ = schema;
                this.setFieldText(this.nameField_, schema == null ? null : schema.getName());
                this.setFieldText(this.descripField_, schema == null ? null : schema.getDescription());
                Object[] tables = schema == null ? null : schema.getTables();
                this.setFieldText(this.ntableField_, TableSetPanel.arrayLength(tables));
            }
        }
    }

    private static class TableMetaPanel
    extends MetaPanel {
        private final JTextComponent nameField_ = this.addLineField("Name");
        private final JTextComponent ncolField_ = this.addLineField("Columns");
        private final JTextComponent nrowField_ = this.addLineField("Rows (approx)");
        private final JTextComponent nfkField_ = this.addLineField("Foreign Keys");
        private final JTextComponent descripField_ = this.addMultiLineField("Description");
        private final JTextComponent tableExtrasField_ = this.addHtmlField("Non-Standard Table Metadata");
        private final JTextComponent colExtrasField_ = this.addHtmlField("Non-Standard Column Metadata");
        private TableMeta table_;

        TableMetaPanel() {
        }

        public void setTable(TableMeta table) {
            if (table != this.table_) {
                this.table_ = table;
                this.setFieldText(this.nameField_, table == null ? null : table.getName());
                this.setFieldText(this.descripField_, table == null ? null : table.getDescription());
                this.setFieldText(this.nrowField_, table == null ? null : table.getNrows());
                this.setFieldText(this.tableExtrasField_, table == null ? null : TableMetaPanel.mapToHtml(table.getExtras()));
                this.setColumns(table == null ? null : table.getColumns());
                this.setForeignKeys(table == null ? null : table.getForeignKeys());
            }
        }

        public void setColumns(ColumnMeta[] cols) {
            this.setFieldText(this.ncolField_, TableSetPanel.arrayLength(cols));
        }

        public void setColumnExtras(String[] extras) {
            StringBuffer sbuf = new StringBuffer();
            if (extras != null) {
                for (String extra : extras) {
                    sbuf.append(extra).append("<br />\n");
                }
            }
            this.setFieldText(this.colExtrasField_, sbuf.toString());
        }

        public void setForeignKeys(ForeignMeta[] fkeys) {
            this.setFieldText(this.nfkField_, TableSetPanel.arrayLength(fkeys));
        }
    }

    private static class ExtraColumn<C>
    extends ColMetaColumn<C> {
        private final String key_;
        private final Class<C> clazz_;

        ExtraColumn(String key, Class<C> clazz) {
            super(key, clazz);
            this.key_ = key;
            this.clazz_ = clazz;
        }

        public C getValue(ColumnMeta col) {
            Object value = col.getExtras().get(this.key_);
            return this.clazz_.isInstance(value) ? (C)this.clazz_.cast(value) : null;
        }

        public int hashCode() {
            int code = 772261;
            code = 23 * code + this.key_.hashCode();
            code = 23 * code + this.clazz_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof ExtraColumn) {
                ExtraColumn other = (ExtraColumn)((Object)o);
                return this.key_.equals(other.key_) && this.clazz_.equals(other.clazz_);
            }
            return false;
        }

        static <C> ExtraColumn<C> createInstance(String key, Class<C> clazz) {
            return new ExtraColumn<C>(key, clazz);
        }

        static ExtraColumn<?> createInstance(String name, List<Object> values) {
            Class clazz = null;
            for (Object obj : values) {
                if (obj == null) continue;
                Class<?> c = obj.getClass();
                if (clazz == null) {
                    clazz = c;
                    continue;
                }
                if (clazz.equals(c)) continue;
                return new ExtraColumn<String>(name, String.class);
            }
            if (clazz == null) {
                clazz = Object.class;
            }
            return ExtraColumn.createInstance(name, clazz);
        }
    }

    private static abstract class ForeignMetaColumn
    extends ArrayTableColumn<ForeignMeta, String> {
        ForeignMetaColumn(String name) {
            super(name, String.class);
        }
    }

    private static abstract class ColMetaColumn<C>
    extends ArrayTableColumn<ColumnMeta, C> {
        ColMetaColumn(String name, Class<C> clazz) {
            super(name, clazz);
        }
    }

    private static class WordMatchMask
    implements MaskTreeModel.Mask {
        private final Set<String> lwords_;
        private final NodeStringer stringer_;
        private final boolean isAnd_;

        WordMatchMask(String[] words, NodeStringer stringer, boolean isAnd) {
            this.lwords_ = new HashSet<String>(words.length);
            for (String word : words) {
                this.lwords_.add(word.toLowerCase());
            }
            this.stringer_ = stringer;
            this.isAnd_ = isAnd;
        }

        @Override
        public boolean isIncluded(Object node) {
            for (String nodeTxt : this.stringer_.getStrings(node)) {
                if (nodeTxt == null) continue;
                String nodetxt = nodeTxt.toLowerCase();
                if (!(this.isAnd_ ? this.matchesAllWords(nodetxt) : this.matchesAnyWord(nodetxt))) continue;
                return true;
            }
            return false;
        }

        private boolean matchesAnyWord(String txt) {
            for (String lword : this.lwords_) {
                if (txt.indexOf(lword) < 0) continue;
                return true;
            }
            return false;
        }

        private boolean matchesAllWords(String txt) {
            for (String lword : this.lwords_) {
                if (txt.indexOf(lword) >= 0) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int code = 324223;
            code = 23 * code + this.lwords_.hashCode();
            code = 23 * code + this.stringer_.hashCode();
            code = 23 * code + (this.isAnd_ ? 11 : 17);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof WordMatchMask) {
                WordMatchMask other = (WordMatchMask)o;
                return this.lwords_.equals(other.lwords_) && this.stringer_.equals(other.stringer_) && this.isAnd_ == other.isAnd_;
            }
            return false;
        }
    }

    private static abstract class NodeStringer {
        private final boolean useName_;
        private final boolean useDescription_;

        private NodeStringer(boolean useName, boolean useDescription) {
            this.useName_ = useName;
            this.useDescription_ = useDescription;
        }

        public abstract List<String> getStrings(Object var1);

        public int hashCode() {
            int code = 5523;
            code = 23 * code + (this.useName_ ? 11 : 13);
            code = 23 * code + (this.useDescription_ ? 23 : 29);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof NodeStringer) {
                NodeStringer other = (NodeStringer)o;
                return this.useName_ == other.useName_ && this.useDescription_ == other.useDescription_;
            }
            return false;
        }

        public static NodeStringer createInstance(final boolean useName, final boolean useDescrip) {
            if (useName && !useDescrip) {
                final List<String> emptyList = Arrays.asList(new String[0]);
                return new NodeStringer(useName, useDescrip){

                    @Override
                    public List<String> getStrings(Object node) {
                        return node == null ? emptyList : Collections.singletonList(node.toString());
                    }
                };
            }
            return new NodeStringer(useName, useDescrip){

                @Override
                public List<String> getStrings(Object node) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (node != null) {
                        if (useName) {
                            list.add(node.toString());
                        }
                        if (useDescrip) {
                            String descrip = null;
                            if (node instanceof TableMeta) {
                                descrip = ((TableMeta)node).getDescription();
                            } else if (node instanceof SchemaMeta) {
                                descrip = ((SchemaMeta)node).getDescription();
                            }
                            if (descrip != null) {
                                list.add(descrip);
                            }
                        }
                    }
                    return list;
                }
            };
        }
    }

    private static class CountTableTreeCellRenderer
    extends DefaultTreeCellRenderer {
        String rootName_;

        private CountTableTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int irow, boolean hasFocus) {
            boolean hasMask;
            Component comp = super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, irow, hasFocus);
            if (value instanceof SchemaMeta[]) {
                SchemaMeta[] schemas = (SchemaMeta[])value;
                this.setIcon(ResourceIcon.NODE_SERVICE);
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(this.rootName_ == null ? "TAP Service" : this.rootName_);
                int ntTotal = 0;
                for (SchemaMeta schema : schemas) {
                    TableMeta[] tables = schema.getTables();
                    if (tables == null) continue;
                    ntTotal += tables.length;
                }
                sbuf.append(" (");
                TreeModel model = tree.getModel();
                boolean bl = hasMask = model instanceof MaskTreeModel && ((MaskTreeModel)model).getMask() != null;
                if (hasMask) {
                    int ntPresent = 0;
                    for (SchemaMeta schema : schemas) {
                        ntPresent += model.getChildCount(schema);
                    }
                    sbuf.append(ntPresent).append("/");
                }
                sbuf.append(ntTotal).append(")");
                this.setText(sbuf.toString());
            }
            if (value instanceof SchemaMeta) {
                TableMeta[] tables = ((SchemaMeta)value).getTables();
                if (tables != null) {
                    int ntTotal = tables.length;
                    TreeModel model = tree.getModel();
                    int ntPresent = model.isLeaf(value) ? -1 : model.getChildCount(value);
                    hasMask = model instanceof MaskTreeModel && ((MaskTreeModel)model).getMask() != null;
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append(this.getText()).append(" (");
                    if (hasMask) {
                        sbuf.append(ntPresent).append("/");
                    }
                    sbuf.append(ntTotal).append(")");
                    this.setText(sbuf.toString());
                }
            } else if (value instanceof TableMeta) {
                this.setIcon(ResourceIcon.NODE_TABLE);
            }
            return comp;
        }
    }
}

