/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.auth.UrlConnector;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;

public class TableSetSaxHandler
extends DefaultHandler {
    private SchemaMeta[] schemas_;
    private TableMeta[] nakedTables_;
    private List<SchemaMeta> schemaList_;
    private List<TableMeta> tableList_;
    private List<ColumnMeta> columnList_;
    private List<ForeignMeta> foreignList_;
    private List<ForeignMeta.Link> linkList_;
    private List<TableMeta> nakedTableList_;
    private List<String> flagList_;
    private SchemaMeta schema_;
    private TableMeta table_;
    private ColumnMeta column_;
    private ForeignMeta foreign_;
    private ForeignMeta.Link link_;
    private int iSchema_;
    private int iTable_;
    private final StringBuffer txtbuf_ = new StringBuffer();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public SchemaMeta[] getSchemas(boolean includeNaked) {
        if (this.schemas_ == null || !includeNaked || this.nakedTables_ == null || this.nakedTables_.length == 0) {
            return this.schemas_;
        }
        ArrayList<SchemaMeta> list = new ArrayList<SchemaMeta>(this.schemas_.length + 1);
        list.addAll(Arrays.asList(this.schemas_));
        int nNaked = this.nakedTables_.length;
        logger_.warning("Using " + nNaked + " tables declared outside of any schema");
        SchemaMeta dummySchema = SchemaMeta.createDummySchema("<no_schema>");
        dummySchema.setTables(this.nakedTables_);
        list.add(dummySchema);
        return list.toArray(new SchemaMeta[0]);
    }

    public TableMeta[] getNakedTables() {
        return this.nakedTables_;
    }

    @Override
    public void startDocument() {
        this.schemaList_ = new ArrayList<SchemaMeta>();
        this.nakedTableList_ = new ArrayList<TableMeta>();
        this.tableList_ = this.nakedTableList_;
    }

    @Override
    public void endDocument() {
        this.schemas_ = this.schemaList_.toArray(new SchemaMeta[0]);
        this.schemaList_ = null;
        this.nakedTables_ = this.nakedTableList_.toArray(new TableMeta[0]);
        this.nakedTableList_ = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        this.txtbuf_.setLength(0);
        String tname = this.getTagName(uri, localName, qName);
        if ("schema".equals(tname)) {
            this.schema_ = new SchemaMeta();
            this.schema_.index_ = ++this.iSchema_;
            this.tableList_ = new ArrayList<TableMeta>();
        } else if ("table".equals(tname)) {
            this.table_ = new TableMeta();
            this.table_.index_ = ++this.iTable_;
            String type = atts.getValue("", "type");
            if (type != null) {
                this.table_.type_ = type;
            }
            this.table_.extras_.putAll(TableSetSaxHandler.getAttMap(atts, new String[]{"type"}));
            this.columnList_ = new ArrayList<ColumnMeta>();
            this.foreignList_ = new ArrayList<ForeignMeta>();
        } else if ("column".equals(tname)) {
            this.column_ = new ColumnMeta();
            this.column_.extras_.putAll(TableSetSaxHandler.getAttMap(atts, new String[]{"std"}));
            this.flagList_ = new ArrayList<String>();
        } else if ("dataType".equals(tname)) {
            String xtype = atts.getValue("", "extendedType");
            String arraysize = atts.getValue("", "arraysize");
            String xschema = atts.getValue("", "extendedSchema");
            String delim = atts.getValue("", "delim");
            this.column_.xtype_ = xtype;
            this.column_.arraysize_ = arraysize;
        } else if ("foreignKey".equals(tname)) {
            this.foreign_ = new ForeignMeta();
            this.linkList_ = new ArrayList<ForeignMeta.Link>();
        } else if ("fkColumn".equals(tname)) {
            this.link_ = new ForeignMeta.Link();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String txt = this.txtbuf_.toString();
        this.txtbuf_.setLength(0);
        String tname = this.getTagName(uri, localName, qName);
        if ("fkColumn".equals(tname)) {
            assert (this.link_ != null);
            if (this.link_.from_ != null && this.link_.target_ != null) {
                this.linkList_.add(this.link_);
            } else {
                logger_.info("fkColumn lacks from and/or target column - ignored");
            }
            this.link_ = null;
        } else if ("foreignKey".equals(tname)) {
            assert (this.foreign_ != null);
            this.foreign_.links_ = this.linkList_.toArray(new ForeignMeta.Link[0]);
            this.linkList_ = null;
            if (this.foreignList_ != null) {
                this.foreignList_.add(this.foreign_);
            }
            this.foreign_ = null;
        } else if ("column".equals(tname)) {
            assert (this.column_ != null);
            this.column_.flags_ = this.flagList_.toArray(new String[0]);
            this.flagList_ = null;
            if (this.columnList_ != null) {
                this.columnList_.add(this.column_);
            }
            this.column_ = null;
        } else if ("table".equals(tname)) {
            assert (this.table_ != null);
            ColumnMeta[] cols = this.columnList_.toArray(new ColumnMeta[0]);
            TableSetSaxHandler.retypeExtras(cols);
            this.table_.setColumns(cols);
            this.columnList_ = null;
            this.table_.setForeignKeys(this.foreignList_.toArray(new ForeignMeta[0]));
            this.foreignList_ = null;
            if (this.tableList_ != null) {
                this.tableList_.add(this.table_);
            }
            this.table_ = null;
        } else if ("schema".equals(tname)) {
            assert (this.schema_ != null);
            this.schema_.setTables(this.tableList_.toArray(new TableMeta[0]));
            this.tableList_ = this.nakedTableList_;
            if (this.schemaList_ != null) {
                this.schemaList_.add(this.schema_);
            }
            this.schema_ = null;
        } else if (this.link_ != null) {
            if ("fromColumn".equals(tname)) {
                this.link_.from_ = txt;
            } else if ("targetColumn".equals(tname)) {
                this.link_.target_ = txt;
            }
        } else if (this.foreign_ != null) {
            if ("targetTable".equals(tname)) {
                this.foreign_.targetTable_ = txt;
            } else if ("description".equals(tname)) {
                this.foreign_.description_ = txt;
            } else if ("utype".equals(tname)) {
                this.foreign_.utype_ = txt;
            }
        } else if (this.column_ != null) {
            if ("name".equals(tname)) {
                this.column_.name_ = txt;
            } else if ("description".equals(tname)) {
                this.column_.description_ = txt;
            } else if ("unit".equals(tname)) {
                this.column_.unit_ = txt;
            } else if ("ucd".equals(tname)) {
                this.column_.ucd_ = txt;
            } else if ("utype".equals(tname)) {
                this.column_.utype_ = txt;
            } else if ("dataType".equals(tname)) {
                this.column_.dataType_ = txt;
            } else if ("flag".equals(tname)) {
                this.flagList_.add(txt);
            }
        } else if (this.table_ != null) {
            if ("name".equals(tname)) {
                this.table_.name_ = txt;
            } else if ("title".equals(tname)) {
                this.table_.title_ = txt;
            } else if ("description".equals(tname)) {
                this.table_.description_ = txt;
            } else if ("utype".equals(tname)) {
                this.table_.utype_ = txt;
            } else if ("nrows".equals(tname)) {
                this.table_.nrows_ = txt;
            }
        } else if (this.schema_ != null) {
            if ("name".equals(tname)) {
                this.schema_.name_ = txt;
            } else if ("title".equals(tname)) {
                this.schema_.title_ = txt;
            } else if ("description".equals(tname)) {
                this.schema_.description_ = txt;
            } else if ("utype".equals(tname)) {
                this.schema_.utype_ = txt;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.txtbuf_.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    private String getTagName(String uri, String localName, String qName) {
        return localName != null && localName.length() > 0 ? localName : qName.replaceFirst(".*:", "");
    }

    public static SchemaMeta[] readTableSet(URL url, ContentCoding coding) throws IOException, SAXException {
        TableSetSaxHandler handler = TableSetSaxHandler.populateHandler(url, coding);
        return handler.getSchemas(true);
    }

    public static TableMeta[] readTables(URL url, ContentCoding coding) throws IOException, SAXException {
        TableSetSaxHandler handler = TableSetSaxHandler.populateHandler(url, coding);
        ArrayList<TableMeta> tlist = new ArrayList<TableMeta>();
        for (SchemaMeta schema : handler.getSchemas(false)) {
            tlist.addAll(Arrays.asList(schema.getTables()));
        }
        tlist.addAll(Arrays.asList(handler.getNakedTables()));
        return tlist.toArray(new TableMeta[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableSetSaxHandler populateHandler(URL url, ContentCoding coding) throws IOException, SAXException {
        HttpURLConnection hconn;
        int code;
        SAXParser parser;
        SAXParserFactory spfact = SAXParserFactory.newInstance();
        try {
            spfact.setNamespaceAware(false);
            spfact.setValidating(false);
            parser = spfact.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("SAX trouble").initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("SAX trouble").initCause(e);
        }
        TableSetSaxHandler tsHandler = new TableSetSaxHandler();
        URLConnection conn = AuthManager.getInstance().connect(url, (UrlConnector)coding);
        if (conn instanceof HttpURLConnection && (code = (hconn = (HttpURLConnection)conn).getResponseCode()) != 200) {
            throw new IOException("Table resource access failure (" + code + " " + hconn.getResponseMessage() + ")");
        }
        try (BufferedInputStream in = new BufferedInputStream(coding.getInputStream(conn));){
            parser.parse((InputStream)in, (DefaultHandler)tsHandler);
            TableSetSaxHandler tableSetSaxHandler = tsHandler;
            return tableSetSaxHandler;
        }
    }

    private static Map<String, String> getAttMap(Attributes atts, String[] ignoreNames) {
        HashSet<String> ignores = new HashSet<String>(Arrays.asList(ignoreNames));
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int n = atts.getLength();
        for (int i = 0; i < n; ++i) {
            String name = atts.getQName(i).replaceFirst(".*:", "");
            if (ignores.contains(name)) continue;
            map.put(name, atts.getValue(i));
        }
        return map;
    }

    private static void retypeExtras(ColumnMeta[] cols) {
        String sval;
        HashMap<String, ArrayList<Converter>> convMap = new HashMap<String, ArrayList<Converter>>();
        List<Converter> allConvs = Arrays.asList(Converter.values());
        for (ColumnMeta col : cols) {
            for (Map.Entry<String, Object> extra : col.getExtras().entrySet()) {
                String key = extra.getKey();
                Object value = extra.getValue();
                if (!(value instanceof String) || "".equals(value)) continue;
                sval = (String)value;
                if (!convMap.containsKey(key)) {
                    convMap.put(key, new ArrayList<Converter>(allConvs));
                }
                Iterator it = ((List)convMap.get(key)).iterator();
                while (it.hasNext()) {
                    Converter conv = (Converter)((Object)it.next());
                    try {
                        conv.convert(sval);
                    }
                    catch (NumberFormatException e) {
                        it.remove();
                    }
                }
            }
        }
        for (ColumnMeta col : cols) {
            for (Map.Entry<String, Object> entry : col.getExtras().entrySet()) {
                List convs;
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                sval = (String)value;
                Object newValue = sval.length() == 0 ? null : ((convs = (List)convMap.get(entry.getKey())) != null && convs.size() > 0 ? ((Converter)((Object)convs.get(0))).convert(sval) : value);
                entry.setValue(newValue);
            }
        }
    }

    public static void main(String[] args) throws IOException, SAXException {
        PrintStream out = System.out;
        TableSetSaxHandler tsHandler = TableSetSaxHandler.populateHandler(URLUtils.newURL((String)args[0]), ContentCoding.GZIP);
        for (SchemaMeta schema : tsHandler.getSchemas(false)) {
            out.println(schema.getName());
            for (TableMeta table : schema.getTables()) {
                out.println("    " + table.getName());
                for (ColumnMeta col : table.getColumns()) {
                    out.println("        " + col.getName());
                }
            }
        }
        TableMeta[] nakedTables = tsHandler.getNakedTables();
        if (nakedTables.length > 0) {
            out.println("No schema: ");
            for (TableMeta table : nakedTables) {
                out.println("    " + table.getName());
                for (ColumnMeta col : table.getColumns()) {
                    out.println("        " + col.getName());
                }
            }
        }
    }

    private static enum Converter {
        LONG{

            @Override
            public Object convert(String txt) {
                return Long.valueOf(txt);
            }
        }
        ,
        INTEGER{

            @Override
            public Object convert(String txt) {
                return Integer.valueOf(txt);
            }
        }
        ,
        DOUBLE{

            @Override
            public Object convert(String txt) {
                return Double.valueOf(txt);
            }
        }
        ,
        STRING{

            @Override
            public Object convert(String txt) {
                return txt;
            }
        };


        abstract Object convert(String var1);
    }
}

