/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;

public enum TapMetaOrder {
    ALPHABETIC(TapMetaOrder.comparator1(SchemaMeta::getName), TapMetaOrder.comparator1(TableMeta::getName)),
    INDEXED(TapMetaOrder.comparator2(SchemaMeta::getIndex, SchemaMeta::getName), TapMetaOrder.comparator2(TableMeta::getIndex, TableMeta::getName));

    private final Comparator<SchemaMeta> schemaComparator_;
    private final Comparator<TableMeta> tableComparator_;

    private TapMetaOrder(Comparator<SchemaMeta> schemaComparator, Comparator<TableMeta> tableComparator) {
        this.schemaComparator_ = schemaComparator;
        this.tableComparator_ = tableComparator;
    }

    public void sortSchemas(SchemaMeta[] schemas) {
        Arrays.sort(schemas, this.schemaComparator_);
        for (SchemaMeta schema : schemas) {
            schema.setTableOrder(this.tableComparator_);
        }
    }

    private static <T, U extends Comparable<? super U>> Comparator<T> comparator1(Function<T, U> keyFunc) {
        return Comparator.comparing(keyFunc, Comparator.nullsLast(Comparator.naturalOrder()));
    }

    private static <T, U extends Comparable<? super U>, V extends Comparable<? super V>> Comparator<T> comparator2(Function<T, U> keyFunc1, Function<T, V> keyFunc2) {
        return TapMetaOrder.comparator1(keyFunc1).thenComparing(TapMetaOrder.comparator1(keyFunc2));
    }
}

