/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.TapServices;

public class TapSchemaInterrogator {
    private final TapService service_;
    private final Map<String, String> extraParams_;
    private final int maxrec_;
    private final ContentCoding coding_;
    private final Map<String, String[]> colsMap_;
    public static final MetaQuerier<ForeignMeta.Link> LINK_QUERIER = TapSchemaInterrogator.createLinkQuerier();
    public static final MetaQuerier<ForeignMeta> FKEY_QUERIER = TapSchemaInterrogator.createForeignKeyQuerier();
    public static final MetaQuerier<ColumnMeta> COLUMN_QUERIER = TapSchemaInterrogator.createColumnQuerier();
    public static final MetaQuerier<TableMeta> TABLE_QUERIER = TapSchemaInterrogator.createTableQuerier();
    public static final MetaQuerier<SchemaMeta> SCHEMA_QUERIER = TapSchemaInterrogator.createSchemaQuerier();
    private static final AdqlSyntax syntax_ = AdqlSyntax.getInstance();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TapSchemaInterrogator(TapService service, int maxrec, ContentCoding coding) {
        this.service_ = service;
        this.maxrec_ = maxrec;
        this.coding_ = coding;
        this.extraParams_ = new LinkedHashMap<String, String>();
        if (maxrec > 0) {
            this.extraParams_.put("MAXREC", Integer.toString(this.maxrec_));
        }
        this.colsMap_ = new HashMap<String, String[]>();
    }

    public TapService getTapService() {
        return this.service_;
    }

    public SchemaMeta[] queryMetadata() throws IOException {
        return this.readSchemas(true, true, true);
    }

    public SchemaMeta[] readSchemas(boolean populateSchemas, boolean populateTables, boolean addOrphanTables) throws IOException {
        List<SchemaMeta> sList = SCHEMA_QUERIER.readList(this, null);
        if (populateSchemas) {
            Map<String, List<TableMeta>> tMap = TABLE_QUERIER.readMap(this, null);
            if (populateTables) {
                Map<String, List<ForeignMeta.Link>> lMap = LINK_QUERIER.readMap(this, null);
                Map<String, List<ForeignMeta>> fMap = FKEY_QUERIER.readMap(this, null);
                Map<String, List<ColumnMeta>> cMap = COLUMN_QUERIER.readMap(this, null);
                for (List<ForeignMeta> list : fMap.values()) {
                    for (ForeignMeta foreignMeta : list) {
                        this.populateForeignKey(foreignMeta, lMap);
                    }
                }
                this.checkEmpty(lMap, "Links");
                for (List<Object> list : tMap.values()) {
                    for (TableMeta tableMeta : list) {
                        this.populateTable(tableMeta, fMap, cMap);
                    }
                }
                this.checkEmpty(fMap, "Foreign Keys");
                this.checkEmpty(cMap, "Columns");
            }
            for (SchemaMeta smeta : sList) {
                this.populateSchema(smeta, tMap);
            }
            if (!tMap.isEmpty() && addOrphanTables) {
                logger_.warning("Adding entries from phantom schemas: " + tMap.keySet());
                Iterator<Map.Entry<String, List<TableMeta>>> entryIt = tMap.entrySet().iterator();
                while (entryIt.hasNext()) {
                    Map.Entry<String, List<TableMeta>> entry = entryIt.next();
                    entryIt.remove();
                    String sname = entry.getKey();
                    List<TableMeta> tlist = entry.getValue();
                    assert (tlist != null);
                    SchemaMeta schemaMeta = SchemaMeta.createDummySchema(sname);
                    schemaMeta.setTables(tlist.toArray(new TableMeta[0]));
                    sList.add(schemaMeta);
                }
                assert (tMap.isEmpty());
            }
            this.checkEmpty(tMap, "Tables");
        }
        return sList.toArray(new SchemaMeta[0]);
    }

    public <T> Map<String, List<T>> readMap(MetaQuerier<T> mq, String moreAdql) throws IOException {
        return mq.readMap(this, moreAdql);
    }

    public <T> List<T> readList(MetaQuerier<T> mq, String moreAdql) throws IOException {
        return mq.readList(this, moreAdql);
    }

    public void populateForeignKey(ForeignMeta fmeta, Map<String, List<ForeignMeta.Link>> lMap) {
        List<ForeignMeta.Link> llist = lMap.remove(fmeta.getKeyId());
        ForeignMeta.Link[] l0 = new ForeignMeta.Link[]{};
        fmeta.setLinks(llist == null ? l0 : llist.toArray(l0));
    }

    public void populateTable(TableMeta tmeta, Map<String, List<ForeignMeta>> fMap, Map<String, List<ColumnMeta>> cMap) {
        String tname = tmeta.getName();
        List<ForeignMeta> flist = fMap.remove(tname);
        ForeignMeta[] f0 = new ForeignMeta[]{};
        tmeta.setForeignKeys(flist == null ? f0 : flist.toArray(f0));
        List<ColumnMeta> clist = cMap.remove(tname);
        ColumnMeta[] c0 = new ColumnMeta[]{};
        tmeta.setColumns(clist == null ? c0 : clist.toArray(c0));
    }

    public void populateSchema(SchemaMeta smeta, Map<String, List<TableMeta>> tMap) {
        List<TableMeta> tlist = tMap.remove(smeta.getName());
        TableMeta[] t0 = new TableMeta[]{};
        smeta.setTables(tlist == null ? t0 : tlist.toArray(t0));
    }

    protected TapQuery createTapQuery(String adql) {
        return new TapQuery(this.service_, adql, this.extraParams_);
    }

    protected StarTable executeQuery(TapQuery tq) throws IOException {
        return tq.executeSync(StoragePolicy.getDefaultPolicy(), this.coding_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAvailableColumns(String tableName) throws IOException {
        Map<String, String[]> map = this.colsMap_;
        synchronized (map) {
            if (!this.colsMap_.containsKey(tableName)) {
                this.colsMap_.put(tableName, this.readAvailableColumns(tableName));
            }
        }
        return this.colsMap_.get(tableName);
    }

    private String[] readAvailableColumns(String tableName) throws IOException {
        String adql = new StringBuffer().append("SELECT TOP 1 * FROM ").append(tableName).toString();
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("MAXREC", "1");
        StarTable table = this.executeQuery(new TapQuery(this.service_, adql, extraParams));
        ArrayList<String> list = new ArrayList<String>();
        int ncol = table.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            String name = table.getColumnInfo(icol).getName();
            if ("size".equals(syntax_.unquote(name).toLowerCase())) continue;
            list.add(name);
        }
        return list.toArray(new String[0]);
    }

    private <T> void checkEmpty(Map<String, List<T>> map, String objType) {
        int nEntry = map.size();
        if (nEntry > 0) {
            logger_.warning("Schema interrogation: " + nEntry + " orphaned " + objType + " entries");
            logger_.info("Orphaned " + objType + "s: " + map.keySet());
        }
    }

    private static String stringOrNull(Object obj) {
        return obj instanceof String ? (String)obj : null;
    }

    private static MetaQuerier<ForeignMeta.Link> createLinkQuerier() {
        String[] stringArray = new String[2];
        final String cFromColumn = "from_column";
        stringArray[0] = "from_column";
        final String cTargetColumn = "target_column";
        stringArray[1] = "target_column";
        String[] atts = stringArray;
        return new MetaQuerier<ForeignMeta.Link>("TAP_SCHEMA.key_columns", atts, true, "key_id", null, null){

            @Override
            public ForeignMeta.Link createMeta(ColSet colset, Object[] row) {
                ForeignMeta.Link link = new ForeignMeta.Link();
                link.from_ = colset.getCellString(cFromColumn, row);
                link.target_ = colset.getCellString(cTargetColumn, row);
                return link;
            }
        };
    }

    private static MetaQuerier<ForeignMeta> createForeignKeyQuerier() {
        String[] stringArray = new String[4];
        final String cKeyId = "key_id";
        stringArray[0] = "key_id";
        final String cTargetTable = "target_table";
        stringArray[1] = "target_table";
        final String cDescription = "description";
        stringArray[2] = "description";
        final String cUtype = "utype";
        stringArray[3] = "utype";
        String[] atts = stringArray;
        return new MetaQuerier<ForeignMeta>("TAP_SCHEMA.keys", atts, true, "from_table", null, null){

            @Override
            public ForeignMeta createMeta(ColSet colset, Object[] row) {
                ForeignMeta fmeta = new ForeignMeta();
                fmeta.keyId_ = colset.getCellString(cKeyId, row);
                fmeta.targetTable_ = colset.getCellString(cTargetTable, row);
                fmeta.description_ = colset.getCellString(cDescription, row);
                fmeta.utype_ = colset.getCellString(cUtype, row);
                return fmeta;
            }
        };
    }

    private static MetaQuerier<ColumnMeta> createColumnQuerier() {
        String[] stringArray = new String[9];
        final String cColumnName = "column_name";
        stringArray[0] = "column_name";
        final String cDescription = "description";
        stringArray[1] = "description";
        final String cUnit = "unit";
        stringArray[2] = "unit";
        final String cUcd = "ucd";
        stringArray[3] = "ucd";
        final String cUtype = "utype";
        stringArray[4] = "utype";
        final String cDatatype = "datatype";
        stringArray[5] = "datatype";
        String cIndexed = "indexed";
        stringArray[6] = "indexed";
        String cPrincipal = "principal";
        stringArray[7] = "principal";
        String cStd = "std";
        stringArray[8] = "std";
        String[] attCols = stringArray;
        String cColumnIndex = "column_index";
        String cArraysize = "arraysize";
        String cXtype = "xtype";
        final String[] flagAtts = new String[]{cIndexed, cPrincipal, cStd};
        return new MetaQuerier<ColumnMeta>("TAP_SCHEMA.columns", attCols, false, "table_name", "column_index", null){

            @Override
            public ColumnMeta createMeta(ColSet colset, Object[] row) {
                ColumnMeta cmeta = new ColumnMeta();
                cmeta.name_ = colset.getCellString(cColumnName, row);
                cmeta.description_ = colset.getCellString(cDescription, row);
                cmeta.unit_ = colset.getCellString(cUnit, row);
                cmeta.ucd_ = colset.getCellString(cUcd, row);
                cmeta.utype_ = colset.getCellString(cUtype, row);
                cmeta.dataType_ = colset.getCellString(cDatatype, row);
                ArrayList<String> flagList = new ArrayList<String>();
                for (String flagAtt : flagAtts) {
                    if (!colset.getCellBoolean(flagAtt, row)) continue;
                    flagList.add(flagAtt);
                }
                cmeta.flags_ = flagList.toArray(new String[0]);
                Map<String, Object> extras = colset.getExtras(row);
                extras.remove("column_index");
                cmeta.arraysize_ = TapSchemaInterrogator.stringOrNull(extras.remove("arraysize"));
                cmeta.xtype_ = TapSchemaInterrogator.stringOrNull(extras.remove("xtype"));
                cmeta.extras_ = extras;
                return cmeta;
            }
        };
    }

    private static MetaQuerier<TableMeta> createTableQuerier() {
        String[] stringArray = new String[4];
        final String cTableName = "table_name";
        stringArray[0] = "table_name";
        final String cTableType = "table_type";
        stringArray[1] = "table_type";
        final String cDescription = "description";
        stringArray[2] = "description";
        final String cUtype = "utype";
        stringArray[3] = "utype";
        String[] attCols = stringArray;
        String cNrows = "nrows";
        String cTableIndex = "table_index";
        String rankColName = null;
        return new MetaQuerier<TableMeta>("TAP_SCHEMA.tables", attCols, false, "schema_name", rankColName, cTableName){

            @Override
            public TableMeta createMeta(ColSet colset, Object[] row) {
                Object index;
                TableMeta tmeta = new TableMeta();
                tmeta.name_ = colset.getCellString(cTableName, row);
                tmeta.type_ = colset.getCellString(cTableType, row);
                tmeta.description_ = colset.getCellString(cDescription, row);
                tmeta.utype_ = colset.getCellString(cUtype, row);
                tmeta.extras_ = colset.getExtras(row);
                Object nrows = tmeta.extras_.remove("nrows");
                if (nrows instanceof String || nrows instanceof Number) {
                    tmeta.nrows_ = nrows.toString();
                }
                if ((index = tmeta.extras_.get("table_index")) instanceof Number) {
                    tmeta.index_ = ((Number)index).intValue();
                }
                return tmeta;
            }
        };
    }

    private static MetaQuerier<SchemaMeta> createSchemaQuerier() {
        String[] stringArray = new String[3];
        final String cSchemaName = "schema_name";
        stringArray[0] = "schema_name";
        final String cDescription = "description";
        stringArray[1] = "description";
        final String cUtype = "utype";
        stringArray[2] = "utype";
        String[] attCols = stringArray;
        String cSchemaIndex = "schema_index";
        return new MetaQuerier<SchemaMeta>("TAP_SCHEMA.schemas", attCols, false, null, null, cSchemaName){

            @Override
            public SchemaMeta createMeta(ColSet colset, Object[] row) {
                SchemaMeta smeta = new SchemaMeta();
                smeta.name_ = colset.getCellString(cSchemaName, row);
                smeta.description_ = colset.getCellString(cDescription, row);
                smeta.utype_ = colset.getCellString(cUtype, row);
                smeta.extras_ = colset.getExtras(row);
                Object index = smeta.extras_.get("schema_index");
                if (index instanceof Number) {
                    smeta.index_ = ((Number)index).intValue();
                }
                return smeta;
            }
        };
    }

    public static void main(String[] args) throws IOException {
        String url = args[0];
        TapService service = TapServices.createDefaultTapService(URLUtils.newURL((String)url));
        int maxrec = 100000;
        ContentCoding coding = ContentCoding.GZIP;
        SchemaMeta[] smetas = new TapSchemaInterrogator(service, maxrec, coding).readSchemas(true, true, true);
        for (int is = 0; is < smetas.length; ++is) {
            SchemaMeta smeta = smetas[is];
            System.out.println("S " + is + ": " + smeta);
            TableMeta[] tmetas = smeta.getTables();
            if (tmetas == null) continue;
            for (int it = 0; it < tmetas.length; ++it) {
                ForeignMeta[] fmetas;
                TableMeta tmeta = tmetas[it];
                System.out.println("\tT " + it + ": " + tmeta);
                ColumnMeta[] cmetas = tmeta.getColumns();
                if (cmetas != null) {
                    for (int ic = 0; ic < cmetas.length; ++ic) {
                        System.out.println("\t\tC " + ic + ": " + cmetas[ic]);
                    }
                }
                if ((fmetas = tmeta.getForeignKeys()) == null) continue;
                for (int ik = 0; ik < fmetas.length; ++ik) {
                    System.out.println("\t\tF " + ik + ": " + fmetas[ik]);
                }
            }
        }
    }

    private static class ColSet {
        final Map<String, Integer> icolMap_;
        final String[] querycols_;
        final String[] extraCols_;

        ColSet(String[] queryCols, String[] stdCols) {
            this.querycols_ = ColSet.toLowers(queryCols);
            HashSet<String> stdcols = new HashSet<String>(Arrays.asList(ColSet.toLowers(stdCols)));
            this.icolMap_ = new HashMap<String, Integer>();
            ArrayList<String> extrasList = new ArrayList<String>();
            int nc = this.querycols_.length;
            for (int ic = 0; ic < nc; ++ic) {
                String col = this.querycols_[ic];
                this.icolMap_.put(col, ic);
                if (stdcols.contains(col)) continue;
                extrasList.add(queryCols[ic]);
            }
            this.extraCols_ = extrasList.toArray(new String[0]);
        }

        Map<String, Object> getExtras(Object[] row) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String col : this.extraCols_) {
                Object obj = this.getCellObject(col.toLowerCase(), row);
                if (Tables.isBlank((Object)obj)) continue;
                map.put(col, obj);
            }
            return map;
        }

        Object getCellObject(String colname, Object[] row) {
            Integer icol = this.icolMap_.get(colname.toLowerCase());
            return icol == null ? null : row[icol];
        }

        String getCellString(String colname, Object[] row) {
            Object obj = this.getCellObject(colname, row);
            return obj == null ? null : obj.toString();
        }

        boolean getCellBoolean(String colname, Object[] row) {
            Object obj = this.getCellObject(colname, row);
            return obj instanceof Number && ((Number)obj).intValue() != 0;
        }

        double getCellDouble(String colname, Object[] row) {
            Object obj = this.getCellObject(colname, row);
            return obj instanceof Number ? ((Number)obj).doubleValue() : Double.NaN;
        }

        private static String[] toLowers(String[] ins) {
            int n = ins.length;
            String[] outs = new String[n];
            for (int i = 0; i < n; ++i) {
                outs[i] = ins[i].toLowerCase();
            }
            return outs;
        }
    }

    public static abstract class MetaQuerier<T> {
        final String tableName_;
        final String[] attCols_;
        final boolean queryStdOnly_;
        final String parentColName_;
        final String rankColName_;
        final String alphaColName_;
        final String[] attPlusParentCols_;

        private MetaQuerier(String tableName, String[] attCols, boolean queryStdOnly, String parentColName, String rankColName, String alphaColName) {
            this.tableName_ = tableName;
            this.attCols_ = attCols;
            this.queryStdOnly_ = queryStdOnly;
            this.parentColName_ = parentColName;
            this.rankColName_ = rankColName;
            this.alphaColName_ = alphaColName;
            int natt = this.attCols_.length;
            ArrayList<String> appList = new ArrayList<String>();
            appList.addAll(Arrays.asList(attCols));
            if (parentColName != null) {
                appList.add(parentColName);
            }
            this.attPlusParentCols_ = appList.toArray(new String[0]);
        }

        public String getTableName() {
            return this.tableName_;
        }

        abstract T createMeta(ColSet var1, Object[] var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, List<T>> readMap(TapSchemaInterrogator tsi, String moreAdql) throws IOException {
            String[] queryCols = this.queryStdOnly_ ? this.attPlusParentCols_ : tsi.getAvailableColumns(this.tableName_);
            ColSet colset = new ColSet(queryCols, this.attPlusParentCols_);
            StarTable table = this.query(tsi, colset, moreAdql);
            LinkedHashMap rmap = new LinkedHashMap();
            try (RowSequence rseq = table.getRowSequence();){
                int iseq = 0;
                while (rseq.next()) {
                    Object[] row = rseq.getRow();
                    String key = colset.getCellString(this.parentColName_, row);
                    RankedMeta value = this.createRankedMeta(colset, row, iseq++);
                    if (!rmap.containsKey(key)) {
                        rmap.put(key, new ArrayList());
                    }
                    ((List)rmap.get(key)).add(value);
                }
            }
            LinkedHashMap<String, List<T>> map = new LinkedHashMap<String, List<T>>();
            for (Map.Entry entry : rmap.entrySet()) {
                map.put((String)entry.getKey(), this.extractMetas((List)entry.getValue()));
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<T> readList(TapSchemaInterrogator tsi, String moreAdql) throws IOException {
            String[] queryCols = this.queryStdOnly_ ? this.attCols_ : tsi.getAvailableColumns(this.tableName_);
            ColSet colset = new ColSet(queryCols, this.attPlusParentCols_);
            StarTable table = this.query(tsi, colset, moreAdql);
            ArrayList<RankedMeta> rlist = new ArrayList<RankedMeta>();
            try (RowSequence rseq = table.getRowSequence();){
                int iseq = 0;
                while (rseq.next()) {
                    rlist.add(this.createRankedMeta(colset, rseq.getRow(), iseq++));
                }
            }
            return this.extractMetas(rlist);
        }

        private StarTable query(TapSchemaInterrogator tsi, ColSet colSet, String moreAdql) throws IOException {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("SELECT ");
            String[] queryCols = colSet.querycols_;
            for (int ic = 0; ic < queryCols.length; ++ic) {
                if (ic > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(syntax_.quoteIfNecessary(queryCols[ic]));
            }
            sbuf.append(" FROM ").append(this.tableName_);
            if (moreAdql != null) {
                sbuf.append(" ").append(moreAdql);
            }
            StarTable result = tsi.executeQuery(tsi.createTapQuery(sbuf.toString()));
            this.checkResultTable(result, queryCols);
            return result;
        }

        private void checkResultTable(StarTable table, String[] cols) throws IOException {
            int ncol = table.getColumnCount();
            if (ncol != cols.length) {
                throw new IOException("Schema query column count mismatch (" + ncol + " != " + cols.length + " )");
            }
        }

        private RankedMeta createRankedMeta(ColSet colset, Object[] row, int iseq) {
            double rank = this.rankColName_ == null ? Double.NaN : colset.getCellDouble(this.rankColName_, row);
            String alpha = this.alphaColName_ == null ? null : colset.getCellString(this.alphaColName_, row);
            return new RankedMeta(this.createMeta(colset, row), rank, alpha, iseq);
        }

        private List<T> extractMetas(List<RankedMeta> rlist) {
            if (this.rankColName_ != null || this.alphaColName_ != null) {
                boolean hasRanks = false;
                boolean hasAlphas = false;
                for (RankedMeta m : rlist) {
                    hasRanks = hasRanks || !Double.isNaN(m.rank_);
                    hasAlphas = hasAlphas || m.alpha_ != null;
                }
                if (hasRanks || hasAlphas) {
                    Collections.sort(rlist);
                }
            }
            ArrayList mlist = new ArrayList(rlist.size());
            for (RankedMeta r : rlist) {
                mlist.add(r.meta_);
            }
            return mlist;
        }

        private class RankedMeta
        implements Comparable<RankedMeta> {
            final T meta_;
            final double rank_;
            final String alpha_;
            final int iseq_;

            RankedMeta(T meta, double rank, String alpha, int iseq) {
                this.meta_ = meta;
                this.rank_ = rank;
                this.alpha_ = alpha;
                this.iseq_ = iseq;
            }

            @Override
            public int compareTo(RankedMeta other) {
                int rc = (int)Math.signum(this.toComparable(this.rank_) - this.toComparable(other.rank_));
                if (rc != 0) {
                    return rc;
                }
                if (this.alpha_ != null || other.alpha_ != null) {
                    if (this.alpha_ == null) {
                        return 1;
                    }
                    if (other.alpha_ == null) {
                        return -1;
                    }
                    return this.alpha_.compareTo(other.alpha_);
                }
                int sc = (int)Math.signum(this.iseq_ - other.iseq_);
                if (sc != 0) {
                    return sc;
                }
                return (int)Math.signum(this.hashCode() - other.hashCode());
            }

            private double toComparable(double rank) {
                return Double.isNaN(rank) ? 4.4942328371557893E307 : rank;
            }
        }
    }
}

