/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.TapServiceFinder;

public class TapServiceTreeModel
implements TreeModel {
    private final String rootLabel_;
    private final TapServiceFinder.Service[] services_;
    private final Map<TapServiceFinder.Service, TapServiceFinder.Table[]> tableMap_;
    private final List<TreeModelListener> listeners_;
    private static final Comparator<TapServiceFinder.Table> BY_TABLE_NAME = TapServiceTreeModel.byTableName();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    protected TapServiceTreeModel(String rootLabel, TapServiceFinder.Service[] services, Map<TapServiceFinder.Service, TapServiceFinder.Table[]> tableMap) {
        this.rootLabel_ = rootLabel;
        this.services_ = services;
        this.tableMap_ = tableMap;
        this.listeners_ = new ArrayList<TreeModelListener>();
        if (tableMap != null) {
            for (TapServiceFinder.Service service : services) {
                if (tableMap.get(service) != null) continue;
                throw new IllegalArgumentException("No table list for " + service);
            }
        }
    }

    public TapServiceTreeModel(String rootLabel) {
        this(rootLabel, new TapServiceFinder.Service[0], null);
    }

    @Override
    public Object getRoot() {
        return this.services_;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.asNode(node).isLeaf();
    }

    @Override
    public int getChildCount(Object parent) {
        Object[] children = this.asNode((Object)parent).children_;
        return children == null ? 0 : children.length;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.asNode((Object)parent).children_[index];
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        Object[] children;
        if (parent != null && child != null && (children = this.asNode((Object)parent).children_) != null) {
            int nc = children.length;
            for (int ic = 0; ic < nc; ++ic) {
                if (children[ic] != child) continue;
                return ic;
            }
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        assert (false) : "Tree is not editable from GUI";
    }

    @Override
    public void addTreeModelListener(TreeModelListener lnr) {
        this.listeners_.add(lnr);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener lnr) {
        this.listeners_.remove(lnr);
    }

    public static TreePath getServicePath(TreePath path) {
        for (int i = 0; i < path.getPathCount(); ++i) {
            if (!(path.getPathComponent(i) instanceof TapServiceFinder.Service)) continue;
            Object[] spath = new Object[i + 1];
            System.arraycopy(path.getPath(), 0, spath, 0, i + 1);
            return new TreePath(spath);
        }
        return null;
    }

    public static TapServiceFinder.Service getService(TreePath path) {
        TreePath servicePath;
        if (path != null && (servicePath = TapServiceTreeModel.getServicePath(path)) != null) {
            return (TapServiceFinder.Service)servicePath.getLastPathComponent();
        }
        return null;
    }

    public static TapServiceFinder.Table getTable(TreePath path) {
        Object node;
        if (path != null && (node = path.getLastPathComponent()) instanceof TapServiceFinder.Table) {
            return (TapServiceFinder.Table)node;
        }
        return null;
    }

    public static TapServiceTreeModel readTreeModel(TapServiceFinder.Service[] allServices, TapServiceFinder finder, TapServiceFinder.Constraint constraint) throws IOException {
        if (constraint == null) {
            return TapServiceTreeModel.createModel(allServices);
        }
        TapServiceFinder.Table[] tables = finder.readSelectedTables(constraint);
        TapServiceFinder.Service[] extraServices = null;
        for (TapServiceFinder.Target target : constraint.getTargets()) {
            if (!target.isServiceMeta()) continue;
            String[] keywords = constraint.getKeywords();
            boolean isAnd = constraint.isAndKeywords();
            ArrayList<TapServiceFinder.Service> extras = new ArrayList<TapServiceFinder.Service>();
            for (TapServiceFinder.Service serv : allServices) {
                if (!target.matchesService(serv, keywords, isAnd)) continue;
                extras.add(serv);
            }
            extraServices = extras.toArray(new TapServiceFinder.Service[0]);
        }
        return TapServiceTreeModel.createModel(allServices, tables, extraServices);
    }

    private static TapServiceTreeModel createModel(TapServiceFinder.Service[] allServices, TapServiceFinder.Table[] tables, TapServiceFinder.Service[] extraServices) {
        LinkedHashMap<String, TapServiceFinder.Service> serviceMap = new LinkedHashMap<String, TapServiceFinder.Service>();
        for (TapServiceFinder.Service serv : allServices) {
            serviceMap.put(serv.getId(), serv);
        }
        LinkedHashMap tMap = new LinkedHashMap();
        if (extraServices != null) {
            for (TapServiceFinder.Service service : extraServices) {
                tMap.put(service.getId(), new ArrayList());
            }
        }
        for (TapServiceFinder.Table table : tables) {
            String ivoid = table.getServiceId();
            if (!tMap.containsKey(ivoid)) {
                tMap.put(ivoid, new ArrayList());
            }
            ((List)tMap.get(ivoid)).add(table);
        }
        LinkedHashMap<TapServiceFinder.Service, TapServiceFinder.Table[]> tableMap = new LinkedHashMap<TapServiceFinder.Service, TapServiceFinder.Table[]>();
        for (Map.Entry entry : tMap.entrySet()) {
            TapServiceFinder.Service service;
            service = (TapServiceFinder.Service)serviceMap.get(entry.getKey());
            if (service == null) continue;
            TapServiceFinder.Table[] ts = ((List)entry.getValue()).toArray(new TapServiceFinder.Table[0]);
            Arrays.sort(ts, BY_TABLE_NAME);
            tableMap.put(service, ts);
        }
        TapServiceFinder.Service[] displayServices = tableMap.keySet().toArray(new TapServiceFinder.Service[0]);
        Arrays.sort(displayServices, TapServiceTreeModel.byTableCount(tableMap));
        String label = "Selected TAP services (" + displayServices.length + "/" + allServices.length + ")";
        return new TapServiceTreeModel(label, displayServices, tableMap);
    }

    private static TapServiceTreeModel createModel(TapServiceFinder.Service[] services) {
        TapServiceFinder.Service[] displayServices = (TapServiceFinder.Service[])services.clone();
        Arrays.sort(displayServices, TapServiceTreeModel.byTableCount(null));
        String label = "All TAP services (" + services.length + ")";
        return new TapServiceTreeModel(label, displayServices, null);
    }

    private Node asNode(final Object item) {
        if (item instanceof TapServiceFinder.Service[]) {
            return new Node((TapServiceFinder.Service[])item, null){

                @Override
                public String toString() {
                    return TapServiceTreeModel.this.rootLabel_;
                }
            };
        }
        if (item instanceof TapServiceFinder.Service) {
            final TapServiceFinder.Service service = (TapServiceFinder.Service)item;
            return new Node(this.tableMap_ == null ? null : (Object[])this.tableMap_.get(service), ResourceIcon.NODE_SERVICE){

                @Override
                public String toString() {
                    int ntTotal = service.getTableCount();
                    int ntPresent = this.children_ == null ? -1 : this.children_.length;
                    StringBuffer cbuf = new StringBuffer().append(" (");
                    if (ntPresent >= 0) {
                        cbuf.append(ntPresent).append("/");
                    }
                    cbuf.append(ntTotal <= 0 ? "?" : Integer.toString(ntTotal)).append(")");
                    return TapServiceTreeModel.getServiceLabel(service) + cbuf.toString();
                }
            };
        }
        if (item instanceof TapServiceFinder.Table) {
            final TapServiceFinder.Table table = (TapServiceFinder.Table)item;
            return new Node(null, ResourceIcon.NODE_TABLE){

                @Override
                public String toString() {
                    String descrip = table.getDescription();
                    String txt = table.getName();
                    if (descrip != null) {
                        txt = txt + " - " + descrip.replaceAll("\\s+", " ");
                    }
                    return txt;
                }
            };
        }
        assert (false);
        return new Node(null, null){

            @Override
            public String toString() {
                return item.toString();
            }
        };
    }

    private static String getServiceLabel(TapServiceFinder.Service service) {
        String name = service.getName();
        if (name != null && name.trim().length() > 0) {
            return name.trim();
        }
        String title = service.getTitle();
        if (title != null && title.trim().length() > 0) {
            return title.trim();
        }
        String ivoid = service.getId();
        if (ivoid != null && ivoid.trim().length() > 0) {
            return ivoid.trim();
        }
        return "<nameless>";
    }

    private static Comparator<TapServiceFinder.Service> byTableCount(final Map<TapServiceFinder.Service, TapServiceFinder.Table[]> tableMap) {
        return new Comparator<TapServiceFinder.Service>(){

            @Override
            public int compare(TapServiceFinder.Service s1, TapServiceFinder.Service s2) {
                int dc;
                if (tableMap != null && (dc = ((TapServiceFinder.Table[])tableMap.get(s2)).length - ((TapServiceFinder.Table[])tableMap.get(s1)).length) != 0) {
                    return dc;
                }
                int dt = s2.getTableCount() - s1.getTableCount();
                if (dt != 0) {
                    return dt;
                }
                int dn = TapServiceTreeModel.getServiceLabel(s1).compareTo(TapServiceTreeModel.getServiceLabel(s2));
                if (dn != 0) {
                    return dn;
                }
                int da = s2.hashCode() - s1.hashCode();
                return da;
            }
        };
    }

    private static Comparator<TapServiceFinder.Table> byTableName() {
        return new Comparator<TapServiceFinder.Table>(){

            @Override
            public int compare(TapServiceFinder.Table t1, TapServiceFinder.Table t2) {
                int cmp;
                String n1 = t1.getName();
                String n2 = t2.getName();
                if (n1 != null && n2 != null && (cmp = n1.compareTo(n2)) != 0) {
                    return cmp;
                }
                return t1.hashCode() - t2.hashCode();
            }
        };
    }

    private static Icon createIcon(String filename) {
        try {
            return new ImageIcon(TapServiceTreeModel.class.getResource(filename));
        }
        catch (Exception e) {
            logger_.warning("No icon " + filename);
            return null;
        }
    }

    public static TreeCellRenderer createCellRenderer() {
        final Box line = Box.createHorizontalBox();
        final DefaultTreeCellRenderer rend1 = new DefaultTreeCellRenderer();
        final DefaultTreeCellRenderer rend2 = new DefaultTreeCellRenderer();
        final Color fg2 = UIManager.getColor("Label.disabledForeground");
        line.add(rend1);
        line.add(rend2);
        return new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int irow, boolean hasFocus) {
                Icon icon;
                String text2;
                String text;
                TreeModel model = tree.getModel();
                if (model instanceof TapServiceTreeModel) {
                    Node node = ((TapServiceTreeModel)model).asNode(value);
                    text = node.toString();
                    text2 = value instanceof TapServiceFinder.Service ? " - " + ((TapServiceFinder.Service)value).getId() : null;
                    icon = node.getIcon();
                } else {
                    text = value.toString();
                    text2 = null;
                    icon = null;
                }
                if (isSelected && !(value instanceof TapServiceFinder.Service)) {
                    hasFocus = true;
                    isSelected = false;
                }
                Component comp1 = rend1.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, irow, hasFocus);
                Component comp2 = rend2.getTreeCellRendererComponent(tree, value, false, isExpanded, isLeaf, irow, false);
                assert (comp1 == rend1);
                assert (comp2 == rend2);
                rend1.setText(text);
                rend2.setText(text2);
                rend2.setForeground(fg2);
                rend2.setIcon(null);
                if (icon != null) {
                    rend1.setIcon(icon);
                }
                line.revalidate();
                return line;
            }
        };
    }

    private static abstract class Node {
        final Object[] children_;
        final Icon icon_;

        Node(Object[] children, Icon icon) {
            this.children_ = children;
            this.icon_ = icon;
        }

        boolean isLeaf() {
            return this.children_ == null || this.children_.length == 0;
        }

        Icon getIcon() {
            return this.icon_;
        }

        public abstract String toString();
    }
}

