/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.StdCapabilityInterface;
import uk.ac.starlink.vo.TapCapabilitiesDoc;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.TapVersion;

public class TapServices {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    private static final TapService REGTAP = TapServices.createTapService("http://reg.g-vo.org/tap", TapVersion.V11);

    private TapServices() {
    }

    public static TapService getRegTapService() {
        return REGTAP;
    }

    public static TapService getRegTap12Service() {
        return REGTAP;
    }

    public static TapService createDefaultTapService(URL baseUrl) {
        return TapServices.createTapService(baseUrl, TapVersion.V10);
    }

    public static TapService createTapService(URL baseUrl, final TapVersion tapVersion) {
        final String identity = baseUrl.toString();
        final URL sync = TapServices.appendPath(baseUrl, "/sync");
        final URL async = TapServices.appendPath(baseUrl, "/async");
        final URL tables = TapServices.appendPath(baseUrl, "/tables");
        final URL capabilities = TapServices.appendPath(baseUrl, "/capabilities");
        final URL availability = TapServices.appendPath(baseUrl, "/availability");
        final URL examples = TapServices.appendPath(baseUrl, "/examples");
        return new TapService(){

            @Override
            public String getIdentity() {
                return identity;
            }

            @Override
            public URL getSyncEndpoint() {
                return sync;
            }

            @Override
            public URL getAsyncEndpoint() {
                return async;
            }

            @Override
            public URL getTablesEndpoint() {
                return tables;
            }

            @Override
            public URL getCapabilitiesEndpoint() {
                return capabilities;
            }

            @Override
            public URL getAvailabilityEndpoint() {
                return availability;
            }

            @Override
            public URL getExamplesEndpoint() {
                return examples;
            }

            @Override
            public TapVersion getTapVersion() {
                return tapVersion;
            }
        };
    }

    public static TapService createTapService(String baseUrl, TapVersion tapVersion) {
        try {
            return TapServices.createTapService(URLUtils.newURL((String)baseUrl), tapVersion);
        }
        catch (MalformedURLException e) {
            logger_.warning("Bad URL for TAP service: " + baseUrl);
            return null;
        }
    }

    public static TapService[] createTapServices(URL baseUrl, TapCapabilitiesDoc capsDoc) {
        StdCapabilityInterface[] intfs;
        ArrayList<TapService> taps = new ArrayList<TapService>();
        for (StdCapabilityInterface intf : intfs = capsDoc.getInterfaces()) {
            URL accessUrl = TapServices.getBaseUrl(intf.getAccessUrl());
            if (!Capability.TAP_IVOID.equalsIvoid(new Ivoid(intf.getStandardId())) || !"std".equals(intf.getRole()) || accessUrl == null) continue;
            TapVersion version = TapVersion.fromString(intf.getVersion());
            taps.add(TapServices.createTapService(accessUrl, version));
        }
        if (taps.size() == 0) {
            taps.add(TapServices.createTapService(baseUrl, TapVersion.V10));
        }
        return taps.toArray(new TapService[0]);
    }

    private static URL getBaseUrl(String accessUrl) {
        if (accessUrl == null) {
            return null;
        }
        try {
            return URLUtils.newURL((String)accessUrl);
        }
        catch (MalformedURLException e) {
            logger_.warning("Ignore badly formed TAP base URL: " + accessUrl);
            return null;
        }
    }

    private static URL appendPath(URL base, String subPath) {
        try {
            return URLUtils.newURL((String)(base.toString() + subPath));
        }
        catch (MalformedURLException e) {
            assert (false);
            throw (RuntimeException)new IllegalArgumentException("Bad URL???").initCause(e);
        }
    }
}

