/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import ari.ucidy.UCD;
import ari.ucidy.UCDParser;
import ari.ucidy.UCDWord;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class UcdStatus {
    private final Code code_;
    private final String message_;
    private static final Map<String, UcdStatus> statusMap_ = UcdStatus.createCache(200);
    private static final UCDParser ucdParser_ = UcdStatus.createParser();
    private static final Collection<String> ucd1s_ = Collections.unmodifiableSet(UcdStatus.readUcd1s());
    private static final Collection<String> ucd1Or1plusses_ = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("PHYS", "POS", "SPECT", "STAT", "TIME")));
    private static final Pattern VOX_REGEX = Pattern.compile("VOX:[A-Za-z_]+");

    protected UcdStatus(Code code, String message) {
        this.code_ = code;
        this.message_ = message;
    }

    public Code getCode() {
        return this.code_;
    }

    public String getMessage() {
        return this.message_;
    }

    public static UcdStatus getStatus(String ucd) {
        return statusMap_.computeIfAbsent(ucd, UcdStatus::createStatus);
    }

    public static UCDParser getParser() {
        return ucdParser_;
    }

    private static UCDParser createParser() {
        Logger.getLogger("ari.ucidy").setLevel(Level.OFF);
        return UCDParser.defaultParser;
    }

    private static UcdStatus createStatus(String ucd) {
        if (ucd == null || ucd.trim().length() == 0) {
            return null;
        }
        if (ucd1s_.contains(ucd.toUpperCase()) && !ucd1Or1plusses_.contains(ucd.toUpperCase())) {
            return new UcdStatus(Code.UCD1, "UCD1, not UCD1+");
        }
        if (VOX_REGEX.matcher(ucd).matches()) {
            return new UcdStatus(Code.VOX, "SIAv1-style VOX namespace");
        }
        UCD pucd = ucdParser_.parse(ucd);
        StringBuffer sbuf = new StringBuffer();
        Iterator it = pucd.getErrors();
        while (it.hasNext()) {
            String line = ((String)it.next()).replaceFirst(" *!$", "");
            if (sbuf.length() > 0 && line.length() > 0) {
                sbuf.append("; ");
            }
            sbuf.append(line);
        }
        String message = sbuf.length() > 0 ? sbuf.toString() : null;
        boolean hasNamespace = false;
        boolean isValid = true;
        boolean isRecognised = true;
        boolean isRecommended = true;
        boolean isDeprecated = false;
        for (UCDWord word : pucd) {
            if (word == null) continue;
            hasNamespace = hasNamespace || word.namespace != null;
            isValid = isValid && word.valid;
            isRecognised = isRecognised && word.recognised;
            isRecommended = isRecommended && word.recommended;
            isDeprecated = isDeprecated || word.isDeprecated();
        }
        if (!isValid) {
            return new UcdStatus(Code.BAD_SYNTAX, message);
        }
        if (hasNamespace) {
            return new UcdStatus(Code.NAMESPACE, message);
        }
        if (isDeprecated) {
            return new UcdStatus(Code.DEPRECATED, message);
        }
        if (!isRecognised) {
            return new UcdStatus(Code.UNKNOWN_WORD, message);
        }
        if (!isRecommended) {
            return new UcdStatus(Code.DEPRECATED, message);
        }
        return new UcdStatus(pucd.isFullyValid() ? Code.OK : Code.BAD_SEQUENCE, message);
    }

    private static Set<String> readUcd1s() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Iterator it = uk.ac.starlink.table.UCD.getUCDs();
        while (it.hasNext()) {
            set.add(((uk.ac.starlink.table.UCD)it.next()).getID());
        }
        return set;
    }

    private static Map<String, UcdStatus> createCache(final int limit) {
        return Collections.synchronizedMap(new LinkedHashMap<String, UcdStatus>(){

            @Override
            public boolean removeEldestEntry(Map.Entry<String, UcdStatus> entry) {
                return this.size() > limit;
            }
        });
    }

    public static enum Code {
        OK(' '),
        UCD1(' '),
        VOX(' '),
        BAD_SYNTAX('E'),
        BAD_SEQUENCE('E'),
        UNKNOWN_WORD('E'),
        NAMESPACE(' '),
        DEPRECATED('W');

        private final char stat_;

        private Code(char stat) {
            this.stat_ = stat;
            switch (stat) {
                case ' ': 
                case 'E': 
                case 'W': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public boolean isError() {
            return this.stat_ == 'E';
        }

        public boolean isWarning() {
            return this.stat_ == 'W';
        }
    }
}

