/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgentUtil {
    public static final String PURPOSE_TEST = "test";
    public static final String PURPOSE_COPY = "copy";
    public static final String IVOA_PREFIX = "IVOA-";
    public static final String COMMENT_TEST = UserAgentUtil.createOpPurposeComment("test", null);
    public static final String COMMENT_COPY = UserAgentUtil.createOpPurposeComment("copy", null);
    public static final String AGENT_PROPNAME = "http.agent";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    private UserAgentUtil() {
    }

    public static void pushUserAgentToken(String token) {
        if (token != null && token.trim().length() > 0) {
            String agent0 = System.getProperty(AGENT_PROPNAME);
            String agent1 = agent0 == null || agent0.trim().length() == 0 ? token : agent0.trim() + " " + token;
            System.setProperty(AGENT_PROPNAME, agent1);
            logger_.info("Appended User-Agent token: http.agent is now \"" + agent1 + "\"");
        }
    }

    public static void popUserAgentToken(String token) {
        if (token != null && token.trim().length() > 0) {
            int index;
            String agent0 = System.getProperty(AGENT_PROPNAME);
            int n = index = agent0 == null ? -1 : agent0.indexOf(token);
            if (index >= 0) {
                String agent1 = agent0.substring(0, index).trim();
                if (agent1.length() == 0) {
                    System.clearProperty(AGENT_PROPNAME);
                    logger_.info("Removed User-Agent token: http.agent is now empty");
                } else {
                    System.setProperty(AGENT_PROPNAME, agent1);
                    logger_.info("Removed User-Agent token: http.agent is now \"" + agent1 + "\"");
                }
            } else {
                logger_.warning("Failed to remove User-Agent token \"" + token + "\" - " + AGENT_PROPNAME + " is still \"" + agent0 + "\"");
            }
        }
    }

    public static String createOpPurposeComment(String purpose, String extra) {
        if (purpose.indexOf(32) >= 0) {
            throw new IllegalArgumentException("Purpose contains whitespace");
        }
        StringBuffer sbuf = new StringBuffer().append("(").append(IVOA_PREFIX).append(purpose);
        if (extra != null && extra.trim().length() > 0) {
            if (extra.indexOf(40) >= 0 || extra.indexOf(41) >= 0) {
                throw new IllegalArgumentException("Comment text contains parentheses");
            }
            sbuf.append(" ").append(extra.trim());
        }
        sbuf.append(")");
        return sbuf.toString();
    }

    public static String[] parseProducts(String productsTxt) {
        boolean allowComment = true;
        String tchar = "[-!#$%&'*+.^_`|~a-zA-Z0-9]";
        String token = tchar + "+";
        String product = token + "(/" + token + ")?";
        String comment = "\\(([^\\\\)]|\\\\.)*\\)";
        String wordRegex = "\\s+(" + product + "|" + comment + ")";
        Pattern wordPattern = Pattern.compile(wordRegex);
        ArrayList<String> list = new ArrayList<String>();
        String txt = " " + productsTxt;
        while (txt.trim().length() > 0) {
            Matcher matcher = wordPattern.matcher(txt);
            if (matcher.lookingAt()) {
                boolean isComment;
                String word = matcher.group();
                boolean bl = isComment = word.trim().charAt(0) == '(';
                if (isComment) {
                    StringBuffer sbuf = new StringBuffer();
                    for (int ic = 0; ic < word.length(); ++ic) {
                        char c = word.charAt(ic);
                        if (c == '\\') continue;
                        sbuf.append(c);
                    }
                    list.add(sbuf.toString().trim());
                } else {
                    list.add(word.trim());
                }
                txt = txt.substring(matcher.end());
                continue;
            }
            throw new IllegalArgumentException("Bad product syntax");
        }
        return list.toArray(new String[0]);
    }
}

