/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo.datalink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.NodeList;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.vo.datalink.LinkColMap;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.datalink.ServiceDescriptor;
import uk.ac.starlink.votable.datalink.ServiceDescriptorFactory;

public abstract class LinksDoc {
    public abstract StarTable getResultTable();

    public abstract LinkColMap getColumnMap();

    public abstract ServiceDescriptor[] getServiceDescriptors();

    public static LinksDoc createLinksDoc(final StarTable resultTable, final LinkColMap colMap, final ServiceDescriptor[] servDescriptors) {
        return new LinksDoc(){

            @Override
            public StarTable getResultTable() {
                return resultTable;
            }

            @Override
            public LinkColMap getColumnMap() {
                return colMap;
            }

            @Override
            public ServiceDescriptor[] getServiceDescriptors() {
                return servDescriptors;
            }
        };
    }

    public static LinksDoc createLinksDoc(StarTable table) {
        LinkColMap colMap = LinkColMap.getMap(table);
        ServiceDescriptor[] sds = LinksDoc.getServiceDescriptors(table);
        return LinksDoc.createLinksDoc(table, colMap, sds);
    }

    public static LinksDoc createLinksDoc(VOElement el) throws IOException {
        VOStarTable[] tables = LinksDoc.readResultTables(el);
        ServiceDescriptor[] descriptors = new ServiceDescriptorFactory().readAllServiceDescriptors(el);
        if (tables.length == 0) {
            throw new IOException("No results table found");
        }
        if (tables.length > 1) {
            throw new IOException("Multiple (" + tables.length + ") result tables in Datalink document");
        }
        VOStarTable resultTable = tables[0];
        LinkColMap colMap = LinkColMap.getMap((StarTable)resultTable);
        return LinksDoc.createLinksDoc((StarTable)resultTable, colMap, descriptors);
    }

    public static LinksDoc randomAccess(LinksDoc ldoc) throws IOException {
        return ldoc.getResultTable().isRandom() ? ldoc : LinksDoc.createLinksDoc(Tables.randomTable((StarTable)ldoc.getResultTable()), ldoc.getColumnMap(), ldoc.getServiceDescriptors());
    }

    public static ServiceDescriptor[] getServiceDescriptors(StarTable table) {
        ArrayList<ServiceDescriptor> sdList = new ArrayList<ServiceDescriptor>();
        for (DescribedValue param : table.getParameters()) {
            Object value = param.getValue();
            if (!(value instanceof ServiceDescriptor)) continue;
            sdList.add((ServiceDescriptor)value);
        }
        return sdList.toArray(new ServiceDescriptor[0]);
    }

    public static boolean isLinksResponse(StarTable table, int nMistake) {
        if (table == null) {
            return false;
        }
        int ncol = table.getColumnCount();
        HashSet correctDefs = new HashSet();
        HashSet presentDefs = new HashSet();
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo cinfo = table.getColumnInfo(icol);
            LinkColMap.ColDef<?> coldef = LinkColMap.COLDEF_MAP.get(cinfo.getName());
            if (coldef == null || !coldef.getContentClass().isAssignableFrom(cinfo.getContentClass())) continue;
            presentDefs.add(coldef);
            String stdUcd = coldef.getUcd();
            if (stdUcd != null && !stdUcd.equals(cinfo.getUCD())) continue;
            correctDefs.add(coldef);
        }
        if (!(presentDefs.contains(LinkColMap.COL_ACCESSURL) || presentDefs.contains(LinkColMap.COL_ERRORMESSAGE) || presentDefs.contains(LinkColMap.COL_SERVICEDEF))) {
            return false;
        }
        int nMissing = 0;
        for (LinkColMap.ColDef<?> stdCol : LinkColMap.COLDEF_MAP.values()) {
            if (!stdCol.isRequired() || correctDefs.contains(stdCol)) continue;
            ++nMissing;
        }
        return nMissing <= nMistake;
    }

    private static VOStarTable[] readResultTables(VOElement el) throws IOException {
        ArrayList<VOStarTable> tableList = new ArrayList<VOStarTable>();
        NodeList resourceList = el.getElementsByVOTagName("RESOURCE");
        for (int i = 0; i < resourceList.getLength(); ++i) {
            VOElement resEl = (VOElement)resourceList.item(i);
            if (!"results".equals(resEl.getAttribute("type"))) continue;
            for (VOElement tableEl : resEl.getChildrenByName("TABLE")) {
                tableList.add(new VOStarTable((TableElement)tableEl));
            }
        }
        return tableList.toArray(new VOStarTable[0]);
    }
}

