/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.error.YAMLException;
import uk.ac.starlink.ecsv.EcsvColumn;
import uk.ac.starlink.ecsv.EcsvDecoder;
import uk.ac.starlink.ecsv.EcsvFormatException;
import uk.ac.starlink.ecsv.EcsvMeta;
import uk.ac.starlink.ecsv.YamlParser;

public class SnakeYamlParser
implements YamlParser {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ecsv");

    @Override
    public EcsvMeta parseMeta(String[] lines) throws EcsvFormatException {
        Object yaml;
        StringBuffer sbuf = new StringBuffer();
        for (String line : lines) {
            sbuf.append(line).append('\n');
        }
        try {
            yaml = new Yaml().load(sbuf.toString());
        }
        catch (MarkedYAMLException e) {
            throw new EcsvFormatException("YAML parse error: " + e.getProblem(), e);
        }
        catch (YAMLException e) {
            throw new EcsvFormatException("YAML parse error: " + e.getMessage(), e);
        }
        if (yaml == null) {
            throw new EcsvFormatException("No YAML content");
        }
        if (!(yaml instanceof Map)) {
            throw new EcsvFormatException("Unexpected YAML content " + yaml.getClass().getName());
        }
        Map map = (Map)yaml;
        final char delimiter = this.getDelimiter(map.get("delimiter"));
        final Map<?, ?> tableMeta = this.getMeta(map.get("meta"));
        final EcsvColumn[] columns = this.getColumns(map.get("datatype"));
        final String schema = SnakeYamlParser.getStringValue(map, "schema");
        return new EcsvMeta(){

            @Override
            public char getDelimiter() {
                return delimiter;
            }

            @Override
            public EcsvColumn<?>[] getColumns() {
                return columns;
            }

            @Override
            public Map<?, ?> getTableMeta() {
                return tableMeta;
            }

            @Override
            public String getSchema() {
                return schema;
            }
        };
    }

    private char getDelimiter(Object delimObj) {
        if (delimObj instanceof String && ((String)delimObj).length() == 1) {
            return ((String)delimObj).charAt(0);
        }
        if (delimObj instanceof Character) {
            return ((Character)delimObj).charValue();
        }
        if (delimObj != null) {
            logger_.warning("Unexpected ECSV delimiter declaration\"" + delimObj + "\"");
        }
        return ' ';
    }

    private Map<?, ?> getMeta(Object metaObj) {
        if (metaObj == null) {
            return null;
        }
        if (metaObj instanceof Map) {
            return (Map)metaObj;
        }
        logger_.warning("Ignoring malformed table metadata of type " + metaObj.getClass().getName());
        return null;
    }

    private EcsvColumn<?>[] getColumns(Object colsObj) throws EcsvFormatException {
        if (colsObj instanceof List) {
            return this.getColumnsArray(((List)colsObj).toArray());
        }
        if (colsObj instanceof Object[]) {
            return this.getColumnsArray((Object[])colsObj);
        }
        if (colsObj == null) {
            throw new EcsvFormatException("No datatype array in metadata");
        }
        throw new EcsvFormatException("No comprehensible datatype array in metadata");
    }

    private EcsvColumn<?>[] getColumnsArray(Object[] colObjs) throws EcsvFormatException {
        int ncol = colObjs.length;
        EcsvColumn[] cols = new EcsvColumn[ncol];
        for (int ic = 0; ic < ncol; ++ic) {
            Object colObj = colObjs[ic];
            if (!(colObj instanceof Map)) {
                if (colObj == null) {
                    throw new EcsvFormatException("Null element in column metadata array");
                }
                throw new EcsvFormatException("Unexpected element type " + colObj.getClass().getName() + " in column metadata array");
            }
            cols[ic] = this.createColumn((Map)colObj);
        }
        return cols;
    }

    private EcsvColumn<?> createColumn(Map<?, ?> colMap) throws EcsvFormatException {
        String name = SnakeYamlParser.getStringValue(colMap, "name");
        String datatype = SnakeYamlParser.getStringValue(colMap, "datatype");
        if (name == null) {
            throw new EcsvFormatException("Column has no name");
        }
        if (datatype == null) {
            throw new EcsvFormatException("Column " + name + " has no datatype");
        }
        String subtype = SnakeYamlParser.getStringValue(colMap, "subtype");
        EcsvDecoder<?> decoder = EcsvDecoder.createDecoder(datatype, subtype);
        if (decoder == null) {
            throw new EcsvFormatException("Unknown/unsupported datatype " + datatype);
        }
        return SnakeYamlParser.createColumn(name, decoder, colMap);
    }

    private static <T> EcsvColumn<T> createColumn(final String name, final EcsvDecoder<T> decoder, Map<?, ?> colMap) {
        final String unit = SnakeYamlParser.getStringValue(colMap, "unit");
        final String format = SnakeYamlParser.getStringValue(colMap, "format");
        final String description = SnakeYamlParser.getStringValue(colMap, "description");
        final String datatype = SnakeYamlParser.getStringValue(colMap, "datatype");
        Object mapObj = colMap.get("meta");
        final Map meta = mapObj instanceof Map ? (Map)mapObj : null;
        return new EcsvColumn<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public EcsvDecoder<T> getDecoder() {
                return decoder;
            }

            @Override
            public String getDatatype() {
                return datatype;
            }

            @Override
            public String getUnit() {
                return unit;
            }

            @Override
            public String getFormat() {
                return format;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public Map<?, ?> getMeta() {
                return meta;
            }
        };
    }

    private static String getStringValue(Map<?, ?> map, String key) {
        Object valueObj = map.get(key);
        if (valueObj instanceof String) {
            return (String)valueObj;
        }
        if (valueObj == null) {
            return null;
        }
        logger_.warning("Non-string value for key \"" + key + "\"");
        return null;
    }
}

